import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;
import java.io.*;


/**These routines help produce the polyhedron coverings**/

public class PolyProbe {

    public static Vector move(Vector V,double r,int k) {
            GoldenVector GW=DataPartition.interstitial(k);
	    Vector W=GW.toVector(); 
            Vector X=Vector.plus(V,W.scale(r));
	    return(X);
    }

    public static Vector4 initial(int LB,int branch) {
	Polyhedron P=DataRenorm.getB(LB,branch);
	Vector V=P.getCenter();
	Vector4 W=new Vector4(V.x[0],V.x[1],V.x[2],0);
	return(W);
    }


    /**For the A filling**/



    public static Vector4 suggestPointA(Polyhedron[] LIST,Vector[] DONE,int tot,int index,int LA,int LB,int branch) {
	if(tot==0) return(initial(LA,LB,branch));

	for(int i=index;i<tot;++i) {
	    Polyhedron P=LIST[i];
	    if(P!=null) {
	      for(int j=0;j<P.count;++j) {
		Vector V=P.V[j];
		for(int k=0;k<50;++k) {
		    Vector X=move(V,.00001,k);
		    if(Lists.match(X,DONE,tot)==false) {
		      boolean test1=Lists.inside(LIST,tot,X);
		      boolean test2=DataRenorm.insideA(LA,LB,branch,X);
		      if((test1==false)&&(test2==true)) {
			  Vector4 X4=new Vector4(X.x[0],X.x[1],X.x[2],i);
			  return(X4);
		      }
		    }
		}
	      }
	    }
	}
	return(null);
    }



    /**For the B filling**/

    public static Vector4 initial(int LA,int LB,int branch) {
	Polyhedron P=DataRenorm.getA(LA,LB,branch);
	Vector V=P.getCenter();
	Vector4 W=new Vector4(V.x[0],V.x[1],V.x[2],0);
	return(W);
    }


    public static Vector4 suggestPointB(Polyhedron[] LIST,Vector[] DONE,int tot,int index,int LB,int branch) {
	if(tot==0) return(initial(LB,branch));

	for(int i=index;i<tot;++i) {
	    Polyhedron P=LIST[i];
	    if(P!=null) {
	      for(int j=0;j<P.count;++j) {
		Vector V=P.V[j];
		for(int k=0;k<50;++k) {
		    Vector X=move(V,.00001,k);
		    if(Lists.match(X,DONE,tot)==false) {
		      boolean test1=Lists.inside(LIST,tot,X);
		      boolean test2=DataRenorm.insideB(LB,branch,X);
		      if((test1==false)&&(test2==true)) {
			  Vector4 X4=new Vector4(X.x[0],X.x[1],X.x[2],i);
			  return(X4);
		      }
		    }
		}
	      }
	    }
	}
	System.out.println("done");
	return(null);
    }








}
