import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;

/**This class is a polygon class in which the
individual points are 3D vectors.  Usually we
use the other polygon class, PolyWedge, but
these routines are useful for our routines
which intersect two PolyWedges.  We find it
useful to convert the PolyWedges into PolyVectors
and then use vector algebra.**/


public class PolyVector {
    Vector[] V=new Vector[10];
    int count,radius;

    public PolyVector() {
	for(int i=0;i<9;++i) 
	    V[i]=new Vector();
    }

    public PolyVector(PolyVector Q) {
	this.count=Q.count;
	for(int i=0;i<Q.count;++i) this.V[i]=Q.V[i];
    }

    public PolyVector normalize() {
	PolyVector P=new PolyVector();
	P.count=count;
	for(int i=0;i<count;++i) {
	    P.V[i]=V[i].normalize();
	}
	return(P);
    }


    public PolyVector(PolyWedge Q) {
	this.count=Q.count;
	for(int i=0;i<Q.count;++i) {
            this.V[i]=new Vector(Q.z[i]);
	}
    }

    public  PolyWedge toPolyWedge() {
	PolyWedge Q=new PolyWedge();
	Q.count=this.count;
	for(int i=0;i<count;++i) Q.z[i]=V[i].toComplex();
	return(Q);
    }

    public int inside(Vector W) {
	int i1,i2,i3;
	double o1,o2;
	for(int i=0;i<count;++i) {
	    i1=(i+0)%count;
	    i2=(i+1)%count;
	    i3=(i+2)%count;
	    o1=Vector.tripleProduct(V[i1],V[i2],W);
	    o2=Vector.tripleProduct(V[i2],V[i3],W);
	    if(o1*o2<0) return(0);
	}
	return(1);
    }

}

