import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;
import java.io.*;



public class Polyhedron {
    Vector[] V=new Vector[1000];
    int count;
    int orbit; 


    public Polyhedron() {}

    public Polyhedron(Polyhedron P) {
	this.count=P.count;
	for(int i=0;i<count;++i) V[i]=new Vector(P.V[i]);
    }
    public void print() {
	for(int i=0;i<count;++i) {
	    V[i].print();
	}
    }



    /**scaling*/
    public Polyhedron scale(double t) {
	Polyhedron Q=new Polyhedron();
	Q.count=this.count;
	for(int i=0;i<count;++i) {
	    Q.V[i]=V[i].scale(t);
	}
	return(Q);
    }

    public Polyhedron translate(double i1,double i2,double i3) {
	return(this.translate(new Vector(i1,i2,i3)));
    }

    public Polyhedron translate(Vector V) {
	Polyhedron Q=new Polyhedron();
	double A=Math.sqrt(5)-2;
	Q.count=this.count;
	for(int i=0;i<Q.count;++i) {
	    Q.V[i]=Vector.plus(V,this.V[i]);
	}
	return(Q);
    }

    public Vector getCenter() {
	Vector W=new Vector(0,0,0);
	int n=this.count;
	for(int i=0;i<n;++i) {
	    W=Vector.plus(W,V[i]);
	}
	W=new Vector(W.x[0]/n,W.x[1]/n,W.x[2]/n);
	return(W);
    }


    /*for t<1 this is a retraction*/

    public Polyhedron retract(double t) {
	Vector W=this.getCenter();
	Polyhedron Q=new Polyhedron();
	Q.count=this.count;
	for(int i=0;i<this.count;++i) {
	    Q.V[i]=new Vector();
	    for(int j=0;j<3;++j) {
		Q.V[i].x[j]=t*V[i].x[j]+(1-t)*W.x[j];
	    }
	}
	return(Q);
    }




    public Vector[] getSegment(int i,int j,double t1,double t2) {
	Vector V1=this.V[i];
	Vector V2=this.V[j];
	Vector W1=Vector.interpolate(t1,V1,V2);
	Vector W2=Vector.interpolate(t2,V1,V2);
	Vector[] W={W1,W2};
	return(W);
    }

    public Vector getPoint(int i,int j,double t) {
	Vector V1=this.V[i];
	Vector V2=this.V[j];
	Vector W=Vector.interpolate(t,V1,V2);
	return(W);
    }

    public Polyhedron translateMinus(Vector W) {
	Polyhedron Q=new Polyhedron();
	Q.count=count;
	for(int i=0;i<count;++i) Q.V[i]=Vector.minus(W,V[i]);
	return(Q);
    }


    public Vector[] boundingBox() {
	Vector V1=new Vector(10,10,10);
	Vector V2=new Vector(-10,-10,-10);
	for(int i=0;i<count;++i) {
	    for(int j=0;j<3;++j) {
	       if(V1.x[j]>V[i].x[j]) V1.x[j]=V[i].x[j];
	       if(V2.x[j]<V[i].x[j]) V2.x[j]=V[i].x[j];
	    }
	}
	Vector[] W={V1,V2};
	return(W);
    }

    public static Vector interpolate(Vector[] W,double x0,double x1,double x2) {
	double[] a=new double[3];
	double[] x={x0,x1,x2};
	for(int i=0;i<3;++i) {
	    a[i]=(1-x[i])*W[0].x[i]+x[i]*W[1].x[i];
	}
	Vector X=new Vector(a[0],a[1],a[2]);
	return(X);
    }


}
