import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


    


public class ProofFixedPoint implements Runnable {
    int halt;
    Manager M;


public ProofFixedPoint(Manager MM) {
    this.M=MM;
}

    /**This class contains the proofs for the FixedPoint Orbit Theorem.
       It also has the single test for the tile Q_1 that appears in our
       lemma about (3,0) being a fixed point of renormalization.**/

    public void run() {	
	halt=1;
	int[] d=new int[2];
	for(int i=0;i<2;++i) d[i]=M.C.CON_X.FIXED.L[i].on;
        GoldenPolyWedge[] ALL=DataFixedPoint.polyList();
	if(d[0]==1) PolyCover.coverTest(ALL,ALL.length,DataFixedPoint.Q1());
	if(d[1]==1) mainTest();
    }


    public GoldenComplex transform(GoldenComplex z) {
	GoldenComplex SOURCE=new GoldenComplex(3,0,0,0);  
	GoldenComplex TARGET=new GoldenComplex(-3,0,-2,0);
	return(ProofSupport.transform0(SOURCE,TARGET,z));
    }

    public void mainTest() {
	System.out.println("start main test -- ");
	int k=47;
	int i=0;
	while((halt==1)&&(i<k)) {
	    Color C1=Color.red;
	    GoldenPolyWedge P=DataFixedPoint.getGoldenPoly(i);
	    GoldenPolyWedge Q=transform(P); 
	    int[] test=ProofSupport.check(P,Q,false);
	    if(test[0]==0) failMessage();
	    if(test[0]==1) System.out.println(i+" pass: "+test[1]);
	    if(test[0]==2) System.out.println(i+" pass: "+test[1]+" "+test[2]);
	    if(test[0]==1) C1=new Color(50,100,255);
	    M.T.addPoly(P.toPolyWedge(),C1);
	    M.T.addPoly(Q.toPolyWedge(),C1);
	    M.T.repaint();
	    ++i;
    }
	System.out.println("end ");
    }

    public void failMessage() {
	throw new ProofException("ProofFixedPoint");
    }


    public GoldenPolyWedge transform(GoldenPolyWedge P) {
	GoldenPolyWedge Q=new GoldenPolyWedge();
	Q.count=P.count;
	for(int i=0;i<P.count;++i) Q.z[i]=transform(P.z[i]);
	return(Q);
    }



}



