import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


    


public class ProofFundamental implements Runnable {
    int halt;
    Manager M;


public ProofFundamental(Manager MM) {
    this.M=MM;
}

    /**This class contains the proofs for the Fundamental Orbit Theorem.
       It also has the single test for the tile Q_1 that appears in our
       lemma about (3,0) being a fixed point of renormalization.**/

    public void run() {	
	halt=1;
	int[] d=new int[7];
	for(int i=0;i<7;++i) d[i]=M.C.CON_X.FUND.L[i].on;

        GoldenPolyWedge[] ALL=DataFundamental.polyList();
        int total=ALL.length;

	for(int i=0;i<ALL.length;++i) {
	    PolyWedge P=ALL[i].toPolyWedge();
	    M.T.addPoly(P);
	}

	GoldenPolyWedge T=DataFundamental.fundamental();
	if(d[0]==1) PolyCover.coverTest(ALL,ALL.length,T);
 
	for(int i=0;i<6;++i) {
	    if(d[i+1]==1) renormTest(i,M);
	}

    }
    

    /**Here is the main test. The polygons are loaded in
       and then tested.   Each polygon P is an A-renorm tile.
       The polygon Q is the image of P under a suitable affine
       transformation.  The purpose of the test is to show that
       either P is a dynamical tile or
       (P,Q) is a renormalization pair of tiles.**/

    public void renormTest(int q,Manager M) {
	int i0=M.C.CON_X.INT[3].val;
	if(halt==1) System.out.println("start renorm test "+q);
	int k=DataFundamentalRaw.limit(q);
	int i=0;
	while((i<k)&&(halt==1)) {
	    System.out.print(i+"  ");
	    Color C1=Color.red;
	    GoldenPolyWedge P=DataFundamental.getGoldenPoly(q,i);
	    GoldenPolyWedge Q=transform(q,P); 
	    int[] test=ProofSupport.check(P,Q,false);
	    if(test[0]==0) failMessage();
	    if(test[0]==1) System.out.println("pass: "+test[1]);
	    if(test[0]==2) System.out.println("pass: "+test[1]+" "+test[2]);
	    if(test[0]==1) C1=new Color(50,100,255);
	    M.T.addPoly(P.toPolyWedge(),C1);
	    M.T.addPoly(Q.toPolyWedge(),C1);
	    M.T.repaint();
	    ++i;
	}
	if(halt==1) System.out.println("end renorm test "+q);
    }


    /**Here are the affine transformations we use. There is one
       affine transformation for each of the 6 triangles, and then
       the last affine transformation is for the special test.*/


    public GoldenPolyWedge transform(int q,GoldenPolyWedge P) {
	GoldenPolyWedge Q=new GoldenPolyWedge();
	Q.count=P.count;
	for(int i=0;i<P.count;++i) Q.z[i]=transform(q,P.z[i]);
	return(Q);
    }




    public GoldenComplex transform(int q,GoldenComplex z) {
	if(q==0) return(transform0(z));
	if(q==1) return(transform1(z));
	if(q==2) return(transform2(z));
	if(q==3) return(transform3(z));
	if(q==4) return(transform4(z));
	if(q==5) return(transform5(z));
	if(q==6) return(transformExtra(z));  //for the extra test
	return(z);
    }



    /**The first 4 routines expand by phi^3 and move
       SOURCE to TARGET**/

    public GoldenComplex transform0(GoldenComplex z) {
	GoldenComplex SOURCE=new GoldenComplex(-3,2,0,0);  
	GoldenComplex TARGET=new GoldenComplex(3,-2,-2,0);
	return(ProofSupport.transform0(SOURCE,TARGET,z));
    }

    public GoldenComplex transform1(GoldenComplex z) {
	GoldenComplex SOURCE=new GoldenComplex(-3,2,0,0);  
	GoldenComplex TARGET=new GoldenComplex(-5,2,-2,0);
	return(ProofSupport.transform0(SOURCE,TARGET,z));
    }

    public GoldenComplex transform2(GoldenComplex z) {
	GoldenComplex SOURCE=new GoldenComplex(0,0,1,0);  
	GoldenComplex TARGET=new GoldenComplex(-2,0,-1,0);
	return(ProofSupport.transform0(SOURCE,TARGET,z));
    }

    public GoldenComplex transform3(GoldenComplex z) {
	GoldenComplex SOURCE=new GoldenComplex(-6,4,1,0);  
	GoldenComplex TARGET=new GoldenComplex(0,0,-1,0);
	return(ProofSupport.transform0(SOURCE,TARGET,z));
    }

    /**for the extra test**/

    public GoldenComplex transformExtra(GoldenComplex z) {
	GoldenComplex SOURCE=new GoldenComplex(3,0,0,0);  
	GoldenComplex TARGET=new GoldenComplex(-3,0,-2,0);
	return(ProofSupport.transform0(SOURCE,TARGET,z));
    }

    /**These two routines are translations**/

    public GoldenComplex transform4(GoldenComplex z) {
	GoldenComplex T=new GoldenComplex(10,-6,-2,2);
	GoldenComplex w=GoldenComplex.minus(z,T);
	return(w);
    }

    public GoldenComplex transform5(GoldenComplex z) {
	GoldenComplex T=new GoldenComplex(-2,2,-2,2);
	GoldenComplex w=GoldenComplex.minus(z,T);
	return(w);
    }

    public void failMessage() {
	throw new ProofException("ProofFundamental");
    }
 




}


