import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**This contains the proof that
the first return map and the pinwheel map agree when applied
to the numerically computed centroids of the pinwheel tiles.
The other pinwheel proof files show that this numerical
computation of the sequences associated to the two maps
is correct, and agrees throughout the interiors of the
pinwheel tiles.  The numerical computation here just
regenerates the two sequences.  Once we have these sequences,
we simply show that they are equivalent.*/


public class ProofPinwheel3 implements Runnable {
    int halt;
    Manager M;

public ProofPinwheel3(Manager MM) {
    this.M=MM;
}

public ProofPinwheel3() {}

    public void run() {	
	System.out.println("START");
	System.out.print("start pinwheel equal test  --  ");
	int total=DataPinwheel.COUNT();
	for(int i=0;i<total;++i) {
	    boolean test=compareVectors(i);
	    if(test==false) System.out.println("fail "+i);
	}
	System.out.println("end");
	System.out.println("END");
    }


    public boolean compareVectors(int i) {
	PinwheelMap PIN=new PinwheelMap();
	Complex z=ProofPinwheel1.center(i);
	int[] list1=ProofPinwheel1.vertexSequence(z);
	int[] list2=PIN.mapSpectrumPlus(z);
	if(list1==null)return(true);
	boolean test=compareVectors(list1,list2);
	return(test);
    }


    /**Here list1 is the list that comes from the outer billiards map
       and list2 is the list that comes from the pinwheel map.**/

    public boolean compareVectors(int[] list1,int[] list2) {
	GoldenComplex w1=returnVector(list1);
 	GoldenComplex w2=pinwheelVector(list2);
	boolean test=GoldenComplex.equals(w1,w2);
	return(test);
    }

    public static GoldenComplex pinwheelVector(int[] list) {
	GoldenComplex[] X=pinwheelVectors();
	GoldenComplex z=new GoldenComplex(0,0,0,0);
	for(int i=1;i<10;++i) {
	    GoldenComplex m=new GoldenComplex(list[i],0,0,0);
	    z=GoldenComplex.plus(z,GoldenComplex.times(m,X[i%4]));
	}
	return(z);
    }

    public static GoldenComplex returnVector(int[] list) {
	GoldenComplex z=new GoldenComplex(0,0,0,0);
	for(int i=0;i<list.length;++i) {
	    z=ProofPinwheel1.outerBilliards(list[i],z);
	}
	return(z);
    }


    public static GoldenComplex[] pinwheelVectors() {
	GoldenComplex[] X=new GoldenComplex[4];
        X[0]=new GoldenComplex(-2,0,-2,0);
	X[1]=new GoldenComplex(0,0,4,0);
	X[2]=new GoldenComplex(-2,0,2,0);
	X[3]=new GoldenComplex(4,-4,0,0);
	return(X);
    }

}


