import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


    


public class ProofReduction1 implements Runnable {
    int halt;
    Manager M;


public ProofReduction1(Manager MM) {
    this.M=MM;
}

    /**This class contains the proofs for the Fundamental Orbit Theorem.
       It also has the single test for the tile Q_2 that appears in our
       lemma about (3,0) being a fixed point of renormalization.**/


    public void failMessage() {
	throw new ProofException("ProofReduction 1");
    }


    public void run() {	

	halt=1;
	int[] d=new int[7];
	for(int i=0;i<7;++i) d[i]=M.C.CON_X.REDUCE1.L[i].on;

	if(d[0]==1)  coverTest();
	if(d[1]==1)  renormValidityTest1();
	if(d[2]==1)  renormValidityTest2();
	if(d[3]==1)  renormValidityTest3();
	if(d[4]==1)  tautTest();
	if(d[5]==1)  superTautTest();
	if(d[6]==1)  superTautRenormTest();
    }

    /**checks that each big tile is covered by the little ones.**/

    public void coverTest() {

	for(int k=0;k<23;++k) {
	    GoldenPolyWedge[] ALL=DataReduction.polyList(k);
	    int total=ALL.length;
	    GoldenPolyWedge big=DataReduction.getGoldenBig(k);
	    System.out.print(k+" ");
            PolyCover.coverTest(ALL,total,big);
	}

	/**This is for the 11 supermin tiles*/

	for(int k=0;k<12;++k) {
	    GoldenPolyWedge[] ALL=DataReduction.polyListRenorm(k);
	    int total=ALL.length;
	    GoldenPolyWedge big=DataReduction.getSuperTautRenorm(k);
	    PolyCover.coverTest(ALL,total,big);
	}

    }

	   /**RENORM VALIDITY TESTS*/


   /**This checks that the renorm tiles covering the 23 pieces are
      indeed A-renorm tiles.**/

    public void renormValidityTest1() {
	System.out.println("start renorm validity test");
	for(int k=0;k<23;++k) renormValidityTest1(k);
    }

    public boolean renormValidityTest1(int k) {
	System.out.println("go "+k);
	GoldenPolyWedge[] ALL=DataReduction.polyList(k);
	int i=0;
	while((halt==1)&&(i<ALL.length)) {
	    GoldenPolyWedge P=ALL[i];
	    int[] x=ProofSupport.check(P,false);
	    if(x[0]==0) {
		failMessage();
	    }
	    if(x[0]==1) System.out.println(i+"  pass p "+x[1]);
	    if(x[0]==2) System.out.println(i+"  pass R "+x[1]);
	    ++i;
	}
	if(halt==1) System.out.println("pass "+k);
	return(true);
    }



    /**This checks that we have correctly computed the 
       renormalization of the 12 super-taut
       tiles.**/

    public void renormValidityTest2() {
	System.out.println("start renorm validity test 2");
	for(int i=0;i<12;++i) {
	    GoldenPolyWedge P=DataReduction.getSuperTaut(i);
	    GoldenPolyWedge Q=DataReduction.getSuperTautRenorm(i);

	    M.T.addPoly(P.toPolyWedge());


            int[] renorm=VerifyRenorm.verify(P,Q);
	    if(renorm[0]!=-1) System.out.println(i+" pass "+renorm[0]+" "+renorm[1]);
	    if(renorm[0]==-1) failMessage();
	}
	System.out.println("end");
    }



    /**This checks that the renorms of the 12 supermin tiles
       are indeed A-renorm tiles.**/
        
    public void renormValidityTest3() {
	System.out.println("start renorm validity test 3");
	for(int k=0;k<12;++k) renormValidityTest3(k);
    }

    public boolean renormValidityTest3(int k) {
	GoldenPolyWedge[] ALL=DataReduction.polyListRenorm(k);
	int i=0;
	while((i<ALL.length)&&(halt==1)) {
	    GoldenPolyWedge P=ALL[i];
	    int[] x=ProofSupport.check(P,false);
	    if(x[0]==1) System.out.println(i+" pass p " +x[1]);
	    if(x[0]==2) System.out.println(i+" pass R " +x[1]);
	    if(x[0]==0) failMessage();
	    ++i;
	}
	if(halt==1) System.out.println(k+"  pass");
	return(true);
    }



    /**TAUT TEST**/
    /**This generates, with exact arithmetic,
       a list of A-tiles that fail to be
       chain minimizers, and checks that it matches our
       numerically computed list.*/

    public void tautTest() {
	System.out.println("start taut test");
	int[][] LIST=new int[150][2];
	int k=0;
	while((halt==1)&&(k<23)) {
	    System.out.println("try "+k);
	    tautTest(k);
	    ++k;
	}
	System.out.println("done");
    }



    public void tautTest(int k) {
	int[][] LIST=DataReductionRaw.taut();
        GoldenPolyWedge[] ALL=DataReduction.polyList(k);
	int i=0;
	while((i<ALL.length)&&(halt==1)) {
	   GoldenPolyWedge P=ALL[i];   
           GoldenComplex z1=ALL[i].cheapInterior();
	   if((k!=0)||(specialException(z1)==false)) {
	   int x=VerifyTile.verifyPeriodic(P,1000,false);
	   if(x==-1) { 
	      GoldenComplex z0=VerifySupport.getChainStart(z1);
	      GoldenComplex z2=VerifySupport.getMinimizeA(z1);
	      boolean test=VerifyReduction.verifySameChain(z0,z1,z2);
	      if(test==false) failMessage();
	      test=VerifyReduction.phiTest(z1.x,z2.x);
	      System.out.println("pass "+k+" "+i+" ");
	      if(test==false) {
		  int[] TRY={k,i};
		  if(Lists.onList(TRY,LIST)==false) failMessage();
	      }
	   }}
	   ++i;
	}
    }

    /**We ignore the tiles that lie in the region Q1.**/
    public  boolean specialException(GoldenComplex z) {
	GoldenPolyWedge P=DataFixedPoint.Q1();
	if(PolyCover.inside(z,P)==true) return(true);
	return(false);
    }




	   /**SUPER TAUT TEST**/


    /**This starts with our list of taut tiles, and
       generates the list of super taut.  It then checks 
       that the 11 superminimizers agree with the precomputed list.**/

    public  void superTautTest() {
	int[][] LIST=DataReductionRaw.taut();
	System.out.println("start super taut test");
	int q=0;
	while((halt==1)&&(q<LIST.length)) {
	    int k=LIST[q][0];
	    int i=LIST[q][1];
            System.out.println("try    "+k+" "+i);
	    GoldenPolyWedge P=DataReduction.getGoldenPoly(k,i);
	    GoldenComplex z1=P.cheapInterior();	
            int[] L=Characteristics.getCharA(z1.y);
	    GoldenComplex z2=VerifySupport.getMinimizeB(L,z1);
	    GoldenPolyWedge Q=ProofSupport.transform(L[0],z1,z2,P);
            int[] renorm=VerifyRenorm.verify(P,Q);
	    boolean test=VerifyReduction.phiTest(P,Q);
	    if(test==false) System.out.println("on list           "+k+" "+i);
	    if(renorm[0]==-1) failMessage();
	    ++q;
	}
	if(halt==1) {
	  System.out.println("");
	  System.out.println("end");
	}
    }


	   /**SUPER MIN RENORM TEST*/

	   /**This checks that all the 2nd renorms of the
              super minimizers are close to the origin than
              the super minimizers themselves.**/


    public void superTautRenormTest() {
 	System.out.println("start super min renorm test");
	int k=0;
	while((halt==1)&&(k<12)) {
	   superTautRenormTest(k);
	   ++k;
	}
	if(halt==1) System.out.println("end");;
    }


    public  void superTautRenormTest(int k) {
	int lim=DataReduction.limitRenorm(k);
	for(int i=0;i<lim;++i) { 
	    GoldenPolyWedge P=DataReduction.getGoldenPolyRenorm(k,i);  
            int x=VerifyTile.verifyPeriodic(P,1000,false);
	    if(x==-1) {
	      GoldenComplex z1=P.cheapInterior();	
              int[] L=Characteristics.getCharA(z1.y.dec(2));
	      GoldenComplex z2=VerifySupport.getMinimizeB(L,z1);
	      GoldenPolyWedge Q=ProofSupport.transform(L[0],z1,z2,P);
              int[] renorm=VerifyRenorm.verify(P,Q);
	      if(renorm[0]==0) failMessage();
	      if(renorm[0]!=0) System.out.print("pass "+k+" "+i+"  ");  z2.print2();
	      if(k>1) {
	         boolean test1=VerifyReduction.zeroTest(new GoldenReal(5,0),z2.x);
		 if(test1==false) failMessage();
	      }
	      if(k==0) {
	         boolean test1=VerifyReduction.zeroTest(new GoldenReal(2,0),z2.x);
		 if(test1==false) failMessage();
	      }

	      if(k==1) {
		  for(int j=0;j<Q.count;++j) {
		      boolean test=VerifyReduction.zeroTest(new GoldenReal(-5,5),Q.z[j].x);
		      if(test==false) failMessage();
		  }
	      }
	    }
	}

	System.out.println("");
    }



 

  


}

