import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


    


public class ProofReduction2 implements Runnable {
    int halt;
    Manager M;
    int chainA,chainB;


public ProofReduction2(Manager MM) {
    this.M=MM;
}

    /**This class contains the test for the far reduction theorem.
       Let (P,Q) be a pair of corresponding A and B tiles.

       1.  We compute the itinerary listA for P and verify that it is correct.
       2.  We compute the itinerary listB for Q and verify that it is correct.
       3.  Using listA, we compute the min and max deviation of the normalized A-core.
           The normalized A-core is the portion of an orbit of a point in p,
           corresponding to the A-chain, normalized so that the initial point is the origin.
       4.  Using listB, we compute the min and max deviation of the normalized B-core.    
       5.  Call the output of step 3 rangeA, and the output of step 4 rangeB.  We
           check that:

              (i)  in the isometric case,  rangeA  in [rangeB-9,rangeB+9]
              (ii) in the expansive case,  rangeA  in [rangeB-5,rangeB+5].
    **/


    public void failMessage() {
	throw new ProofException("ProofReduction");
    }


    public void run() {	
	chainA=0;
	chainB=0;
	System.out.println("start far reduction test");
	halt=1;
	for(int i=0;i<9;++i) {
	    if(M.C.CON_X.B.LEVEL.L[i].on==1) {
		int[] h=lookup(i);
		boolean iso=false;
		if(h[0]%2==1) iso=true; 
		mainTest(h[0],h[1],iso);
	    }
	}
	System.out.println("done");
    }

    int[] lookup(int k) {
	int[][] A={{0,0},{0,1},{0,2},{0,3},{0,4},{1,5},{2,0},{2,1},{2,2},{2,3},{2,4},{2,5},{3,0},{4,1},{4,2},{4,3},{4,4},{4,5}};return(A[k]);}

    public void mainTest(int LA,int LB,boolean iso) {
      double max=0;
      int br=0;
       while((halt==1)&&(br<4)) {
	   int k=0; 
           int lim=DataRenormReturn.limits(LB,br);
	   while((halt==1)&&(k<lim)) {
	       int dir=1;
	      if(iso==true) dir=0;
	      GoldenPolyhedron P=DataRenormReturn.getGoldenA(LA,LB,br,k,0);
	      GoldenPolyhedron Q=DataRenormReturn.getGoldenB(LB,br,k,dir);
              int[] listA=VerifySupport.itineraryChain(0,LA,LB,br,k);
              int[] listB=VerifySupport.itineraryChain(1,LA,LB,br,k);
	      GoldenReal[] rangeA=VerifyChains.getRange(listA,true,iso);
	      GoldenReal[] rangeB=VerifyChains.getRange(listB,false,iso);
              boolean test1=VerifyChains.verifyA(P,listA);
	      boolean test2=VerifyChains.verifyB(Q,listB,iso);
	      boolean test3=VerifyChains.verifyRange(listA,rangeA,true,iso);
	      boolean test4=VerifyChains.verifyRange(listB,rangeB,true,iso);
	      boolean test5=VerifyChains.verifyMismatch(rangeA,rangeB,iso);
              if(test1==false) failMessage();
	      if(test2==false) failMessage();
	      if(test3==false) failMessage();
	      if(test4==false) failMessage();
	      if(test5==false) failMessage();
	      if(chainA<listA.length) chainA=listA.length;
	      if(chainB<listB.length) chainB=listB.length;
	      System.out.println(LA+" "+LB+" "+br+" "+k+"     "+chainA+" "+chainB);
	      ++k;
	   }
	   ++br;
       }
    }
}
