import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


    


public class ProofRenorm1 implements Runnable {
    int halt;
    Manager M;


public ProofRenorm1(Manager MM) {
    this.M=MM;
}

    /**This class contains the tests for the renormalizaiton theorems**/

    public void failMessage() {
	throw new ProofException("ProofRenorm1");
    }


    public void run() {	
	System.out.println("start validity test");
	halt=1;
	for(int i=0;i<9;++i) {
	    if(M.C.CON_X.B.LEVEL.L[i].on==1) {
		int[] h=ProofSupport.lookup(i);
		boolean iso=false;
		if(h[0]%2==1) iso=true; 
		validityTest(h[0],h[1],iso);
	    }
	}
	System.out.println("done");
    }


    /**VALIDITY TEST:  This verifies that the atoms we have listed as renormalization
       atoms really are renormalization atoms.  We check both the A-atoms and B-atoms.
       We also check that the first return maps are compatible with the action of R.**/

    public void validityTest(int LA,int LB,boolean iso) {
      double max=0;
      int br=0;
       while((halt==1)&&(br<4)) {
	   if(M.C.CON_X.B.BRANCH.L[br].on==1) {
	   int k=0; 
           int lim=DataRenormReturn.limits(LB,br);
	   while((halt==1)&&(k<lim)) {
	      int dir=1;
	      if(iso==true) dir=0;
	      GoldenPolyhedron atomA=DataRenormReturn.getGoldenA(LA,LB,br,k,0);
	      GoldenPolyhedron atomB=DataRenormReturn.getGoldenB(LB,br,k,dir);
              int[] listA=VerifySupport.itineraryChain(0,LA,LB,br,k);
              int[] listB=VerifySupport.itineraryChain(1,LA,LB,br,k);
	      GoldenVector V1=VerifySupport.getTotalMoveRaw(listA);
	      GoldenVector V2=new GoldenVector();
	      if(iso==true) V2=VerifySupport.getTotalMoveRaw(listB);
	      if(iso==false) V2=VerifySupport.getTotalMoveInverseRaw(listB);
	      GoldenPolyhedron endA=atomA.translate(V1);
	      GoldenPolyhedron endB=atomB.translate(V2);
	      endA=VerifySupport.fundamentalDomain(endA);
	      endB=VerifySupport.fundamentalDomain(endB);
              boolean test1=VerifyRenorm3D.verifyWhole(atomA,listA,true);
	      boolean test2=VerifyRenorm3D.verifyWhole(atomB,listB,iso);
              boolean test3=VerifyRenorm3D.verifyMatch(LA,LB,endA,endB);
              if(test1==false) failMessage();
	      if(test2==false) failMessage();
	      if(test3==false) failMessage(); 
	      System.out.println(LA+" "+LB+" "+br+" "+k);
	      ++k;
	   }}
	   ++br;
       }
    }

}


