import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


    


public class ProofRenorm2 implements Runnable {
    int halt;
    Manager M;


    /**This class does the check that the B-renorm set is partitioned
       into B-atoms.**/


    public ProofRenorm2(Manager MM) {
        this.M=MM;
    }


    public void failMessage() {
	throw new ProofException("ProofRenorm2");
    }

    public void run() {
	halt=1;
	for(int LB=0;LB<3;++LB) {
	    for(int br=0;br<4;++br) {
		checkCover(LB,br);
	    }
	}
    }


    /**Here is the main covering check*/
    public void checkCover(int LB,int br) {
	GoldenPolyhedron P=DataRenorm.getGoldenB(LB,br);
	GoldenReal[] HEIGHTS=ProofSupport.getHeightsB(LB);
	GoldenPolyhedron[] LIST=polyListB(LB,br);
	int i=0;
	while((halt==1)&&(i<HEIGHTS.length)) {
	    GoldenReal h=HEIGHTS[i];
	    GoldenPolyWedge PP=GoldenPolyCombinatorics.intersect(P,h); 
	    GoldenPolyWedge[] LIST2=ProofSupport.slice(LIST,h);
	    System.out.print(LB+" "+br+" "+i+" ("+HEIGHTS.length+") ");
	    PolyCover.coverTest(LIST2,LIST2.length,PP);
	    ++i;
	}
	if(halt==1) System.out.println("done");
	if(halt==0) System.out.println("halted");
    }

    /**This gets the list of heights at which we slice the B-partition**/

    public GoldenReal[] getHeightsB(int LB) {
	int[][] H=DataHeightsRaw.heightB(LB); 
	GoldenReal[] LIST1=new GoldenReal[H.length];
	for(int i=0;i<H.length;++i) LIST1[i]=new GoldenReal(H[i][0],H[i][1]);
	LIST1=GoldenReal.interlace(LIST1);
	return(LIST1);
    }


    /**This takes a list of GoldenPolyhedra and slices them at a given height**/


    public GoldenPolyWedge[] slice(GoldenPolyhedron[] LIST,GoldenReal HEIGHT) {
	int total=0;
	GoldenPolyWedge[] LIST2=new GoldenPolyWedge[LIST.length];
	for(int i=0;i<LIST.length;++i) {
             GoldenPolyWedge Q=GoldenPolyCombinatorics.intersect(LIST[i],HEIGHT);
	     if(Q!=null) {
	        LIST2[total]=Q;
		++total;
	     }
	}
	LIST2=Lists.clean(LIST2,total);
	return(LIST2);
    }


    /**Here is the list of B-atoms at level LB and branch br.**/

    public GoldenPolyhedron[] polyListB(int LB,int br) {
	int lim=DataRenormReturn.limits(LB,br);
	GoldenPolyhedron[] LIST=new GoldenPolyhedron[lim];
	for(int i=0;i<lim;++i) LIST[i]=DataRenormReturn.getGoldenB(LB,br,i,0);
	return(LIST);
    }

}



