import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


    


public class ProofRenorm3 implements Runnable {
    int halt;
    Manager M;

    /**This class does the test that the 3-torus is partitioned into B-atoms and
       periodic tiles.**/


public ProofRenorm3(Manager MM) {
    this.M=MM;
}

    /**This class contains the tests for the renormalizaiton theorems**/

    public void failMessage() {
	throw new ProofException("ProofRenorm 3");
    }


    public void run() {
	halt=1;
	int[] z=new int[10];
	int[] l=new int[3];
	for(int i=0;i<10;++i) z[i]=M.C.CON_X.ZONE.L[i].on;
	for(int i=0;i<3;++i) l[i]=M.C.CON_X.LAYER.L[i].on;
	int[] INDEX={23,25,32,40,41,44,46,53,61,62};

	for(int i=0;i<10;++i) { 
	  for(int q=0;q<3;++q) {
	      if(l[q]*z[i]==1) coverTestB(q,INDEX[i]);
	  }
	}
    }

    public void coverTestB(int LB,int index) {
	GoldenPolyhedron P=DataPartition.getGoldenPolyhedron(index);
	GoldenReal[] HEIGHTS=ProofSupport.getHeightsB(LB);
	GoldenPolyhedron[] LIST=polyCoverListB(LB,index);
	M.PC1.COUNT=0;
	int i=0;
	while((halt==1)&&(i<HEIGHTS.length)) {
	    GoldenReal h=HEIGHTS[i];
	    ProofSupport.display(M,LIST,h);
	    GoldenPolyWedge PP=GoldenPolyCombinatorics.intersect(P,h); 
	    GoldenPolyWedge[] LIST2=ProofSupport.slice(LIST,h);
	    System.out.print(LB+" "+index+" "+i+" ("+HEIGHTS.length+") ");
	    PolyCover.coverTest(LIST2,LIST2.length,PP);
	    ++i;
	}
	if(halt==1) System.out.println("done");
	if(halt==0) System.out.println("halted");
    }

    public GoldenPolyhedron[] polyCoverListB(int LB,int index) {
	GoldenPolyhedron[] LIST1=periodFillB(LB,index);
	GoldenPolyhedron[] LIST2=atomFillB(LB,index);
	GoldenPolyhedron[] LIST=Lists.merge(LIST1,LIST2);
	return(LIST);
    }

    /**This routine produces the list of all the exceptional
       periodic tiles that fill the region with the given index.
       The only indices we need to consider are 23,25,32,40,41.
       The way the routine works is that we take each of the
       48 polyhedra and consider its orbit.  We select those
       members of the orbit contained in the given region.
       We use floating point arithmetic for this routine,
       but before we include each polyhedron on the list we
       verify rigorously that it works.**/

    public GoldenPolyhedron[] periodFillB(int LB,int INDEX) { 
       GoldenPolyhedron[] LIST=new GoldenPolyhedron[100];
       int total=0;
       System.out.println("making periodic list "+INDEX);
       int i=0;
       while((halt==1)&&(i<48)) {
	  boolean block=DataPeriodicRaw.getBlockB(LB,i);
	  GoldenPolyhedron GP=DataPeriodic.getGoldenB(i);
	  Polyhedron P=GP.toPolyhedron();
	  P.orbit=DataPeriodicRaw.getPeriodB(i);
	  if(block==false) {  
              Vector V=P.getCenter();
	      Vector V0=new Vector(V);
	      for(int j=0;j<P.orbit;++j) {
                int type=PolyhedronExchange.classify(V);
	        if(type==INDEX) {
	           Polyhedron Q=P.translate(Vector.minus(V,V0)); 
                   Q=TorusMap.fundamentalDomain(Q);
		   GoldenPolyhedron GQ=new GoldenPolyhedron(Q);
		   boolean test=VerifyRenorm3D.verifySameOrbit(GP,GQ,j);
		   if(test==false) failMessage();
		   LIST[total]=GQ;
		   ++total;
		}
                V=PolyhedronExchange.doDynamicsPlus(V,type);
	      }
	  }
	  ++i;
       }
       return(Lists.clean(LIST,total));
    }


    /**This routine is like the previous one, except that it
       gets the B-atoms rather than the periodic tiles.**/


    public GoldenPolyhedron[] atomFillB(int LB,int INDEX) { 
       GoldenPolyhedron[] LIST=new GoldenPolyhedron[1000];
       int total=0;
       for(int br=0;br<4;++br) {  
           System.out.println("making list "+INDEX+" "+br);
	   int lim=DataRenormReturn.limits(LB,br);
	   int i=0;
	   while((halt==1)&&(i<lim)) {
	      GoldenPolyhedron GP=DataRenormReturn.getGoldenB(LB,br,i,0);
	      Polyhedron P=GP.toPolyhedron();
              Vector V=P.getCenter();
	      Vector V0=new Vector(V);	
              int[] I=VerifySupport.itineraryAB(V,false,true,true);
	      for(int j=0;j<I.length;++j) {
	        if(I[j]==INDEX) {
	           Polyhedron Q=P.translate(Vector.minus(V,V0)); 
		   Q=TorusMap.fundamentalDomain(Q);
                   GoldenPolyhedron GQ=new GoldenPolyhedron(Q);
		   boolean test=VerifyRenorm3D.verifySameOrbit(GP,GQ,j);
		   if(test==false) failMessage();
		   LIST[total]=GQ;
		   ++total;
		}
                V=PolyhedronExchange.doDynamicsPlus(V,I[j]);
	      }
	      ++i;
	   }
       }
       return(Lists.clean(LIST,total));
    }

}


