import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


    


public class ProofRenorm4 implements Runnable {
    int halt;
    Manager M;

    /**This class does the test that the B renorm set is partitioned into A-atoms and
       periodic tiles.  **/


   public ProofRenorm4(Manager MM) {
       this.M=MM;
   }

    public void failMessage() {
	throw new ProofException("ProofRenorm");
    }

    public void run() {
	halt=1;
	  for(int q=0;q<9;++q) {
              int[] L=ProofSupport.lookup(q);
	      for(int br=0;br<4;++br) {
                 int t1=M.C.CON_X.B.LEVEL.L[q].on;
                 int t2=M.C.CON_X.B.BRANCH.L[br].on;
		 if(t1*t2==1) coverTestA(q,br);
	      }
	  }
    }



    public void coverTestA(int q,int br) {
        int[] L=ProofSupport.lookup(q);
        GoldenPolyhedron P=DataRenorm.getGoldenB(L[0],br); 
	GoldenReal[] HEIGHTS=ProofSupport.getHeightsA(q);
	GoldenPolyhedron[] LIST=polyCoverListA(q,P);
	int i=0;
	while((halt==1)&&(i<HEIGHTS.length)) {
	    GoldenReal h=HEIGHTS[i];
	    ProofSupport.display(M,LIST,h);
	    GoldenPolyWedge PP=GoldenPolyCombinatorics.intersect(P,h); 
	    GoldenPolyWedge[] LIST2=ProofSupport.slice(LIST,h);
	    System.out.print(L[0]+" "+L[1]+" "+br+" "+i+" ("+HEIGHTS.length+") ");
	    PolyCover.coverTest(LIST2,LIST2.length,PP);
	    ++i;
	}
	if(halt==0) System.out.println("halted");
	if(halt==1) System.out.println("done");

    }

    public GoldenPolyhedron[] polyCoverListA(int q,GoldenPolyhedron P) {
	GoldenPolyhedron[] LIST1=periodFillA(q,P);
	GoldenPolyhedron[] LIST2=atomFillA(q,P);
	GoldenPolyhedron[] LIST=Lists.merge(LIST1,LIST2);
	return(LIST);
    }



    public GoldenPolyhedron[] periodFillA(int q,GoldenPolyhedron X) { 
       int[] L=ProofSupport.lookup(q);
       int LA=L[0];
       int LB=L[1];
       GoldenPolyhedron[] LIST=new GoldenPolyhedron[1000];
       int total=0;
       System.out.println("making periodic list "+q);
       int i=0;
       while((halt==1)&&(i<140)) {
	   boolean block=DataPeriodicRaw.getBlockA(LA,LB,i);
	  GoldenPolyhedron GP=DataPeriodic.getGoldenA(i);
	  Polyhedron P=GP.toPolyhedron();
	  P.orbit=DataPeriodicRaw.getPeriodA(i);
	  Vector V0=getGoodVector(LA,LB,P);
	  if(V0==null) block=true; 

	  if(block==false) {  
	      Vector V=new Vector(V0);
	      for(int j=0;j<P.orbit;++j) {
                int type=PolyhedronExchange.classify(V);
		if(contains(X,V)==true) {
                   Polyhedron Q=P.translate(Vector.minus(V,V0)); 
                   Q=TorusMap.fundamentalDomain(Q);
		   GoldenPolyhedron GQ=new GoldenPolyhedron(Q);
		   boolean test=VerifyRenorm3D.verifySameOrbit(GP,GQ,j);
		   if(test==false) failMessage();
		   LIST[total]=GQ;
		   ++total;
		}
                V=PolyhedronExchange.doDynamicsPlus(V,type);
	      }
	  }
	  ++i;
       }
       return(Lists.clean(LIST,total));
    }



    public GoldenPolyhedron[] atomFillA(int q,GoldenPolyhedron X) { 
	int[] L=ProofSupport.lookup(q);
	int LA=L[0];
	int LB=L[1];
       GoldenPolyhedron[] LIST=new GoldenPolyhedron[5000];
       int total=0;
       for(int br=0;br<4;++br) {  
           System.out.println("making atom list "+q+" "+br);
	   int lim=DataRenormReturn.limits(LB,br);
	   int i=0;
	   while((halt==1)&&(i<lim)) {
	       GoldenPolyhedron GP=DataRenormReturn.getGoldenA(LA,LB,br,i,0);
	       Polyhedron P=GP.toPolyhedron();
                Vector V=P.getCenter();
	        Vector V0=new Vector(V);	
                int[] I=VerifySupport.itineraryAB(V,true,true,true);
	        for(int j=0;j<I.length;++j) {
		  if(contains(X,V)==true) {
	             Polyhedron Q=P.translate(Vector.minus(V,V0)); 
		     Q=TorusMap.fundamentalDomain(Q);
                     GoldenPolyhedron GQ=new GoldenPolyhedron(Q);
		     boolean test=VerifyRenorm3D.verifySameOrbit(GP,GQ,j);
		     if(test==false) failMessage();
		     LIST[total]=GQ;
		     ++total;
		  }
                V=PolyhedronExchange.doDynamicsPlus(V,I[j]);
		}
		++i;
	   }
       }
       return(Lists.clean(LIST,total));
    }




/**This is a floating point routine, but it just serves as a
   guide to the rigorous calculations.*/

   public boolean contains(GoldenPolyhedron X,Vector V) {
       Polyhedron P=X.toPolyhedron();
       PolyWedge W=PolyhedronSlicer.basicSlice(P,V.x[2]);
       if(W==null) return(false);
       GeneralPath gp=W.toGeneralPath();
       return(gp.contains(V.x[0],V.x[1]));
   }

    /**This routine takes the initial polyhedron and intersects
       it with the top and bottom of the slab corresponding to LB.**/


    public Polyhedron chopPoly(int LA,int LB,Polyhedron P,int ORBIT) {
	Vector V=getGoodVector(LA,LB,P);	
	 if(V==null) return(null);
         double[] d=Characteristics.getHeightA(LA,LB);
	 Polyhedron Q=PolyhedronExchange.orbitTile(0,d[0],d[1],V,ORBIT);
	 return(Q);
     }


    public Vector getGoodVector(int LA,int LB,Polyhedron P) {
	double[] d=Characteristics.getHeightA(LA,LB);

	Vector[] B=P.boundingBox();
	if(B[0].x[2]>d[1]) return(null);
	if(B[1].x[2]<d[0]) return(null);

	PolyWedge W=PolyhedronSlicer.basicSlice(P,d[0]+.0001);
	if(W!=null) {
	    Complex z=W.getCenter();
	    Vector V=new Vector(z.x,z.y,d[0]+.0001);
	    return(V);
	}

        W=PolyhedronSlicer.basicSlice(P,d[1]-.0001);
	if(W!=null) {
            Complex z=W.getCenter();
	    Vector V=new Vector(z.x,z.y,d[1]-.0001);
	    return(V);
	}
	return(P.getCenter());
    }





}
