import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


    


public class ProofRenorm5 implements Runnable {
    int halt;
    Manager M;


public ProofRenorm5(Manager MM) {
    this.M=MM;
}

    /**This class contains the tests for the renormalizaiton theorems**/

    public void failMessage() {
	throw new ProofException("ProofRenorm5");
    }


    public void run() {	
	System.out.println("start maximal test");
	halt=1;
	for(int LB=0;LB<6;++LB) {
	    maximalTest(LB);
	}
	System.out.println("done");
    }

    public void maximalTest(int LB) {
      double max=0;
      int br=0;
       while((halt==1)&&(br<4)) {
	   int k=0; 
           int lim=DataRenormReturn.limits(LB,br);
	   while((halt==1)&&(k<lim)) {
	      GoldenPolyhedron atomB=DataRenormReturn.getGoldenB(LB,br,k,0);
              int[] listB=VerifySupport.itineraryChain(1,-1,LB,br,k); //second coord is irrelevant
              GoldenVector V2=VerifySupport.getTotalMoveRaw(listB);
	      GoldenPolyhedron endB=atomB.translate(V2);
	      endB=VerifySupport.fundamentalDomain(endB);
	      boolean test1=VerifyRenorm3D.verifyWhole(atomB,listB,true);
              if(test1==false) failMessage();
	      boolean test2=checkBoundary(LB,atomB,endB,listB);
	      System.out.println(LB+" "+br+" "+k);
	      ++k;
	   }
	   ++br;
       }
    }


    /**This test considers the first return map on each face of a given B-atom. 
       It checks one of 3 things for each face F:
       1.  The return map carries F into a crack of the PE, and hence is undefined, or
       2.  The return map carries F into the boundary of the B-set, or
       3.  F starts in the boundary of the B set.**/

    public boolean checkBoundary(int LB,GoldenPolyhedron atomB,GoldenPolyhedron endB,int[] listB) {
	int[] face1=VerifyMaximal.undefinedFaces(atomB,listB);
	int[] face2=VerifyMaximal.facesInB(LB,atomB);
	int[] face3=VerifyMaximal.facesInB(LB,endB);  //endB is the return of atomB
	System.out.print("not mapped to crack: ");Lists.printout(face1);
	System.out.print("start in boundary:   ");Lists.printout(face2);
	System.out.print("finish in boundary:  ");Lists.printout(face3);

	//return true if all faces end up in the cracks
	if(face1==null) return(true);

	//checks that each face that survives the return map satisfies opt 2 or 3 above
	for(int i=0;i<face1.length;++i) {
	    boolean test1=Lists.onList(face1[i],face2);
	    boolean test2=Lists.onList(face1[i],face3);
	    if((test1==false)&&(test2==false)) return(false);
	}
	return(true);
    }



}



