import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


    


public class ProofSupport {


    /**This class has routines used by the classes
       ProofFundamental
       Proof Reduction
    **/



    /**RENORMALIZATION CHECKER  
       this has 3 possible returns:
       first coord 0 means that the polygons fail
       first coord 1 means that P is periodic
       first coord 2 means that P-->Q
    */
 
    public static int[] check(GoldenPolyWedge P,GoldenPolyWedge Q,boolean print) {

       int[] renorm=VerifyRenorm.verify(P,Q,print);
       if(renorm[0]!=-1) {
	   int[] x={2,renorm[0],renorm[1]};
	   return(x);
       }

       int periodic=VerifyTile.verifyPeriodic(P,1000,print);
       if(periodic!=-1) {
	   int[] x={1,periodic};
	   return(x);
       }
       int[] x={0};
       return(x);
    }


    /**this has 3 possible returns:
        first coord 0 means that the polygons fail
       first coord 1 means that P is periodic
        first coord 2 means that P is an A-renorm tile.**/

    public static int[] check(GoldenPolyWedge P,boolean print) {
	int periodic=VerifyTile.verifyPeriodic(P,1000,print);
       if(periodic!=-1) {
	   int[] x={1,periodic};
	   return(x);
       }
       int[] renorm=VerifyRenorm.verifyA(P);

       if(renorm!=null) {
	   int[] x={2,renorm.length};
	   return(x);
       }
       int[] x={0};
       return(x);
    }






    /**AFFINE TRANSFORMATIONS**/

    public static  GoldenPolyWedge transform(int L,GoldenComplex z1,GoldenComplex z2,GoldenPolyWedge P) {
	GoldenPolyWedge Q=new GoldenPolyWedge();
	Q.count=P.count;
	for(int i=0;i<P.count;++i) Q.z[i]=transform(L,z1,z2,P.z[i]);
	return(Q);
    }

    public static  GoldenComplex transform(int L,GoldenComplex z1,GoldenComplex z2,GoldenComplex w) {
	if(L%2==0) return(transform0(z1,z2,w));
	return(transform1(z1,z2,w));
    }

    /**This is the translation that maps z1 to z2.**/

    public static  GoldenComplex transform1(GoldenComplex z1,GoldenComplex z2,GoldenComplex w) {
	GoldenComplex z=GoldenComplex.minus(z2,z1);
	return(GoldenComplex.plus(w,z));
    }


    /**This is the dilation by phi^3 that carries z1 to z2.*/

    public static  GoldenComplex transform0(GoldenComplex z1,GoldenComplex z2,GoldenComplex w) {
	 GoldenComplex z=GoldenComplex.minus(z2,z1);
	 GoldenComplex A=new GoldenComplex(1,2,0,0);
	 GoldenComplex h=GoldenComplex.minus(w,z1);
	 h=GoldenComplex.times(A,h);
	 h=GoldenComplex.plus(h,z1);
	 h=GoldenComplex.plus(h,z);
	 return(h);
    }


    /**FOR THE RENORM PROOF**/


    /**The list of A-characteristics*/

    public static int[] lookup(int k) {
	int[][] A={{0,0},{0,1},{0,2},{0,3},{0,4},{1,5},{2,0},{2,1},{2,2},{2,3},{2,4},{2,5},{3,0},{4,1},{4,2},{4,3},{4,4},{4,5}};return(A[k]);}



    /**This gets the list of heights at which we slice the B-partition**/

    public static GoldenReal[] getHeightsB(int LB) {
	int[][] H=DataHeightsRaw.heightB(LB); 
	GoldenReal[] LIST1=new GoldenReal[H.length];
	for(int i=0;i<H.length;++i) LIST1[i]=new GoldenReal(H[i][0],H[i][1]);
	LIST1=GoldenReal.interlace(LIST1);
	return(LIST1);
    }

    /**This gets the list of heights at which we slice the A-partition**/

    public static GoldenReal[] getHeightsA(int q) {
	int[][] H=DataHeightsRaw.heightA(q); 
	GoldenReal[] LIST1=new GoldenReal[H.length];
	for(int i=0;i<H.length;++i) LIST1[i]=new GoldenReal(H[i][0],H[i][1]);
	LIST1=GoldenReal.interlace(LIST1);
	return(LIST1);
    }

    /**This takes a list of GoldenPolyhedra and slices them at a given height**/

    public static GoldenPolyWedge[] slice(GoldenPolyhedron[] LIST,GoldenReal HEIGHT) {
	int total=0;
	GoldenPolyWedge[] LIST2=new GoldenPolyWedge[LIST.length];
	for(int i=0;i<LIST.length;++i) {
             GoldenPolyWedge Q=GoldenPolyCombinatorics.intersect(LIST[i],HEIGHT);
	     if(Q!=null) {
	        LIST2[total]=Q;
		++total;
	     }
	}
	LIST2=Lists.clean(LIST2,total);
	return(LIST2);
    }


    /**DISPLAYING THE OUTPUT**/

    public static void display(Manager M,GoldenPolyhedron[] LIST,GoldenReal h) {
	M.PC1.COUNT=0;
	for(int i=0;i<LIST.length;++i) {
	    M.PC1.nextPolyLast(LIST[i].toPolyhedron());
	}
        M.C.CON_P.PARAMETER[0]=h.toDouble();
	M.PC1.repaint();
	M.K.repaint();
    }


}


