import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;



public class RenormDisplay {
    public RenormDisplay() {}

    /**This class displays the renormalization tiles used in the following results:

       1. the fundamental orbit lemma (drawTri)
       2. the fixed point Lemma (drawFixedPoint)
       3. the reduction Lemma

    **/



    public static void drawTotal(Graphics2D g,Manager M,Output OUT) {
	int[] d=new int[12];
	int k1=M.C.CON_T.RENORM1.val;
	int k3=M.C.CON_T.RENORM3.val;
	int m=M.C.CON_T.SPECIAL.mode;
	if(m==1) drawTri(g,k1,M,OUT);
	if(m==2) drawFixedPoint(g,M,OUT);
	if(m==3) {
	    drawReduction(g,M);  //all the candidates
	    drawReduction2(g,M);  //band minimizers
	    drawReduction3(g,M);   //supermins
	} 
	/**draws the supermins and their renorms*/
	if(m==4) {
           drawReduction3(g,M);
	   drawReduction4(g,M);
	}
    }


    public static void drawTri(Graphics2D g,int k,Manager M,Output OUT) {
	int lim=DataFundamentalRaw.limit(k);
	int[] per=DataFundamentalRaw.periodic(k);
	int k0=M.C.CON_T.RENORM1.val;
	int i0=M.C.CON_T.RENORM1X.val;

	for(int i=0;i<lim;++i) {
	    PolyWedge P=DataFundamental.getPoly(k,i);
	    GeneralPath gp=P.toGeneralPath();
	    Color C=M.C.CON_T.FUND.L[0].C;   
            if((i==i0)&&(k==k0)) C=M.C.CON_T.FUND.L[2].C;

            OUT.polyPrint(gp,C,Color.black);
            gp=M.T.transform(gp);
	    g.setColor(C);
	    g.fill(gp);
	    g.setColor(M.C.CON_T.COLORS.L[1].C);
	    g.draw(gp);   
	}

	for(int i=0;i<per.length;++i) {
	    PolyWedge P=DataFundamental.getPoly(k,per[i]);
	    GeneralPath gp=P.toGeneralPath();
	    Color C=M.C.CON_T.FUND.L[1].C;  
            if((per[i]==i0)&&(k==k0)) C=M.C.CON_T.FUND.L[2].C;   
            OUT.polyPrint(gp,C,Color.black); 
            gp=M.T.transform(gp);
	    g.setColor(C);
	    g.fill(gp);
	    g.setColor(M.C.CON_T.COLORS.L[1].C);
	    g.draw(gp);
	}
    }


    public static void drawFixedPoint(Graphics2D g,Manager M,Output OUT) {	
           int i0=M.C.CON_T.RENORM2.val;

	for(int i=0;i<47;++i) {
	    PolyWedge P=DataFixedPoint.getPoly(i);
	    GeneralPath gp=P.toGeneralPath();
            Color C=M.C.CON_T.FIXED.L[0].C;   
            if(i==i0) C=M.C.CON_T.FIXED.L[2].C; 
            OUT.polyPrint(gp,C,Color.black); 
            gp=M.T.transform(gp);  
	    g.setColor(C);
	    g.fill(gp);
	    g.setColor(M.C.CON_T.COLORS.L[1].C);
	    g.draw(gp);
	}

	int[] per=DataFixedPointRaw.periodic();
	for(int i=0;i<per.length;++i) {
	    PolyWedge P=DataFixedPoint.getPoly(per[i]);
	    GeneralPath gp=P.toGeneralPath();
            Color C=M.C.CON_T.FIXED.L[1].C;   
            if(per[i]==i0) C=M.C.CON_T.FIXED.L[2].C;   
            OUT.polyPrint(gp,C,Color.black);    
            gp=M.T.transform(gp);
	    g.setColor(C);
	    g.fill(gp);
	    g.setColor(M.C.CON_T.COLORS.L[1].C);
	    g.draw(gp);
	}


    }


    public static void drawReduction(Graphics2D g,Manager M) {
	int total=0;
	for(int k=0;k<20;++k) {
	  int lim=DataReduction.limit(k);
	  total=total+lim;
	  Complex z=new Complex();
	  for(int i=0;i<lim;++i) {
	    PolyWedge P=DataReduction.getPoly(k,i);
	    GeneralPath gp=P.toGeneralPath();
	    gp=M.T.transform(gp);
	    g.setColor(M.C.CON_T.REDUCE.L[0].C);
	    g.fill(gp); 
            g.setColor(M.C.CON_T.COLORS.L[1].C);
	    g.draw(gp);   
	  }
	}
    }



    public static void drawReduction2(Graphics2D g,Manager M) {
	int[][] LIST=DataReductionRaw.taut();
	for(int q=0;q<LIST.length;++q) {
	    int k=LIST[q][0];
	    int i=LIST[q][1];
	    PolyWedge P=DataReduction.getPoly(k,i);
	    GeneralPath gp=P.toGeneralPath();
	    gp=M.T.transform(gp);
            g.setColor(M.C.CON_T.REDUCE.L[1].C);
	    g.fill(gp);
            g.setColor(M.C.CON_T.COLORS.L[1].C);
	    g.draw(gp);
	}
    }

    public static void drawReduction3(Graphics2D g,Manager M) {
	int[][] LIST=DataReductionRaw.superTaut();
	for(int q=0;q<LIST.length;++q) {
	    int k=LIST[q][0];
	    int i=LIST[q][1];
	    PolyWedge P=DataReduction.getPoly(k,i);
	    GeneralPath gp=P.toGeneralPath();
	    gp=M.T.transform(gp);
            g.setColor(M.C.CON_T.REDUCE.L[2].C);
	    g.fill(gp);
            g.setColor(M.C.CON_T.COLORS.L[1].C);
	    g.draw(gp);	   
	}
    }



    public static void drawReduction4(Graphics2D g,Manager M) {
      for(int k=0;k<11;++k) {
	int lim=DataReduction.limitRenorm(k);
	Complex z=new Complex();
	for(int i=0;i<lim;++i) {
	    PolyWedge P=DataReduction.getPolyRenorm(k,i);
	    GeneralPath gp=P.toGeneralPath();
	    gp=M.T.transform(gp);
            g.setColor(M.C.CON_T.REDUCE.L[2].C);
 	    g.fill(gp);
	    g.setColor(M.C.CON_T.COLORS.L[1].C);
	    g.draw(gp);
	}
      }
    }



}