import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


/**This routine does some sanity checks
   for the compactification theorem in the paper.*/


public class SanityCheck1 implements Runnable {
    Manager M;
    int halt; 
    int LIMIT,RANGE;
    PinwheelMap PIN;

    public SanityCheck1(Manager MM) {
	this.M=MM;
    }

    public void run() {
	LIMIT=M.C.CON_C.getPointNumber(); 
	RANGE=M.C.CON_C.getPointRange();
	PIN=new PinwheelMap();
	halt=1;
        int mode=M.C.CON_C.COMPACT.mode;
	if(mode==0) check0();
	if(mode==1) check1();
	if(mode==2) check2();
	if(mode==3) check3();
	if(mode==4) check4();
	if(mode==5) check5();
	if(mode==6) check6();
	if(mode==7) check7();
	if(mode==8) check8();
	if(mode==9) check9();
	if(mode==10) check10();
	if(mode==11) check11();
    }



    /**This is the most fundamental of all the checks in this class.
       It checks that the basic compactification is correct: If two
       points map into the same polyhedron then the return map is the
       same.**/

    public void check0() {
	System.out.println("start:");
	int trial=0;
	int k0=M.C.CON_C.INT[2].val;
	while((halt==1)&&(trial<LIMIT)) {
	    Complex z=Complex.random(RANGE);
	    z=PIN.zeta(z);
	    Vector V=TorusMap.theta(z);
	    int k=PolyhedronExchange.classify(V);
	    Complex w=PIN.pi(z);
	    Vector W=TorusMap.theta(w);
	    if(k==k0) {
		System.out.print(k+":  ");
		Vector X=Vector.minus(W,V);
		if(X.x[0]<0) X.x[0]=X.x[0]+2;
		if(X.x[1]<0) X.x[1]=X.x[1]+2;
		X.print();
	    }

	}

    }

    /**this routine recognizes that the vector lies in (4Z)^4**/

    public boolean recognize4Z(Vector4 V) {
	for(int j=0;j<4;++j) {
	    double x=V.x[j]/4.0;
	    x=Math.abs(x-Math.floor(x+.5));
	    if(x>.000000001) return(false);
	}
	return(true);
    }



    /**This routine checks that tilde_Ek o tilde_theta = tilde_theta o Ek mod (4Z)^4*/


    public void check1() {
	halt=1;
 	System.out.print("start:   ");
	int trial=0;

	while((halt==1)&&(trial<LIMIT)) {
          Complex z=Complex.random(RANGE);
	  for(int k=0;k<4;++k) {
	    Vector4 V1=Compactify.tilde_theta(z);
	    V1=Compactify.tilde_E(k,V1); 
	    Complex z1=PIN.E(k,z);
	    Vector4 V2=Compactify.tilde_theta(z1);
	    Vector4 V3=Vector4.minus(V1,V2);
	    boolean test=recognize4Z(V3);
	    if(test==false) {
                System.out.println("fail");
	    }

	  }
	  ++trial;
	}
	System.out.println("done "+trial);
    }


    /**checks that tilde_theta o zeta = tilde_zeta o tilde_theta**/

    public void check2() {
	System.out.println("start:");
	int trial=0;
	while((halt==1)&&(trial<LIMIT)) {
	    Complex z=Complex.random(RANGE);
            Vector V1=TorusMap.theta(PIN.zeta(z));
	    Vector V2=Compactify.tilde_zeta(Compactify.tilde_theta(z));
	    double test=Vector.dist(V1,V2);
	    if(test>.0000001) System.out.println("fail  ");
	    ++trial;
	}
	System.out.println("done "+trial);
    }


    /**checks that tilde_zeta o T = \tilde_zeta for T in (4Z)^4**/

    public void check3() {
	System.out.println("start check2:");
	int trial=0;

	while((halt==1)&&(trial<LIMIT)) {
            Vector4 V1=Vector4.random(RANGE);
	    Vector4 T=Vector4.random4Z(RANGE);
	    Vector W1=Compactify.tilde_zeta(V1);
	    Vector4 V2=Vector4.plus(V1,T);
            Vector W2=Compactify.tilde_zeta(V2);
	    double test=Vector.dist(W1,W2);
	    if(test>.0000001) System.out.println("fail  ");
	    ++trial;
	}
	System.out.println("done "+trial);
    }


    /*checks that tilde_zeta o I_t = Identity for the 4 fundamental choices of t.
      We choose V randomly so that it stays within the specific fundamental domain
      F used in the paper.*/


    public void check4() {
	System.out.println("start check 3:");
	int trial=0;
	while((halt==1)&&(trial<LIMIT)) {
	    Vector V=new Vector(.5+Math.random(),.5+Math.random(),2*Math.random());
	    for(int k=0;k<4;++k) {
		Vector4 W1=Compactify.I(k,V);
		Vector W=Compactify.tilde_zeta(W1);
                double test=Vector.dist(V,W);
                if(test>.0000001) {
                      System.out.println("fail  ");
		      V.print();
		}
	    }
	    ++trial;
	}
	System.out.println("done "+trial);
    }

    /**This routine contains a partial check that the embedding map
       tilde_theta maps Lk to tilde_Lk.  The point is that the
       strip spanning vectors are mapped to (4Z) integer vectors. and
       tilde_Lk is invariant under (4Z)^4**/

    public void check5() {
 	Vector4 V=new Vector4();
	Complex z=new Complex();

	System.out.println("start check 4");
	z=new Complex(0,4);
	V=Compactify.tilde_theta(z);
	V=Compactify.tilde_E(1,V);
	V.print();

	z=new Complex(2,-2);
	V=Compactify.tilde_theta(z);
	V=Compactify.tilde_E(2,V);
	V.print();

	double A=Math.sqrt(5)-2;
	z=new Complex(-2-2*A,0);
	V=Compactify.tilde_theta(z);
	V=Compactify.tilde_E(3,V);
	V.print();

	z=new Complex(2,2);
	V=Compactify.tilde_theta(z);
	V=Compactify.tilde_E(4,V);
	V.print();

    }

    /**checks that tilde_Ek o T = \tilde_Ek mod (4Z)^4 for T in (4Z)^4**/

    public void check6() {
	System.out.println("start check 5:");
	int trial=0;
	while((halt==1)&&(trial<LIMIT)) {
	    for(int k=0;k<4;++k) {
              Vector4 V1=Vector4.random(RANGE);
	      Vector4 T=Vector4.random4Z(RANGE);
	      Vector4 W1=Compactify.tilde_E(k,V1);
	      Vector4 V2=Vector4.plus(V1,T);
              Vector4 W2=Compactify.tilde_E(k,V2);
	      Vector4 W3=Vector4.minus(W2,W1);
	      boolean test=recognize4Z(W3);
	      if(test==false) System.out.println("fail");
	    }
	    ++trial;
	}
	System.out.println("done "+trial);
    }



    /**This map checks that the map 

         tilde_PI = tilde_zeta o tilde_E8 o ... tilde_E1

       is defined on the polyhedra I_i(P_j) for i=0,1,2,3 and j=0,...,63.
       This is just an informal check, and in order to make it work we
       slightly shrink the polyhedra to avoid boundaries of domains of
       definition.  The rigorous check does things differently, as
       described in the paper.**/


    public void check7() {	
	for(int i=0;i<64;++i) {
	    for(int q=0;q<4;++q) {
	      boolean test=checkPoly(q,i);  
              int[] e=sequencePoly(i);
	      System.out.print(q+" "+i+" "+test+"   ");
	      if(q==3) {
                  for(int k=1;k<=8;++k) System.out.print(e[k]+" ");
		  System.out.println("");
	      }
	    }
	}
    }


    public boolean checkPoly(int q,int i) {	
	Polyhedron P=DataPartition.getPolyhedron(i);
	P=P.retract(.99999);
	Polytope X=Compactify.I(q,P);
	for(int k=1;k<=8;++k) {
	   boolean test=Compactify.checkSqueezed(k,X);
	   if(test==false) return(false);
	   X=Compactify.tilde_E(k,X);
	}
	return(true);
    }


   public int[] sequencePoly(int i) {	
	Polyhedron P=DataPartition.getPolyhedron(i);
	Polytope X=Compactify.I(0,P);
	Vector4 V=X.getCenter();
	int[] u=Compactify.determineSequence(V);
	return(u);
   }





    /**These routine checks the exact maps against the numerical ones
       There is not exact agreement here because sometimes the golden
       maps deal with points on the boundaries of regions of definition.*/

    public void check8() {

	System.out.println("start check 7:");
	int trial=0;

	for(int i=0;i<LIMIT;++i) {
	    for(int k=0;k<4;++k) {  
              GoldenVector4 V1=GoldenVector4.random(RANGE);
	      GoldenVector4 V2=ProofCompact2.tilde_E(k,V1);
	      Vector4 W1=V1.toVector4();
	      Vector4 W2=Compactify.tilde_E(k,W1);
	      Vector4 X2=V2.toVector4();
	      X2=Vector4.cleanMinus(X2,W2);
	      X2.print();
	    }
	}
    }


    public void check9() {
	System.out.println("start check 8:");
	int trial=0;

	for(int i=0;i<LIMIT;++i) {
	    for(int k=0;k<4;++k) {
	      GoldenVector V=GoldenVector.random(RANGE);
	      GoldenVector4 W=ProofCompact2.I(k,V);
	      Vector VV=V.toVector();
	      Vector4 WW=Compactify.I(k,VV);
	      Vector4 X=W.toVector4();
	      X=Vector4.cleanMinus(X,WW);
	      X.print();
	    }
	}
    }



    /**checks that tilde_Pi o tilde_theta = theta o Pi**/

    public void check10() {
	System.out.println("start:");
	int trial=0;

	while((halt==1)&&(trial<LIMIT)) {
	    Complex z=Complex.random(RANGE);
	    z=PIN.zeta(z);

	    Vector V1=TorusMap.theta(PIN.pi(z));
	    Vector V2=Compactify.tilde_pi(Compactify.tilde_theta(z));
	    double test=Vector.dist(V1,V2);
	    if(test>.0000001) System.out.println("fail  ");
	    ++trial;
	}
	System.out.println("done "+trial);
    }



    public void check11() {
	System.out.println("start:");
	int trial=0;

	while((halt==1)&&(trial<LIMIT)) {
	    Complex z=Complex.random(RANGE);
	    z=PIN.zeta(z);
	    Vector V=TorusMap.theta(z);
	    int k=PolyhedronExchange.classify(V);
	    if(k==32) {
		Complex w=PIN.pi(z);
		Vector V1=TorusMap.theta(z);
		Vector V2=TorusMap.theta(w);
		Vector W=Vector.minus(V1,V2);
  	        W=clean(W);
		W.print();
	    }

	}
    }



    public Vector clean(Vector V) {
	Vector W=new Vector(V);
	W.x[0]=2*TorusMap.dec(W.x[0]/2);
	W.x[1]=2*TorusMap.dec(W.x[1]/2);
	if(W.x[0]>1.99999) W.x[0]=0;
	if(W.x[1]>1.99999) W.x[1]=0;
	if(Math.abs(W.x[0])<.000001) W.x[0]=0;
	if(Math.abs(W.x[1])<.000001) W.x[1]=0;
	if(Math.abs(W.x[2])<.000001) W.x[2]=0;
	return(W);
    }

}

