import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


/**This routine does some sanity checks
   for the compactification theorem in the paper.*/


public class SanityCheck2 implements Runnable {
    Manager M;
    int halt; 
    int LIMIT,RANGE;

    public SanityCheck2(Manager MM) {
	this.M=MM;
    }



    public void run() {
	LIMIT=M.C.CON_C.getPointNumber(); 
	RANGE=M.C.CON_C.getPointRange();
	halt=1;
        int mode=M.C.CON_C.PEX.mode;
	if(mode==0) check0();
	if(mode==1) check1();
	if(mode==2) check2();
	if(mode==3) check3();
    }



    /**This checks that the goldenvector version of the
       torus map agrees with the original one, up to 
       elements of (2Z)^3**/

    public void check0() {	
	System.out.println("start "+LIMIT+" "+RANGE);
	for(int i=0;i<LIMIT;++i) {
	double x=RANGE*Math.random();
	double y=2*Math.random();
	GoldenReal gx=new GoldenReal(x,1000);
	GoldenReal gy=new GoldenReal(y,1000);
	GoldenComplex gw=new GoldenComplex(gx,gy);
	Complex ww=gw.toComplex();
	 Vector V=TorusMap.theta(ww);
	 GoldenVector GV=VerifySupport.theta(gw);
	 Vector V2=GV.toVector();
	 V2=V2.scale(.5);
	 boolean test=checkAssociate(V,V2);
	 if(test==false) {
             System.out.println("fail");
	     V.print();
	     V2.print();
	 }
	}
	System.out.println("done");

    }


    public static boolean checkAssociate(Vector V1,Vector V2) {

	for(int i=-2;i<=2;i=i+2) {
	    for(int j=-2;j<=2;j=j+2) {
		for(int k=-2;k<=2;k=k+2) {
		    Vector W2=Vector.plus(V2,new Vector(i,j,k));
		    if(Vector.dist(W2,V1)<.000000001) return(true);
		}
	    }
	}
	return(false);
    }


    public void check1() { 
	    PolyWedge[] LIST2=new PolyWedge[184];
	    for(int i=0;i<184;++i) LIST2[i]=DataReduction.getPoly(0,i);
	    int total=0;
	    PolyWedge[] LIST3=new PolyWedge[184];
	    for(int i=0;i<184;++i) {
		if(centerMatch(LIST2[i],LIST3,total)==false) {
		    LIST3[total]=LIST2[i];
		    ++total;
		}
	    }
	    for(int i=0;i<total;++i) {
		GoldenPolyWedge P=new GoldenPolyWedge(LIST3[i],20,.0000001);
		P.print2();
	    }
	    System.out.println("--");
	    System.out.println(total);
    }





    public void check2() {
	int total=0;
	for(int LB=0;LB<6;++LB) {
	for(int br=0;br<4;++br) {
	    total=total+DataRenormReturn.limits(LB,br);
	}
	}
	System.out.println(total);
    }



    public void check3() {

	int a=21892;
	int b=28657;
	int c=a*b;

	System.out.println(c);
    }




    public static boolean centerMatch(PolyWedge X,PolyWedge[] DONE,int tot) {
	for(int i=0;i<tot;++i) {
	    if(centerMatch(X,DONE[i])==true) return(true);
	}
	return(false);
    }


    public static boolean centerMatch(PolyWedge P,PolyWedge Q) {
	Complex p=P.getCenter();
	Complex q=Q.getCenter();
	if(Complex.dist(p,q)<.000000001) return(true);
	return(false);
    }



}





