import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;

/**This class sends information about the polygons to the coordinate window for display.**/

public class TileStats {

    /**THE TILE STATS**/

    public static void stats(ControlCanvas K,PolyWedge W,Complex SOURCE,int TILETYPE,boolean verify) {
	GoldenPolyWedge G=getGolden(W);
	boolean test1=goodRepresentative(W,G);
	sendOrbitSize(K,W);
	if(test1==true) sendPolyCoords(K,W,SOURCE,G);
	int count=K.COUNT;
	if((G!=null)&&(verify==true)) sendVerify(K,W,TILETYPE,true);
	K.repaint();
    }

    public static GoldenPolyWedge getGolden(PolyWedge W) {
	GoldenPolyWedge G=new GoldenPolyWedge();
	try{
	  G=new GoldenPolyWedge(W,20,.000000001);  
          G.orbit=W.strip;
	}
	catch(Exception e) {G=null;}
	return(G);
    }

    /**the boolean variable reverse is currently not used.**/

    public static void sendVerify(ControlCanvas K,PolyWedge W,int TILETYPE,boolean reverse) {
	GoldenPolyWedge G=getGolden(W);
	int count=K.COUNT;

	if(TILETYPE==1) {
            int test=VerifyTile.verifyPeriodic(G,G.orbit,false);
  	    if(test!=-1) K.MESSAGE[count]="verified";
  	    if(test==-1) K.MESSAGE[count]="not verified";
	}

     	if(TILETYPE==3) {
	    int[] test=VerifyRenorm.verifyA(G);
	    if(test!=null) K.MESSAGE[count]="verified";
	    if(test==null) K.MESSAGE[count]="not verified";
	}
	K.COLOR[count]=Color.white;
	++count;
        K.COUNT=count;
    }

    public static void sendOrbitSize(ControlCanvas K,PolyWedge W) {
	Integer I=new Integer(W.orbit);
	K.MESSAGE[0]="pinwheel orbit";
        I=new Integer(W.strip);
	K.MESSAGE[1]=I.toString();
	K.COLOR[0]=Color.white;
	K.COLOR[1]=Color.white;
	K.COUNT=2;
    }

    public static void sendPolyCoords(ControlCanvas K,PolyWedge W,Complex SOURCE,GoldenPolyWedge G) {	
        int count=K.COUNT;
  	int index=W.getClosest(SOURCE);
        for(int i=0;i<G.count;++i) {
	   String S=G.z[i].x.toString();
	   K.MESSAGE[count]=S; 
           K.COLOR[count]=Color.white;
           if(i==index) K.COLOR[count]=Color.yellow; 
	   ++count;
           S=G.z[i].y.toString();
           K.MESSAGE[count]=S;
	   K.COLOR[count]=Color.white;
           if(i==index) K.COLOR[count]=Color.yellow; 
	   ++count;
	}
        K.COUNT=count;
    }


    /**A SANITY CHECK**/

     /**This checks the matching properties of a polygon and its exact
        representative.  This is not a rigorous part of the test, but
        rather a sanity check.  If the routine fails, it means that we
        are not checking the correct golden polygon.**/


    public static boolean goodRepresentative(PolyWedge P,GoldenPolyWedge G) {
	if(G==null) return(false);
	for(int i=0;i<P.count;++i) {
	    Complex z1=P.z[i];
	    Complex z2=G.z[i].toComplex();
	    double d=Complex.dist(z1,z2);
	    if(d>.000000001) return(false);
	}
	return(true);
    }



}