import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;


public class TorusMap {

    /**Computes the relative position of x in [0,1]**/
    public static double dec(double x) {
	return(x-Math.floor(x));
    }


    /**Computes  the relative position of x in the interval [0,k]**/

    public static double dec(double k,double x) {
	return(k*dec(x/k));
    }

    /**Maps from the arithmetic graph plane into the dynamical (strip) plane**/

    public static Complex gridToStrip(int x,int y,double offsetX,double offsetY) {
	double fudge=.00000000001;
	int parity=(x+y+100000)%2;
	double A=GoldenRatio.phi(-3);
	double x1=2*x*A+2*y+offsetX+fudge;
	double x2=-2+2*parity+offsetY;
	Complex w=new Complex(x1,x2);
	return(w);
    }



    /**Maps from the strip into the torus, forgetting the 3rd coordinate**/
    public static Complex stripToTorus(Complex z) {
        double B=GoldenRatio.phi(-1);
        Complex z1=new Complex(1+z.x*B,.5*(1+z.x-z.y));
	Complex z2=fundamentalDomain(z1);
	return(z2);
    }

    public static double functional(Complex z) {
	double A=GoldenRatio.phi(-3);
	double t=-A*z.y+z.x+A;
	return(t);
    }

    public static Complex fundamentalDomain(Complex z1) {
        Complex z2=new Complex(dec(2,z1.x),dec(2,z1.y));
	if(functional(z2)<0) z2.x=z2.x+2;
	if(functional(z2)>2) z2.x=z2.x-2;
	return(z2);
    }

    /**starts with an arbitrary vector and moves it to the
       fundamental domain**/

    public static Vector fundamentalDomain(Vector V) {
	Complex z=new Complex(V.x[0],V.x[1]);
	double h=V.x[2];
	h=dec(2,h);
	z=fundamentalDomain(z);
	Vector W=new Vector(z.x,z.y,h);
	return(W);
    }


    public static Polyhedron fundamentalDomain(Polyhedron P) {
	Vector V1=P.getCenter();
	Vector V2=fundamentalDomain(V1);
	Vector V3=Vector.minus(V2,V1);
	return(P.translate(V3));
    }






    /**Maps from the strip into the torus, adding the third coordinate**/
    public static Vector theta(Complex z) {
	Complex z2=stripToTorus(z);
	Vector V=new Vector(z2.x,z2.y,dec(2,z.y));
	return(V);
    }


    /**Maps from the arithmetic graph plane into the torus**/
    public static Complex map(int x,int y,double offsetX,double offsetY) {
	Complex w=gridToStrip(x,y,offsetX,offsetY);
	Complex z=stripToTorus(w);
	return(z);
    }

}


    

