import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

/*This class does the basic arithmetic
  of vectors */


public class Vector {
    double[] x=new double[3];
    public Vector(){}

    public Vector(Vector V){
	x[0]=V.x[0];
	x[1]=V.x[1];
	x[2]=V.x[2];
    }


    public Vector(Complex z) {
	x[0]=z.x;
	x[1]=z.y;
	x[2]=1.0;
    }

    public Vector(double x0,double x1,double x2) {
	x[0]=x0;
	x[1]=x1;
	x[2]=x2;
    }

    public Vector(double xx,double yy) {
	x[0]=xx;
	x[1]=yy;
	x[2]=1.0;
    }



    /** W --> tW + V**/

    public Vector affine(double t,Vector V) {
	return(plus(V,this.scale(t)));
    }

    /** W -> (1/t) W - (1/t) V**/

    public Vector affineInverse(double t,Vector V) {
	double s=1/t;
	return(minus(this.scale(s),V.scale(s)));
    }

    /** going from the raw data**/
    public static Vector affine(int[] a,Vector W) {
	GoldenReal gr=new GoldenReal(a[0],a[1]);
	double r=gr.toDouble();
	GoldenVector GV=new GoldenVector(a[2],a[3],a[4],a[5],a[6],a[7]);
	Vector V=GV.toVector();
	return(W.affine(r,V));
    }
    /** going from the raw data**/
    public static Vector affineInverse(int[] a,Vector W) {
	GoldenReal gr=new GoldenReal(a[0],a[1]);
	double r=gr.toDouble();
	GoldenVector GV=new GoldenVector(a[2],a[3],a[4],a[5],a[6],a[7]);
	Vector V=GV.toVector();
	return(W.affineInverse(r,V));
    }

    public static Vector plus(Vector V1,Vector V2) {
	Vector W=new Vector(V1.x[0]+V2.x[0],V1.x[1]+V2.x[1],V1.x[2]+V2.x[2]);
	return(W);
    }

    public static Vector minus(Vector V1,Vector V2) {
	Vector W=new Vector(V1.x[0]-V2.x[0],V1.x[1]-V2.x[1],V1.x[2]-V2.x[2]);
	return(W);
    }

    public static Vector cleanMinus(Vector V1,Vector V2) {
	Vector W=new Vector(V1.x[0]-V2.x[0],V1.x[1]-V2.x[1],V1.x[2]-V2.x[2]);
	for(int i=0;i<3;++i) {
	    if(Math.abs(W.x[i])<.0000000001) W.x[i]=0;
	}
	return(W);
    }


    public static Vector scale(double r,Vector V) {
	Vector W=new Vector(r*V.x[0],r*V.x[1],r*V.x[2]);
	return(W);
    }

    public Vector scale(double r) {
	Vector W=new Vector(r*x[0],r*x[1],r*x[2]);
	return(W);
    }


    public static Vector interpolate(double s,Vector V1,Vector V2) {
	Vector W1=scale((1-s),V1);
	Vector W2=scale(s,V2);
	Vector W3=plus(W1,W2);
	return(W3);
    }

    public double norm() {
	return(dist(this,new Vector(0,0,0)));
    }

    public Vector negate() {
	return(new Vector(-x[0],-x[1],-x[2]));
    }

    public static double dist(Vector W1,Vector W2) {
	double x=W1.x[0]-W2.x[0];
	double y=W1.x[1]-W2.x[1];
	double z=W1.x[2]-W2.x[2];
	double d=x*x+y*y+z*z;
	d=Math.sqrt(d);
	return(d);
    }


    /**Checks if W is between V1 and V2**/

    public static int between(Vector V1,Vector W,Vector V2) {
	double d1=dist(W,V1);
	double d2=dist(W,V2);
	double d3=dist(V1,V2);
	if(d1+d2-d3<.00000000001) return(1);
	return(0);
    }


    public Vector pullback(Complex z) {
	Vector V=new Vector();
	V.x[0]=x[0]-z.x;
	V.x[1]=x[1]-z.y;
	V.x[2]=1.0;
	return(V);
    }

    /**does one step of gram-schmidt**/

    public static Vector ortho(Vector V,Vector W) {
	double t=dot(V,W)/dot(W,W);
	Vector X=new Vector();
	for(int i=0;i<3;++i) X.x[i]=V.x[i]-t*W.x[i];
	return(X.unit());
    }

    public Vector unit() {
	Vector X=new Vector();
	double n=this.norm();
	for(int i=0;i<3;++i) X.x[i]=this.x[i]/n;
	return(X);
    }



    public static double  dot(Vector v,Vector w) {
	return(v.x[0]*w.x[0]+v.x[1]*w.x[1]+v.x[2]*w.x[2]);
    }

    public static Vector cross(Vector v,Vector w) {
	Vector X=new Vector();
	X.x[0]=v.x[1]*w.x[2]-w.x[1]*v.x[2];
	X.x[1]=v.x[2]*w.x[0]-w.x[2]*v.x[0];
	X.x[2]=v.x[0]*w.x[1]-w.x[0]*v.x[1];
	return(X);
    }

    public void print() {
	System.out.println(x[0]+" "+x[1]+" "+x[2]);
    }


    public Vector normalize() {
	Vector W=new Vector();
	W.x[0]=this.x[0]/this.x[2];
	W.x[1]=this.x[1]/this.x[2];
	W.x[2]=1;
	return(W);
    }

    public static Vector normal(Vector W0,Vector W1,Vector W2) {
	Vector X1=minus(W1,W0);
	Vector X2=minus(W2,W0);
	return(cross(X1,X2));
    }



    public static boolean isPositiveMultiple(Vector V1,Vector V2) {
	Vector W=cross(V1,V2);
	if(W.norm()>.00000001) return(false);
	for(int i=0;i<3;++i) {
	    double r=V1.x[i]*V2.x[i];
	    if(r<0) return(false);
	}
	return(true);
    }


    public static double tripleProduct(Vector v1,Vector v2,Vector v3) {
	return(dot(cross(v1,v2),v3));
    }

    public static double tripleProduct2(Complex z1,Complex z2,Complex z3) {
	Vector v1=new Vector(z1);
	Vector v2=new Vector(z2);
	Vector v3=new Vector(z3);
	return(tripleProduct(v1,v2,v3));
    }



    public Complex  toComplex() {
	return(new Complex(x[0]/x[2],x[1]/x[2]));
    }

    public static Vector findCross(Vector v1,Vector v2,Vector v3,Vector v4) {
	Vector v5=cross(v1,v2);
	Vector v6=cross(v3,v4);
	Vector v7=cross(v5,v6);
	return(v7);
    }

    public static Complex findCross(Complex z1,Complex z2,Complex z3,Complex z4) {
	Vector v1=new Vector(z1);
	Vector v2=new Vector(z2);
	Vector v3=new Vector(z3);	
        Vector v4=new Vector(z4);
	Vector v5=findCross(v1,v2,v3,v4);
	return(v5.toComplex());
    }


    public static Vector random(double RANGE) {
          double x1=2*RANGE*Math.random()-RANGE;
	  double x2=2*RANGE*Math.random()-RANGE; 
	  double x3=2*RANGE*Math.random()-RANGE; 
	  return(new Vector(x1,x2,x3));
    }



}




