import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

/*This class does the basic arithmetic
  of 4D vectors */


public class Vector4 {
    double[] x=new double[4];

    public Vector4(){}

    public Vector4(Vector4 V){
	x[0]=V.x[0];
	x[1]=V.x[1];
	x[2]=V.x[2];
	x[3]=V.x[3];
    }


    public Vector4(double x0,double x1,double x2,double x3) {
	x[0]=x0;
	x[1]=x1;
	x[2]=x2;
	x[3]=x3;
    }

    public Vector4(double[] y) {
	x[0]=y[0];
	x[1]=y[1];
	x[2]=y[2];
	x[3]=y[3];
    }


    public static Vector4 plus(Vector4 V1,Vector4 V2) {
	Vector4 W=new Vector4(V1.x[0]+V2.x[0],V1.x[1]+V2.x[1],V1.x[2]+V2.x[2],V1.x[3]+V2.x[3]);
	return(W);
    }

    public static Vector4 minus(Vector4 V1,Vector4 V2) {
	Vector4 W=new Vector4(V1.x[0]-V2.x[0],V1.x[1]-V2.x[1],V1.x[2]-V2.x[2],V1.x[3]-V2.x[3]);
	return(W);
    }


    public static Vector4 cleanMinus(Vector4 V1,Vector4 V2) {
	Vector4 W=new Vector4(V1.x[0]-V2.x[0],V1.x[1]-V2.x[1],V1.x[2]-V2.x[2],V1.x[3]-V2.x[3]);
	for(int i=0;i<4;++i) {
            if(Math.abs(W.x[i])<.000000001) W.x[i]=0;
	}
	return(W);
    }


    public double norm() {
	return(dist(this,new Vector4(0,0,0,0)));
    }


    public static double dist(Vector4 W1,Vector4 W2) {
	double x=W1.x[0]-W2.x[0];
	double y=W1.x[1]-W2.x[1];
	double z=W1.x[2]-W2.x[2];
	double w=W1.x[3]-W2.x[3];
	double d=x*x+y*y+z*z+w*w;
	d=Math.sqrt(d);
	return(d);
    }

    public double[] toComponents() {
	double[] y=new double[4];
	for(int i=0;i<4;++i) y[i]=this.x[i];
	return(y);
    }

    public void print() {
	System.out.println(x[0]+" "+x[1]+" "+x[2]+" "+x[3]);
    }

    public static Vector4 random(double RANGE) {
          double x1=2*RANGE*Math.random()-RANGE;
	  double x2=2*RANGE*Math.random()-RANGE; 
	  double x3=2*RANGE*Math.random()-RANGE; 
	  double x4=2*RANGE*Math.random()-RANGE; 
	  return(new Vector4(x1,x2,x3,x4));
    }

    public static Vector4 random4Z(double RANGE) {
          double x1=2*RANGE*Math.random()-RANGE;
	  double x2=2*RANGE*Math.random()-RANGE; 
	  double x3=2*RANGE*Math.random()-RANGE; 
	  double x4=2*RANGE*Math.random()-RANGE; 
	  Vector4 V=new Vector4(x1,x2,x3,x4);
	  for(int i=0;i<4;++i) V.x[i]=4*Math.floor(V.x[i]/4);
	  return(V);
    }


}




