import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;
import java.io.*;


/**This class computes the symbolic sequences for the bands and verifies that
   they are correct. It also verifies the claimed discrepancies between the
   corresponding A and B bands.**/

public class VerifyChains {


    /**These routines verify that the given itinerary works for
       an interior point of the polyhedron.  We use these routines
       for the proof of the Far Reduction Theorem.**/

    public static boolean verifyA(GoldenPolyhedron P,int[] I) {
	GoldenVector W=P.cheapInterior();
	W=W.scale(new GoldenReal(2,0));
        boolean test=VerifyTile.testFeasible(W,I);
	return(test);
    }

    public static boolean verifyB(GoldenPolyhedron P,int[] I,boolean iso) {
	GoldenVector W=P.cheapInterior();
	W=W.scale(new GoldenReal(2,0));
	boolean test=false;
	if(iso==true) test=VerifyTile.testFeasible(W,I);
	if(iso==false) test=VerifyTile.testFeasibleInverse(W,I);
	return(test);
    }


    /**This routine verifies that a given pair of
       numbers serves as lower and upper bounds for 
       the range.**/

    public static boolean verifyRange(int[] list,GoldenReal[] target,boolean choice,boolean iso) {
	GoldenReal A=new GoldenReal(-3,2);    //phi^{-3}
	int[] t={0,0};
	for(int i=0;i<list.length;++i) {
          int[] move=DataPartition.getMove(list[i]);
	  t[0]=t[0]+move[0];
	  t[1]=t[1]+move[1];
	  GoldenReal test=goldenMap(t[0],t[1]);
	  if((choice==true)&&(iso==false)) test=GoldenReal.times(test,A);
	  if(GoldenReal.isLess(test,target[0])==true) return(false);
	  if(GoldenReal.isLess(target[1],test)==true) return(false);
	}
	return(true);
    }


    /**In the isometric case, checks that rangeA lies in [rangeB-9,rangeB+9].
       In the expansive case, checks that rangeA lies in [rangeB-5,rangeB+5]**/

    public static boolean verifyMismatch(GoldenReal[] rangeA,GoldenReal[] rangeB,boolean iso) {
	GoldenReal FIVE=new GoldenReal(5,0);
	GoldenReal BOUND=new GoldenReal(-20,24);  //8.24...
	GoldenReal r1=GoldenReal.minus(rangeA[1],rangeB[1]);
	GoldenReal r2=GoldenReal.minus(rangeB[0],rangeA[1]);
	if((iso==true)&&GoldenReal.isLess(BOUND,r1)==true) return(false);
	if((iso==true)&&GoldenReal.isLess(BOUND,r2)==true) return(false);
	if((iso==false)&&GoldenReal.isLess(FIVE,r1)==true) return(false);
	if((iso==false)&&GoldenReal.isLess(FIVE,r2)==true) return(false);
	return(true);
    }




    /**This routine uses floating point arithmetic to
       make a guess at the range.  Once we have 
       the guess, we verify using exact arithmetic
       that it works.**/

    public static GoldenReal[] getRange(int[] list,boolean choice,boolean iso) {
	double min=0;
	double max=0;
	double A=GoldenRatio.phi(-3);
	int[] t={0,0};
	for(int i=0;i<list.length;++i) {
          int[] move=DataPartition.getMove(list[i]);
	  t[0]=t[0]+move[0];
	  t[1]=t[1]+move[1];
	  double test=doubleMap(t[0],t[1]);
	  if(min>test) min=test;
	  if(max<test) max=test;
	}

	if((choice==true)&&(iso==false)) {
	   min=min*A;
	   max=max*A;
	}

	GoldenReal gmin=new GoldenReal(min,20,.00000001);
	GoldenReal gmax=new GoldenReal(max,20,.00000001);
	GoldenReal[] g={gmin,gmax};
	return(g);
    }


    /**These moves implement the map from the arithmetic graph
       on the Z^2 grid to the strip Sigma*/

    public static GoldenReal goldenMap(int t0,int t1) {
	GoldenReal A2=new GoldenReal(-6,4);   //2 phi^{-3}
	GoldenReal TWO=new GoldenReal(2,0);
	GoldenReal g0=new GoldenReal(t0,0);
	GoldenReal g1=new GoldenReal(t1,0);
	GoldenReal test=GoldenReal.plus(GoldenReal.times(TWO,g0),GoldenReal.times(A2,g1));
	return(test);
    }

    public static double doubleMap(int t0,int t1) {
	double A=GoldenRatio.phi(-3);
	return(2*t0+2*A*t1);
    }




}


