import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;
import java.io.*;

/**The purpose of this routine is to check that every
face of an interior B-atom either has an undefined orbit
or maps into the boundary of the B-renorm set. THis shows
that the B-atoms are maximal, and hence pairwise disjoint.**/

public class VerifyMaximal {


    public static GoldenPolyhedron makeFace(GoldenPolyhedron P,int[] X) {
        GoldenPolyhedron F=new GoldenPolyhedron();
	F.count=X.length;
	for(int i=0;i<X.length;++i) {
           F.V[i]=P.V[X[i]];
	}
	return(F);
    }


    public static int[] facesInB(int LB,GoldenPolyhedron P0) {
	GoldenPolyhedron P=VerifySupport.scale2(P0);
	int[][] X=GoldenPolyCombinatorics.faceList(P);
	int[] J=new int[10];
	int total=0;
	for(int i=0;i<X.length;++i) {
	    GoldenPolyhedron F=makeFace(P,X[i]);
	    boolean test=boundaryTestB(LB,F);
            if(test==true) {
		J[total]=i;
		++total;
	    }
	}
	if(total==0) return(null);
	int[] J2=new int[total];
	for(int i=0;i<total;++i) J2[i]=J[i];
	return(J2);
    }



/**The purpose of this class is to provide routines which
   verify that the orbit of a polygon under the polyhedron
   exchange map is completely undefined.  The routines are
   means to be applied to the faces of the renorm tiles.**/


    public static int[] undefinedFaces(GoldenPolyhedron P0,int[] I) {
	GoldenPolyhedron P=VerifySupport.scale2(P0);
	int[][] X=GoldenPolyCombinatorics.faceList(P);
	int[] J=new int[10];
	int total=0;
	for(int i=0;i<X.length;++i) {
	    GoldenPolyhedron F= makeFace(P,X[i]);
	    GoldenVector V=F.cheapInterior();
	    boolean test=testUndefinedFace(V,I);
	    if(testHorizontal(F)==true) test=true; //ignore horizontal faces
	    if(test==false) {
		J[total]=i;
		++total;
	    }
	}
	if(total==0) return(null);
	int[] J2=new int[total];
	for(int i=0;i<total;++i) J2[i]=J[i];
	return(J2);
    }


    public static boolean testUndefinedFace(GoldenVector V0,int[] I) {
	GoldenVector V=new GoldenVector(V0);

	for(int i=0;i<I.length;++i) {
	    boolean face=testInsideFace(V,I[i]);
	    if(face==true) return(true); 
	    V=VerifyTile.getAssociate(V,I[i]);
            V=VerifyTile.doDynamicsPlus(V,I[i]);  
	}
	return(false);
    }

    /**This tests whether the vector is contained in a single
       face of the qth partition polyhedron.   F is assumed to
       be scaled up by a factor of 2 from the floating point
       case, and also normalized to lie correctly in the
       fundamental domain.**/


    public static boolean testInsideFace(GoldenVector W,int q) {
	GoldenPolyhedron P=DataPartition.getGoldenPolyhedron(q);
	P=P.scale(new GoldenReal(2,0));
	int[] N=DataPartitionRaw.polyNormal(q);
	int[] A=DataPartitionRaw.faceAnchor(q);
	for(int i=0;i<A.length;++i) {
	    GoldenVector n=DataPartition.getNormal(N[i]);
	    GoldenVector p0=P.V[A[i]];
	    boolean face=true;
	    GoldenReal test=GoldenVector.dot(n,GoldenVector.minus(p0,W));
	    if(test.isZero()==true) return(true);
	}
	return(false);

    }

    /**This tests if a polygon is horizontal**/

    public static boolean testHorizontal(GoldenPolyhedron P) {
	GoldenVector W=GoldenVector.normal(P.V[0],P.V[1],P.V[2]);
	if(W.x[0].isZero()==false) return(false);
	if(W.x[1].isZero()==false) return(false);
	if(W.x[2].isZero()==true) throw(new ProofException("testHorizontal"));
	return(true);
    }



    /**This tests if the face P is contained in one of the B-branches
       in the layer LB.*/

    public static boolean boundaryTestB(int LB,GoldenPolyhedron P) {
	GoldenVector V=P.cheapInterior();
	return(boundaryTestB(LB,V));
    }

    public static boolean boundaryTestB(int LB,GoldenVector V) {
	for(int br=0;br<4;++br) {
	    boolean test=VerifySupport.insideB(LB,br,V,true);
	    if(test==true) return(true);
	}
	return(false);
    }



}