import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;
import java.io.*;


/**This tile does one of 2 things.

1. Verifies that a given A-renorm tile P is not the
   tile in the band orbit that minimizes min|P|.

2. Verifies that a given A-renorm tile P has a renormalization
   Q such that max|Q|<min|P|-1/4

Here min|P| is the minimal value of |x|, where (x,y)=p is a point of P. 
Also max|Q| is the maximal calue of |x|, where (x,y)=q is a point of Q.
**/



public class VerifyReduction  {



    public static boolean verifySameChain(GoldenComplex z0,GoldenComplex z1,GoldenComplex z2) {
	GoldenVector V0=VerifySupport.theta(z0);
	GoldenVector V1=VerifySupport.theta(z1); 
	GoldenVector V2=VerifySupport.theta(z2); 
	Vector W0=V0.toVector();
	W0=W0.scale(.5);
	int[] I=VerifySupport.itineraryAB(W0,true,true,true); 
	if(GoldenVector.equals(V1,V2)==true) return(true);
        int[] L=Characteristics.getCharA(z0.y.dec(2));
        boolean test=hits(L,V0,V1,I);
	if(test==false) return(false);
	if(GoldenVector.equals(V0,V2)==true) return(true);  //z2 is at start of band
	test=hits(L,V0,V2,I);
	return(test);
    }



    /**This routine tests of the polyhedron exchange map carries W0 to W1
       before it carries W0 into the A-renorm set. Along the way, it
       verifies that the given itinerary is correct.*/

    public static boolean hits(int[] L,GoldenVector W0,GoldenVector W1,int[] I) {
	GoldenVector W=new GoldenVector(W0);
	for(int i=0;i<I.length;++i) {
            if(VerifyTile.testInside(W,I[i])==false) throw(new ProofException("VerifyBand: hits"));
            W=VerifyTile.doDynamicsPlus(W,I[i]);  
            boolean ins=VerifySupport.insideA(W,L);
	    if(ins==true) return(false);
	    if(GoldenVector.equals(W,W1)==true) return(true);
	}
	return(false);
    }
 


    /**COMPARISON TESTS**/

    /** Let min|A|_x denote the maximum absolute value of the x coordinates
        of A.  Likewise define max|B|_x. This routine returns true if 
        max|B| + U < min |A|_x.  Here U = 89 - 55 phi  ~ .002 **/


    public static boolean phiTest(GoldenPolyWedge A,GoldenPolyWedge B) {
	for(int i=0;i<A.count;++i) {
	    for(int j=0;j<B.count;++j) {
		if(phiTest(A.z[i].x,B.z[j].x)==false) return(false);
	    }
	}
	return(true);
    }

    /**returns true if |r2|_x + U < |r1|_x*/

    public static boolean phiTest(GoldenReal r1,GoldenReal r2) {
	GoldenReal s1=new GoldenReal(r1);
	GoldenReal s2=new GoldenReal(r2);
	if(s1.isPositive()==false) s1=s1.negate();
	if(s2.isPositive()==false) s2=s2.negate();
	GoldenReal t=new GoldenReal(-6,4);
	s2=GoldenReal.plus(s2,t);
	return(GoldenReal.isLess(s2,s1));
    }

    /**returns true if |r2|_x <= |r1|_x*/

    public static boolean zeroTest(GoldenReal r1,GoldenReal r2) {
	GoldenReal s1=new GoldenReal(r1);
	GoldenReal s2=new GoldenReal(r2);
	if(s1.isPositive()==false) s1=s1.negate();
	if(s2.isPositive()==false) s2=s2.negate();
	if(GoldenReal.equals(s1,s2)==true) return(true);
	return(GoldenReal.isLess(s2,s1));
    }










}
