import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;
import java.io.*;


public class VerifyRenorm  {

    /**This class has the routines that verify that a given POLYGON,
       or pairs of POLYGONS, map into renorm tiles.  These routines 
       are used in the proofs of the
       Fundamental Orbit Theorem
       FixedPoint Theorem
       Near Reduction Theorem
       Far Reduction Theorem
       There is a similar class that works directly with the polywedges.*/


    /*Here is the main routine.*/

    public static int[] verify(GoldenPolyWedge A,GoldenPolyWedge B) {
	return(verify(A,B,false));
    }

    public static int[] verify(GoldenPolyWedge A,GoldenPolyWedge B,boolean print) {
	int[] fail={-1,-1};
	//first we check that A is an A-tile
	int[] itineraryA=verifyA(A);
	if(itineraryA==null) return(fail);


	//now we check that B is a B-tile
	int[] L=VerifySupport.getCharA(A);
	boolean reverse=false;
	if(L[0]%2==0) reverse=true;
	int[] itineraryB=verifyB(B,reverse);
	if(itineraryB==null) return(fail);

	//now we check that the A-->B
	boolean test3=verifyAtoB(A,B,itineraryA,itineraryB);
	if(test3==false) return(fail);
	int[] TEST={itineraryA.length,itineraryB.length};

	return(TEST);
    }


    /**The purpose of this routine is to verify that 
       a given polygon is an A-renorm tile.  technically,
       the routine verifies that the tile is contained
       in an A-renorm tile.  This suffices for our
       purposes.**/

    public static int[] verifyA(GoldenPolyWedge P) {

	//first we check that the tile survives in the backwards direction
	boolean STARTS_IN_A=false;
	int[] IA=VerifySupport.itineraryAB(P,true,false,false);
	if(IA==null) return(null);
	if(IA.length==0) STARTS_IN_A=true;
	boolean test=VerifyTile.verifyInverse(P,IA);
	if(test==false) return(null);

	//next we check that the tile survives in the forward direction
	int[] IA2=VerifySupport.itineraryAB(P,true,true,STARTS_IN_A);
	test=VerifyTile.verify(P,IA2);
	if(test==false) return(null);


	//finally we check if the final image of the tile lies in the A-set
	GoldenVector V=VerifySupport.getTotalMoveInverse(IA);
	int[] L=VerifySupport.getCharA(P);

	for(int i=0;i<P.count;++i) {
	    GoldenVector W=VerifySupport.theta(P.z[i]);
	    W=GoldenVector.plus(W,V);
	    W=VerifySupport.fundamentalDomain(W);  
	    boolean ins=false;
	    for(int j=-4;j<=4;j=j+4) {
		for(int k=-4;k<=4;k=k+4) {
		    for(int l=-4;l<=4;l=l+4) {
		      GoldenVector WW=GoldenVector.plus(W,new GoldenVector(j,0,k,0,l,0));
	              test=VerifySupport.insideA(WW,L);
		      if(test==true) ins=true;
		    }
		}
	    }
	    if(ins==false) return(null);
	}



	return(IA);
    }


    /**The purpose of this routine is to verify that 
       a given polygon is a B-renorm tile.  There are
       two routines, depending on the parity of the 
       characteristic. verifyB0 is exactly like the
       case of the A-band, except now we address the
       case when the tile lies in the B-renorm set.*/

    public static int[] verifyB(GoldenPolyWedge P,boolean reverse) {
	boolean direct=true;
	if(reverse==true) direct=false;

	//first we test that the tile survives in one direction
	boolean STARTS_IN_B=false;
	boolean test=true;
        int[] IB=VerifySupport.itineraryAB(P,false,reverse,false);
	if(reverse==false)    test=VerifyTile.verifyInverse(P,IB);
	if(reverse==true)     test=VerifyTile.verify(P,IB);
	if(IB.length==0) STARTS_IN_B=true;
        if(test==false) return(null);


	//now we test that the tile survives in the other direction
        int[] IB2=VerifySupport.itineraryAB(P,false,direct,STARTS_IN_B);
	if(direct==false)    test=VerifyTile.verifyInverse(P,IB2);
	if(direct==true)     test=VerifyTile.verify(P,IB2);
	if(IB.length==1) STARTS_IN_B=true;
        if(test==false) return(null);
        if(test==false) return(null);

	//now we check that the itinerary is correct and that
        // the final image indeed lies in the B-set
	GoldenVector V=new GoldenVector();
	if(reverse==false) V=VerifySupport.getTotalMoveInverse(IB);
	if(reverse==true)  V=VerifySupport.getTotalMove(IB);
	int L=VerifySupport.getCharB(P);

	for(int i=0;i<P.count;++i) {
	    GoldenVector W=VerifySupport.theta(P.z[i]);
	    W=GoldenVector.plus(W,V);
	    W=VerifySupport.fundamentalDomain(W);  
	    boolean ins=false;
	    for(int j=-4;j<=4;j=j+4) {
		for(int k=-4;k<=4;k=k+4) {
		    for(int l=-4;l<=4;l=l+4) {
		      GoldenVector WW=GoldenVector.plus(W,new GoldenVector(j,0,k,0,l,0));
	              test=VerifySupport.insideB(WW,L);
		      if(test==true) ins=true;
		    }
		}
	    }
	    if(ins==false) return(null);
	}
	return(IB);
    }

    /**This routine checks that an interior point of A renormalizes to
       the corresponding interior point of B.  Not currently used.*/

    public static boolean verifyAtoBX(GoldenPolyWedge A,GoldenPolyWedge B,int[] IA,int[] IB) {
 	int[] L=VerifySupport.getCharA(A);
	boolean reverse=false;
	if(L[0]%2==0) reverse=true;
	GoldenVector VA=VerifySupport.getTotalMoveInverse(IA);
	GoldenVector VB=new GoldenVector();
	if(reverse==false) VB=VerifySupport.getTotalMoveInverse(IB);
	if(reverse==true)  VB=VerifySupport.getTotalMove(IB);
	GoldenComplex zA=A.cheapInterior();
	GoldenComplex zB=B.cheapInterior();
	GoldenVector WA=VerifySupport.theta(zA);
	GoldenVector WB=VerifySupport.theta(zB);
	WA=VerifySupport.fundamentalDomain(GoldenVector.plus(WA,VA));
	WB=VerifySupport.fundamentalDomain(GoldenVector.plus(WB,VB));
	GoldenVector XB=VerifySupport.mapAtoB(L,WA);
	XB=GoldenVector.minus(XB,WB);
	if(XB.isZero()==false) return(false);
	return(true);
    }


    public static boolean verifyAtoB(GoldenPolyWedge A,GoldenPolyWedge B,int[] IA,int[] IB) {
 	int[] L=VerifySupport.getCharA(A);
	boolean reverse=false;
	if(L[0]%2==0) reverse=true;
	GoldenVector VA=VerifySupport.getTotalMoveInverse(IA);
	GoldenVector VB=new GoldenVector();
	if(reverse==false) VB=VerifySupport.getTotalMoveInverse(IB);
	if(reverse==true)  VB=VerifySupport.getTotalMove(IB);

	GoldenPolyhedron PA=new GoldenPolyhedron();
	PA.count=A.count;
	for(int i=0;i<A.count;++i) {
              PA.V[i]=VerifySupport.theta(A.z[i]);
	      PA.V[i]=GoldenVector.plus(PA.V[i],VA);  
	      PA.V[i]=VerifySupport.fundamentalDomain(PA.V[i]);	
	      PA.V[i]=translateToA(L,PA.V[i]);
              PA.V[i]=VerifySupport.mapAtoB(L,PA.V[i]);
	}

	GoldenPolyhedron PB=new GoldenPolyhedron();
	PB.count=B.count;
	for(int i=0;i<B.count;++i) {
              PB.V[i]=VerifySupport.theta(B.z[i]);
	      PB.V[i]=GoldenVector.plus(PB.V[i],VB);
              PB.V[i]=VerifySupport.fundamentalDomain(PB.V[i]); 
              PB.V[i]=translateToB(L[1],PB.V[i]);
	}

	boolean test=verifyMatch(PA,PB);
	return(test);
    }



    public static boolean verifyMatch(GoldenPolyhedron P1,GoldenPolyhedron P2) {
	for(int i=0;i<P1.count;++i) {
	    boolean test=verifyMatch(P1.V[i],P2);
	    if(test==false) return(false);
	}
	return(true);
    }

    public static boolean verifyMatch(GoldenVector V1,GoldenPolyhedron P) {
	for(int i=0;i<P.count;++i) {
	    if(GoldenVector.equals(V1,P.V[i])==true) return(true);
	}
	return(false);
    }



    /**This is only applied V lies in A modulo (2Z)^3**/

    public static GoldenVector translateToA(int[] L,GoldenVector V) {
           for(int j=-4;j<=4;j=j+4) {
		for(int k=-4;k<=4;k=k+4) {
		    for(int l=-4;l<=4;l=l+4) {
		      GoldenVector W=GoldenVector.plus(V,new GoldenVector(j,0,k,0,l,0));
	              boolean test=VerifySupport.insideA(W,L);
		      if(test==true) return(W);
		    }
		}
	   }  
	   return(null);
    }


    public static GoldenVector translateToB(int L,GoldenVector V) {
           for(int j=-4;j<=4;j=j+4) {
		for(int k=-4;k<=4;k=k+4) {
		    for(int l=-4;l<=4;l=l+4) {
		      GoldenVector W=GoldenVector.plus(V,new GoldenVector(j,0,k,0,l,0));
	              boolean test=VerifySupport.insideB(W,L);
		      if(test==true) return(W);
		    }
		}
	   }
	   System.out.println("B bad");
	   V.print();
	   Vector VV=V.toVector();
	   VV.scale(.5);
	   VV.print();
	   return(null);
    }







}
