import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;
import java.io.*;


public class VerifyRenorm3D  {

    /**This class has the routines that help in the proof of 
       the renormalization theorem.**/


    /**This routines verify that the given itinerary works for
       the whole polyhedron, by checking the vertices.  We use
       these routines in the proof of the renormalization theorem.**/

    public static boolean verifyWhole(GoldenPolyhedron P,int[] I,boolean iso) {
	for(int i=0;i<P.count;++i) {
	    GoldenVector W=P.V[i];   
            W=W.scale(new GoldenReal(2,0));
	    boolean test=false;
	    if(iso==true) test=VerifyTile.testFeasible(W,I);
	    if(iso==false) test=VerifyTile.testFeasibleInverse(W,I);
	    if(test==false) return(false);
	}
	return(true);
    }

    public static boolean verifyWholeCheap(GoldenPolyhedron P,int[] I,boolean iso) {
	GoldenVector W=P.cheapInterior();
        W=W.scale(new GoldenReal(2,0));
	boolean test=false;
	if(iso==true) test=VerifyTile.testFeasible(W,I);
	if(iso==false) test=VerifyTile.testFeasibleInverse(W,I);
	if(test==false) return(false);
	return(true);
    }


    /**This routine checks if the renormalization map R carries P to Q.**/
    public static boolean verifyMatch(int LA,int LB,GoldenPolyhedron P,GoldenPolyhedron Q) {
	GoldenVector V1=P.cheapInterior();
	GoldenVector V2=Q.cheapInterior();
	V1=V1.scale(new GoldenReal(2,0));
	V2=V2.scale(new GoldenReal(2,0));
	V1=VerifySupport.fundamentalDomain(V1);
	V2=VerifySupport.fundamentalDomain(V2);
	int[] L={LA,LB};
	GoldenVector V3=VerifySupport.mapAtoB(L,V1);
	boolean test=GoldenVector.equals(V2,V3);
	return(test);
    }


    /**This routine checks that the PE dynamics, for the exact specified
       number of iterates, carries the one polyhedron  to the other.  It
       is assumed that the itinerary for the polyhedron has already been
       verified.**/

    public static  boolean verifySameOrbit(GoldenPolyhedron P1,GoldenPolyhedron P2,int iterates) {
	int[] I=VerifySupport.getItinerary(P1,iterates);
	boolean test=verifyWholeCheap(P1,I,true);
	if(test==false) return(false);
	GoldenVector V=VerifySupport.getTotalMoveRaw(I);
	GoldenPolyhedron P3=P1.translate(V);
	GoldenPolyhedron Q2=VerifySupport.scale2(P2);
	GoldenPolyhedron Q3=VerifySupport.scale2(P3);
	Q2=VerifySupport.fundamentalDomain(Q2);
	Q3=VerifySupport.fundamentalDomain(Q3);
	for(int i=0;i<Q2.count;++i) {
	    test=GoldenVector.equals(Q2.V[i],Q3.V[i]);
	    if(test==false) return(false);
	}
	return(true);
    }



}

