import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class ControlCanvas extends ScaleCanvas implements MouseListener,MouseMotionListener {
    Manager M;
    SelectColor CS;
    Lever SHADOW,RING,RAISE,FIT,HIDE,SPEED,MOUSE;
    ListenSquare BG,BASE,SHA,OUT,RESET,MOVE,STOP,DEMO,BEST,ASK;
    ListenSquare[] DOC=new ListenSquare[6];
    SelectInteger NUM,RAN;
    PolyFlip DRIVER;
    Point JX;
    RandomMove RM;
    Greedy GR;
    String MESSAGE,MESSAGE2;
    int COUNT;

     public ControlCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 setLevers();
	 setGameControls();
	 setColorControls();
	 setRemoteMover();
	 setDocumentation();
     }

    /**Control Panel Setup*/
    public void setLevers() {
         SHADOW=new Lever(375,22,2,5);
	 RING=new Lever(190,22,0,10);
	 RAISE=new Lever(480,22,0,2);
	 FIT=new Lever(535,22,0,3);
	 MOUSE=new Lever(170,188,1,3);
	 HIDE=new Lever(5,180,0,2);
    }

    public void setGameControls() {
	 RAN=new SelectInteger(5,60,48,25,4,1,8,1);
	 SPEED=new Lever(5,130,4,9);
	 DEMO=new ListenSquare(100,220,50,20);
	 ASK=new ListenSquare(5,220,40,20);
	 BEST=new ListenSquare(50,220,45,20);
	 MOVE=new ListenSquare(100,60,50,20);
	 STOP=new ListenSquare(100,33,50,20);
	 RESET=new ListenSquare(100,5,50,20);
	 NUM=new SelectInteger(5,5,48,25,5,5,20,1);
	 RM=new RandomMove();
	 GR=new Greedy();
	 MESSAGE="";
	 MESSAGE2="";
    }

    public void setDocumentation() {
	 DOC[0]=new ListenSquare(160,45,255,80);
	 DOC[1]=new ListenSquare(160,65,85,60);
	 DOC[2]=new ListenSquare(245,65,85,60);
	 DOC[3]=new ListenSquare(330,65,85,60);
    }

    public void setColorControls() {
	 CS=new SelectColor(M,160,249);
	 BG=new ListenSquare(577,277,22,22);
	 BASE=new ListenSquare(577,247,22,22);
	 SHA=new ListenSquare(415,247,22,22);;
	 OUT=new ListenSquare(415,277,22,22);
    }

    public void setRemoteMover() {
         DRIVER=PolyFlip.basic(NUM.val);
	 DRIVER.z=new Complex(506,150);
	 DRIVER.r2=80;
    }


    /**Rendering methods*/

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      drawTitle(g);
      drawControls(g);
      drawRemoteControl(g);
   }

    public void drawBG(Graphics2D g) {
      g.setColor(new Color(0,0,230));
      g.fillRect(0,0,getWidth(),getHeight()); 
      g.setColor(new Color(0,120,0));
      g.fillRect(160,0,getWidth()-160,45);
      g.setColor(Color.white);
      g.drawRect(160,0,getWidth()-160,45);
      g.setColor(new Color(120,0,0));
      g.fillRect(160,167,255,82);
      g.setColor(Color.white);
      g.drawRect(160,167,255,82);
      g.setColor(new Color(128,128,128));
      g.fillRect(414,245,185,54);
      g.setColor(Color.white);
      g.drawRect(414,245,185,54);
      g.setColor(Color.white);
      g.drawRect(0,0,getWidth()-1,getHeight()-1);
    }

    public void drawTitle(Graphics2D g) {
      g.setColor(new Color(0,120,160));
      g.fillRect(160,125,255,42);
      g.setColor(Color.white);
      g.drawRect(160,125,255,42);
      g.setFont(new Font("Helvetica",Font.PLAIN,38));
      g.setColor(Color.white);
      g.drawString("LUCY & LILY",175,160);
    }

    public void drawRemoteControl(Graphics2D g) {
	g.setColor(M.P.BG);
	g.fillRect(414,45,185,204);
	g.setColor(Color.white);
	g.drawRect(414,45,185,204);
	Color C=M.P.BG;
	if(C.getRed()+C.getGreen()+C.getBlue()>600) g.setColor(Color.black);
        g.setFont(new Font("Helvetica",Font.PLAIN,13));
	g.drawString("click to move pieces remotely",420,60);
	DRIVER.renderBasic(g,M.P.OUTLINE);
    }
    
    public void drawControls(Graphics2D g) { 
	drawGameControls(g);
	drawMouseControls(g);
	drawMoveControls(g);
	drawDocumentControls(g);
	drawLevers(g);
	drawColorControls(g);
    }

    public void drawGameControls(Graphics2D g) {
        g.setFont(new Font("Helvetica",Font.PLAIN,14));
	Color COL1=new Color(240,0,0); 
	RESET.render(g,COL1); 
	NUM.render(g,COL1,Color.white,Color.white); 
        g.setFont(new Font("Helvetica",Font.PLAIN,14));
	g.setColor(Color.white);
	g.drawString("# sides",5,44);
	g.drawString("reset",105,20);
    }


    public void drawColorControls(Graphics2D g) {
        CS.render(g);
	Color COL=Color.blue;
	BG.render(g,M.P.BG); 
	BASE.render(g,M.P.BASE);  
	SHA.render(g,M.P.SHADOW);   
	OUT.render(g,M.P.OUTLINE); 
        g.setFont(new Font("Helvetica",Font.PLAIN,14));
	g.drawString("bg",555,291);
	g.drawString("home",533,264);
	g.drawString("shadow",441,264);
	g.drawString("outline",441,291);
    }

    public void drawLevers(Graphics2D g) {
	Color COL0=new Color(0,80,0);
        g.setFont(new Font("Helvetica",Font.PLAIN,15));
	HIDE.render2(g,"show");
	SHADOW.render(g,"shadows",COL0);
	FIT.render(g,"auto fit",COL0);
	RING.render(g,"fat <---- drawing ---->thin",COL0);
	RAISE.render(g,"raise",COL0);
    }

    public void drawMoveControls(Graphics2D g) {
	Color COL2=new Color(0,160,0);
	SPEED.render(g,"fast <-- motion --> slow",COL2); 
	MOVE.render(g,COL2);
	DEMO.render(g,new Color(50,100,255));
	BEST.render(g,new Color(50,100,255));
	ASK.render(g,new Color(50,100,255));

	RAN.render2(g,COL2,Color.white,Color.white);
        g.setFont(new Font("Helvetica",Font.PLAIN,14));
	g.setColor(Color.white);
	g.drawString("# random",5,100);
	g.drawString("start",105,75);
	g.drawString("demo",105,235);
	g.drawString("best",55,235);
	g.drawString("ask",10,235);
	Color COL3=new Color(180,0,0);
	if(RM.HALT==false) STOP.render(g,COL3);
	if(GR.HALT==false) STOP.render(g,COL3);
	if(RM.HALT==false) g.drawString("stop",105,48);
	if(GR.HALT==false) g.drawString("stop",105,48);
        g.setFont(new Font("Helvetica",Font.PLAIN,17));
	g.setColor(Color.yellow);
	g.drawString(MESSAGE,5,270);
	MESSAGE2="move total: "+toString(COUNT);
	g.drawString(MESSAGE2,5,295);
    }

    public void drawDocumentControls(Graphics2D g) {
	DOC[0].render(g,new Color(80,0,150));
	for(int i=1;i<4;++i) DOC[i].render(g,new Color(50,0,100));
        g.setFont(new Font("Helvetica",Font.PLAIN,14));
	g.setColor(Color.white);
	g.drawString("press buttons for explanatory text.",180,60);
        g.setFont(new Font("Helvetica",Font.PLAIN,18));
	g.drawString("controls",258,100);
	g.drawString("math",350,100);
	g.drawString("intro",185,100);
    }

    public void drawMouseControls(Graphics2D g) {
	MOUSE.render(g,"mouse",new Color(110,0,0));
        g.setFont(new Font("Helvetica",Font.PLAIN,14));

	g.setColor(new Color(190,0,0));
	g.fillRect(232,168,193,80);
	g.setColor(Color.white);
	g.drawRect(232,167,193,82);
        g.setFont(new Font("Helvetica",Font.PLAIN,18));
	g.drawString("keyboard shortcuts",242,184);
        g.setFont(new Font("Helvetica",Font.PLAIN,14));

	g.setColor(new Color(80,0,0));
	if(MOUSE.val==0) {
	    g.fillRect(236,196,17,19);
	    g.fillRect(236,226,17,19);
	    g.fillRect(354,196,17,19);
	    g.fillRect(354,226,17,19);
	}

	if(MOUSE.val==1) {
	    g.fillRect(256,196,17,19);
	    g.fillRect(256,226,17,19);
	    g.fillRect(370,196,17,19);
	    g.fillRect(370,226,17,19);
	}

	if(MOUSE.val==2) {
	    g.fillRect(276,196,17,19);
	    g.fillRect(276,226,17,19);
	    g.fillRect(390,196,17,19);
	    g.fillRect(390,226,17,19);
	}

	g.setColor(Color.white);
	if(MOUSE.val==0) {
	    g.drawRect(236,196,17,19);
	    g.drawRect(236,226,17,19);
	    g.drawRect(354,196,17,19);
	    g.drawRect(354,226,17,19);
	}

	if(MOUSE.val==1) {
	    g.drawRect(256,196,17,19);
	    g.drawRect(256,226,17,19);
	    g.drawRect(370,196,17,19);
	    g.drawRect(370,226,17,19);
	}

	if(MOUSE.val==2) {
	    g.drawRect(276,196,17,19);
	    g.drawRect(276,226,17,19);
	    g.drawRect(390,196,17,19);
	    g.drawRect(390,226,17,19);
	}

	if(MOUSE.val==0) g.drawString("zoom in",169,240);
	if(MOUSE.val==1) g.drawString("move",169,240);
	if(MOUSE.val==2) g.drawString("zoom out",167,240);

	g.drawString("q   w   e",240,210);
	g.drawString("z   x    c",240,240);
	g.drawString("i   o   p",360,210);
	g.drawString(",   .    /",360,240);
    }


    public void setStyle(Point X) {
	int s1=RING.val;
	RING.process(X);
	int s2=RING.val;
	if(s1!=s2) M.P.X=M.P.X.changeStyle(RING.val);
    }

    public void makeRandomMoves(Point X) {
	RAN.modify(X);
    }

    public void setGame(Point X) {
	int s1=NUM.val;
	NUM.modify(X);
	int s2=NUM.val;
	if(s1!=s2) {
             M.P.setGame(s2,RING.val,SHADOW.val);
	     setRemoteMover();
             HIDE=new Lever(5,180,0,M.P.X.TOTAL);
	     COUNT=0;
	}
	if(RESET.inside(X)==1) {
            M.P.setGame(s1,RING.val,SHADOW.val);
	    COUNT=0;
	}
    }

    public void makeMove(Point X) {
	Complex z=new Complex(X.x,X.y);
	int k=DRIVER.locatePoint(z);
	if(k!=-1) {
	    M.P.X.flip(k);
	    M.P.X.state(k);
	    ++COUNT;
	}
    }

    public static String toString(int k) {
	Integer kk=new Integer(k);
	return kk.toString();
    }



    public void changeState(Point X) {
	Complex z=new Complex(X.x,X.y);
	int k=DRIVER.locatePoint(z);
	if(k!=-1) {
	    M.P.X.state(k);
	}
    }

    public void getInfo(Point X) {
	if(DOC[1].inside(X)==1) {
	    PopupDocumentCanvas PD=new PopupDocumentCanvas();
	    PD.D.M=this.M;
	    M.D=PD.D;
	}
	if(DOC[2].inside(X)==1) {
	    PopupDocumentCanvas PD=new PopupDocumentCanvas();
	    PD.D.M=this.M;
	    M.D=PD.D;  
            DocumentControl.main(M.D);
	}

	if(DOC[3].inside(X)==1) {
	    PopupDocumentCanvas PD=new PopupDocumentCanvas();
	    PD.D.M=this.M;
	    M.D=PD.D;  
            DocumentMath.main(M.D);
	}
    }
    public void changeColors(Point X) {
	if(BG.inside(X)==1) M.P.BG=CS.C;
	if(BASE.inside(X)==1) M.P.BASE=CS.C;
	if(SHA.inside(X)==1) M.P.SHADOW=CS.C;
	if(OUT.inside(X)==1) M.P.OUTLINE=CS.C;
    }

    public void ask() {
	int k=Greedy.computeWin(M.P.X);
	String S=toString(k);
	MESSAGE="win in "+S;
	COUNT=0;
    }

    public void doGo() {
	if(RM.HALT==false) return;
	if(GR.HALT==false) return;
	COUNT=0;
	FIT.val=1;
	RM=new RandomMove(M);
	new Thread(RM).start();
    }
    public void doGreedy() {
	if(RM.HALT==false) return;
	if(GR.HALT==false) return;
	GR=new Greedy(M);
	new Thread(GR).start();
    }

    public void doBest() {
	if(Greedy.norm(M.P.X)<.0001) return;
	int k=Greedy.bestIndex(M.P.X);
	++COUNT;
	M.P.X.flip(k);
    }
    public void showBest() {
	if(Greedy.norm(M.P.X)<.0001) return;
	int k=Greedy.bestIndex(M.P.X);
	M.P.X.state(k);
    }
    
    public void mouseClicked(MouseEvent e) {
        CS.process(e); 
        MouseData J=MouseData.process(e);
	SHADOW.process(J.X);
	SPEED.process(J.X);
	MOUSE.process(J.X);
	HIDE.process2(J.X);
	M.P.X.SHADOW=SHADOW.val;
	RAISE.process(J.X);
	if(BEST.inside(J.X)==1) {doBest();showBest();}
	FIT.process(J.X);
	setStyle(J.X);
	changeColors(J.X);
	setGame(J.X);
	makeMove(J.X);
	makeRandomMoves(J.X);
	if(ASK.inside(J.X)==1) ask();
	if(MOVE.inside(J.X)==1) doGo();
	if(DEMO.inside(J.X)==1) doGreedy();
	if(STOP.inside(J.X)==1) RM.HALT=true;
	if(STOP.inside(J.X)==1) GR.HALT=true;
	getInfo(J.X);
	repaint();
	M.P.repaint();
    }

    public void mousePressed(MouseEvent e) {}
     public void mouseReleased(MouseEvent e) {
	 MouseData J=MouseData.process(e);
         if(BEST.inside(J.X)==1) showBest();
     }

     public void mouseEntered(MouseEvent e) {
	 requestFocus();
     }
     public void mouseExited(MouseEvent e) {}   
     public void mouseMoved(MouseEvent e) {
	 MouseData J=MouseData.process(e);
	   changeState(J.X);
	   JX=J.X;
	   if(BEST.inside(J.X)==1) showBest();
    	   repaint();
	   M.P.repaint();
     }
     public void mouseDragged(MouseEvent e) { 
        CS.process(e); 
	repaint();
     } 

}

