import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**Documentation file*/


public class DocumentControl {

    public static void sendTo(DocumentCanvas D,String S) {
	try{
          D.setExplain(S);
          D.repaint();   
	  D.Y0=0;
          D.Y1=0;
	}
	catch(Exception e) {}
    }


    public static void main(DocumentCanvas D) {


	String S="LUCY AND LILY: CONTROLS\n\nThere are a variety of options on the control panel for making the game easier to play.  This text will take you through the features of the control panel and explain them one at a time.  You can also figure out what most of the features do just by experimentation.  It almost goes without saying that you should try out a given feature just after reading about it here.";

	S=S+"\n\nRENDERING FEATURES\n\nThe green boxes at the top give you options for how the polygons in the game are rendered.\n\ndrawing: This controls whether the polygons are drawn solidly or as annular rings.   When the polygons are drawn as thin annular rings, and several are on top of each other, they don't obscure each other as much.\n\nshadows: This controls whether or not a polygon casts a shadow indicating where the currently selected piece will move it.  The different boxes control the intensity of the shadow. \n\nraise: When turned on, this feature automatically brings to the top the current polygon you are touching. This is only relevant when some polygons overlap. It becomes more important when you are playing a game with many polygons, because then there are more overlaps.\n\nauto fit: This feature controls how the pieces are scaled in the window.  I'll say more about this next.";

	S=S+"\n\nAUTO FIT\n\nWhen this feature is turned on, the game is automatically rescaled so that all pieces fit on the screen.  There are two flavors of this feature.  If you select the middle auto fit option, the scaling takes into account all polygons, whether or not they are hidden from view.  If you use the right auto fit button, the scaling only takes into account the polygons which are shown.   You use the SHOW control buttons to control which polygons are hidden and which are shown.\n\nIt is neat to start a new game with a large number of moves and a large number of polygons when you have the AUTO FIT options on.  You will get to see a nice animation.";

	S=S+"\n\nMOUSE\n\nYou can also manipulate the scaling of the playing board using mouse clicks.  The MOUSE controls.  When the MOUSE button is on the left, a click on the playing board will cause it to zoom in, centered at where you have clicked.  When the MOUSe button is on the right, a click on the playing board will cause it to zoom out, centered at where you have clicked.  When the MOUSE button is on the middle, a click on the playing board pieces will move them.";


S=S+"\n\nDRAGGING\n\nAssuming that AUTO FIT is turned off, there is another way to move things around the picture window. Regardless of the MOUSE mode, you can recenter the playing pieces on the picture window by dragging the MOUSE over the window.  You have to try this to see how it works.  The dragging feature does not do anything when you have AUTO FIT turned on.";

	S=S+"\n\nKEYBOARD SHORTCUTS\n\nYou simulate the mouse click action using keyboard shortcuts, as indicated on the control board.  For instance, if you press the key x on the playing board it has the same effect as a click with the MOUSE button set to the left.  The display on the control panel to the right of the MOUSE boxes indicates the correspondence between key commands and mouse moves.\n\nThe keyboard shortcuts are a bit subtle:  Whenever you newly enter the playing board, you have to click on it in order to activate the keyboard commands.\n\nI think that the most efficient way to play the game (without using AUTO FIT) is setting the MOUSE button to the middle option and then using the keyboard shortcuts to zoom in and out.";

	S=S+"\n\nREMOTE CONTROL\n\nYou can also move the pieces by clicking on the polygon shown on the control panel.  The polygon on the control panel is color coded to match the pieces.  This feature is useful if you are playing a large game and the many pieces are widely scattered.  In order to see everything at once, the pieces will be quite small and it will be hard to click on them directly.  I think that this feature is best used with the SHADOWS turned on, so that you can see in advance where a click on the remote control is going to move the pieces.";

	S=S+"\n\nRANDOM MOVES\n\nAs mentioned in the introduction, a game is played by first clicking the RESET button and then clicking the MOVES button.  There are several controls associated to the MOVE button.\n\n# random: you can select the number of random moves to be made.  You can select a power of 2 up to 256.  If you want to play a game starting with 512 random moves, set the value to 256 and press the MOVES button twice.  After pressing it the first time you will have to wait until the set of moves has been completed.\n\nmotion: The computer shows you which random moves are being made, and you can either see them slowly or quickly.  The boxes to the left give faster moves and the voxes to the right give slower moves.\n\nstop: This button only appears during the moving. If you initiate a long game you might lose patience watching the computer make the random moves, or you might see some particularly nice stopping point along the way. If you press the stop button you can stop the random moves.";

	S=S+"\n\nGREEDY\n\nI think that the best way to play is to use the greedy algorithm. The greedy algorithm makes the move which minimizes the norm of the game. The norm of the game is defined to be\n\nthe square root of\nthe sum of\nthe square norms of\nthe polygon centers.\n\nIn other words, if you string out all the coordinates of the polygon centers you get a vector in some high dimensional Euclidean space, and the norm of the game is the Euclidean norm of this vector.If you press the BEST button you can make the greedy move. If you just hover over the BEST button and have the SHADOW feature on, you can see what the greedy move would be. If you press the DEMO button you can see the sequence of best moves made until the game is won.  If you press the ASK button you can see how many moves it would take the computer to win using the greedy algorithm.";

	S=S+"\n\nSHOW\n\nThese boxes allow you to show and hide various of the polygons on the playing board. There are the same number of boxes as there are pieces.  Each box controls a different piece.  When a given box is orange, the corresponding piece is shown. When a given box is blue, the corresponding piece is hidden.";

	S=S+"\n\nCOLORS\n\nYou can use the color selector to choose colors.  After you have chosen a color, you have the option of changing the following features\n\npiece outline\npiece shadow\nhome base color\nbackground color\n\nClick on the buttons at the bottom right to make these color changes.";

	S=S+"\n\nRESIZING\n\nThis is a feature of the playing board rather than the control panel, but let me mention it here. You can resize the picture window in the usual way: dragging it from a corner.";
	
	sendTo(D,S);
    }


}