import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**Documentation file*/


public class DocumentIntro {

    public DocumentIntro() {}


    public static void setup(DocumentCanvas D) {
    
	String S="LUCY AND LILY: INTRO";

	S=S+"\n\nThe first 3 things you should know are:\n\n1. you can move this text up and down by dragging the mouse on the window.\n\n2. You can change the font size for this text.\n\n2. You can resize this window.\n\nTry doing each of these things now.  Don't make this text window so big that it obscures the other two windows of the program, because this text will refer to those other windows. OK, now that you have arranged this window for your convenience, you are ready to read about the game.";

	S=S+"\n\nGENERAL CONCEPT\n\nThis program is an update of a simpler version which I wrote in 2000. The basic idea of the game is that you have finitely many polygons in the plane and you can move these polygons by reflecting them across their edges. Try clicking the mouse on the polygons shown in the picture window to see how they move. You can also move the pieces using the remote controller (a copy of one of the pieces) that is on the control panel.";

	S=S+"\n\nIn the classic case of the game there are 2 pentagons.  You can change the number of sides to the polygons using the red arrow keys. For a given number of sides, the number of polygons is calculated in a way that is discussed in the math part of the documentation. In all cases, the polygons are linked together, so that a move on one of the pieces entails a move on all the others.  The pieces are color-coded to indicate how they are linked.  The pieces cast shadows (a feature you can turn off if you like) which indicate how they will move if clicked.";


	S=S+"\n\nPLAYING A GAME\n\nStart a new game by pressing on the START button. This causes the computer to randomly move the pieces away from the home base.  The goal of the game is to return the pieces to the home base.  It is a general feature of the game that the pieces will all return to the home base simultaneously.  Once the pieces stop moving, the computer will calculate the number of moves it takes to win using a reliable strategy.  Your goal is to win in the same number (or fewer) moves.  Alternately, the goal is just to win in as few moves as possible.  At any time during the game you can press the ask button and the computer will tell you how many moves it takes to win.  When you do this, it will reset your move total to 0.  So, in other words, pressing the ask button sets up a new game for you.";

	S=S+"\n\nSince the pieces can move off the playing board, the matter of being able to rescale and recenter the playing board is important.  The program gives you tools for rescaling and recentering the board, which you can read about in the documentation on the control panel.  In brief, you recenter by dragging the mouse over the playing board, and you rescale using mouse clicks, as controlled by the dark red part of the control panel, or key presses, as indicated on the light red part of the control panel.\n\nTo simplify things, you have the option of automatically scaling the playing window so that all the pieces fit. When you press the START button, the computer automatically turns on this feature, and then turns it off once the pieces have stopped moving.  In general, the AUTO FIT feature is controlled by the green buttons on the top left part of the control panel.";

S=S+"\n\nYou can use the SHOW controls at bottom left to hide some of the polygons.  In the classic case of the game, you hide one of the pentagons and try to get both back just by looking at one of them. You will see that the game is much harder this way.  Try using the SHOW feature.  You should first click a few times on the polygons so that several of them are visible at the same time.  Then you can see that different SHOW buttons hide different polygons.";

S=S+"\n\nTHE MATH\n\nThe underlying idea is that if you string out the coordinates of all the centers of all the polygons, they form a lattice in a high dimensional space, and really what you are doing is navigating around this lattice.  If you have hidden some of the polygons, you are trying to navigate through this lattice just by knowing some lower dimensional projection, which is quite difficult. This is akin to trying to thread a needle with one eye closed.  You can read more about the mathemematics behind the game by clicking on the MATH text button.";

S=S+"\n\nCONTROLS\n\nThe control panel gives you various ways of making the game more convenient to play. You can read all about the control panel by clicking on the purple CONTROL PANEL button.  This will bring up text like this which explains the control panel.";

        D.setExplain(S);
        D.repaint();   
	D.Y0=0;
        D.Y1=0;
    }
}

