import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**Documentation file*/


public class DocumentMath {

    public static void sendTo(DocumentCanvas D,String S) {
	try{
          D.setExplain(S);
          D.repaint();   
	  D.Y0=0;
          D.Y1=0;
	}
	catch(Exception e) {}
    }


    public static void main(DocumentCanvas D) {

	String S="LUCY AND LILY: MATH";

	S=S+"\n\nThe explanation you will read below assumes that you know something about Galois theory.  You don't need to know that much about Galois theory to appreciate the game but an explanation using this framework makes things more transparent.  If this explanation doesn't satisfy you, then you should read the article I wrote about the game:\n\nRichard Evan Schwartz\nLucy And Lily: A Game of Geometry and Number Theory\nAmerican Mathematical Monthly,\nVolume 101.9, pp 13-20, Jan 2002.\n\nThis is an elementary account restricted to the case of pentagons.  If you understand the account in the article it shouldn't be too hard to see how it generalizes to polygons with more sides.";

	S=S+"\n\nGALOIS EMBEDDINGS:\n\nAn algebraic number ring is the ring of algebraic integers in a finite field extension of Q (the rationals).  The classic way to get one of these things is to take the field generated by Q and the roots of some integer polynomial.  Every element in the field satisfies some integer polynomial and the algebraic integers are the ones which satisfy an integer polynomial whose leading coefficient (of the highest degree term) is 1. We always have the Galois group of the field. This is the group of field automorphisms.  The Galois group permutes the roots of any integer polynomial and therefore preserves the ring of algebraic integers.";

	S=S+"\n\nGiven an algebraic number ring R, we form the Galois embedding of R into Euclidean space, as follows: The embedding sends the element x to the n-tuple\n\n(g_1(x),...,g_n(x)),\n\n where g_1,...,g_n are the elements of the Galois group.  The classic theorem is that the image of R under the Galois embedding forms a Euclidean lattice. Technically, you don't use the whole Galois group.  Some of the Galois automorphisms come in conjugate pairs and you only use one from each pair.";

	S=S+"\n\nThe game illustrates this phenomenon in case R is the ring of integers in the Nth cyclotomic number field, for N=5,...,20. The Nth cyclotomic field is the splitting field for the polynomial x^N-1.  More simply, this is the field generated by Q and the Nth roots of unity.  The Galois group of the Nth cyclotomic field has order \u03D5(N), and the elements all come in conjugate pairs.  So, the Galois embedding gives a lattice in a complex vector space of dimension \u03D5(N)/2, which is the same for our purposes as a real vector space of dimension \u03D5(N).   Here \u03D5(N) is the number of integers from 1 to N which are relatively prime to N.";

S=S+"\n\nThe N-gons in the game are linked together in such a way that their centers are precisely the (complex valued) coordinates of the Galois embedding.  You can see this by looking carefully at the colors and remembering that each Galois group element has the action x->x^n on the Nth roots of unity, for some choice of n relatively prime to N.  For instance, in the case N=5 we use the two elements x->x and x->x^2 for our Galois embedding.";

S=S+"\n\nSTRATEGY: The following greedy algorithm works great, at least for N up to 20. (I guess it would work for all N but I didn't try to prove the general statement.) The greedy algorithm makes the move which minimizes the norm of the game. The norm of the game is defined to be\n\nthe square root of\nthe sum of\nthe square norms of\nthe polygon centers.\n\nIn other words, the norm of the game is the Euclidean norm of the image under the Galois embedding. Press the DEMO button to watch this strategy in action.";

	sendTo(D,S);
    }


}