import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;


public class MultiPoly {
    PolyFlip[] P=new PolyFlip[50];
    int TOTAL;
    int SHADOW;
    int[] index=new int[50];

    public MultiPoly() {}

    public MultiPoly(PolyFlip[] A) {
	this.TOTAL=A.length;
	this.SHADOW=0;
	for(int i=0;i<A.length;++i) P[i]=new PolyFlip(A[i]);
    }

    public MultiPoly(MultiPoly X) {
	this.TOTAL=X.TOTAL;
	for(int i=0;i<X.TOTAL;++i) P[i]=new PolyFlip(X.P[i]);
    }

	 

    public MultiPoly(int N,int style) {
	Color[] COL=new Color[N];
	for(int i=0;i<N;++i) COL[i]=ColorGenerator.COL(i);
	double r=1.0*style/10;
	int count=0;
	for(int i=1;i<=N/2;++i) {
	    int test=PolyFlip.inverse(i,N);
	    if(test!=0) {
		P[count]=new PolyFlip(N,i,0,0,new Complex(0,0),r,1,COL);
		index[i]=count;
		++count;
	    }
	}
	TOTAL=count;
	SHADOW=0;
    }

    public MultiPoly changeStyle(int style) {
	MultiPoly Y=new MultiPoly();
	Y.TOTAL=this.TOTAL;
	Y.SHADOW=this.SHADOW;
	for(int i=0;i<this.TOTAL;++i) {
             Y.P[i]=new PolyFlip(P[i],style);
	     Y.index[i]=this.index[i];
	}
	return Y;
    }

    /**Brings the ith one to the front*/

    public void raise(int j) {
	MultiPoly Y=new MultiPoly();
	Y.P[0]=P[j];
	int count=1;
	for(int i=0;i<this.TOTAL;++i) {
	    if(i!=j) {
               Y.P[count]=new PolyFlip(P[i]);
	       ++count;
	    }
	}
	for(int i=0;i<TOTAL;++i) {
            P[i]=Y.P[i];
	}
    }


    public static int index(int m,int N) {
	int count=0;
	for(int i=1;i<m;++i) {
	    if(PolyFlip.inverse(i,N)!=0) ++count;
	}
	return count;
    }

    public void render(Graphics2D g,PictureCanvas X) {
	for(int i=TOTAL-1;i>=0;--i) {
	    int j=index(P[i].n,P[i].N);
	    int mask=X.M.C.HIDE.on[j];
            if(mask==1) P[i].render(g,X,SHADOW);
	}
    }

    public void flip(int k) {
	int q=firstIndex();
	 for(int i=0;i<TOTAL;++i) P[i]=P[q].remoteFlip(k,P[i]);
    }

    public void flip(int q,int k) {
	 for(int i=0;i<TOTAL;++i) P[i]=P[q].remoteFlip(k,P[i]);
    }

     public void state(int k) {
	 int q=firstIndex();
	 for(int i=0;i<TOTAL;++i) P[q].remoteState(k,P[i]);
     }


    public int firstIndex() {
	for(int i=0;i<TOTAL;++i) {
	    if(P[i].n==1) return i;
	}
	return -1;
    }

    public void flip(Complex Z) {
	boolean test=false;
	int count=0;
	while((test==false)&&(count<TOTAL)) {
	    test=tryFlip(count,Z);
	    ++count;
	}
    }

    public boolean tryFlip(int q,Complex Z) {
	int k=P[q].locatePoint(Z);
	if(k==-1) return false;
        P[q]=P[q].flip(k);
	for(int i=0;i<TOTAL;++i) {
	    if(i!=q) {
	      P[i]=P[q].remoteFlip(k,P[i]);
	    }
	}
	return true;
    }

    public void state(Complex Z) {
	boolean test=false;
	int count=0;
	while((test==false)&&(count<TOTAL)) {
	    test=tryState(count,Z);
	    ++count;
	}
    }

    public boolean tryState(int q,Complex Z) {
	int k=P[q].locatePoint(Z);
	if(k==-1) return false;
	for(int i=0;i<TOTAL;++i) {
	    if(i!=q) {
	      P[q].remoteState(k,P[i]);
	    }
	}
	return true;
    }

    public void raise(Complex Z) {
	for(int i=0;i<TOTAL;++i) {
	    int k=P[i].locatePoint(Z);
	    if(k!=-1) {
		raise(i);
		return;
	    }
	}
    }

    public Path2D.Double boundingBox() {
	double minx=0;
	double maxx=0;
	double miny=0;
	double maxy=0;
	for(int i=0;i<TOTAL;++i) {
	    if(minx>P[i].z.x) minx=P[i].z.x;
	    if(maxx<P[i].z.x) maxx=P[i].z.x;
	    if(miny>P[i].z.y) miny=P[i].z.y;
	    if(maxy<P[i].z.y) maxy=P[i].z.y;
	}
	Path2D.Double gp=new Path2D.Double();
	minx=minx-1.5;
	miny=miny-1.5;
	maxx=maxx+1.5;
	maxy=maxy+1.5;
	gp.moveTo(minx,miny);
	gp.lineTo(minx,maxy);
	gp.lineTo(maxx,maxy);
	gp.lineTo(maxx,miny);
	gp.closePath();
	return gp;
    }


    public Path2D.Double boundingBoxHide(Lever HIDE) {
	double minx=0;
	double maxx=0;
	double miny=0;
	double maxy=0;
	for(int i=0;i<TOTAL;++i) {
            int j=index[P[i].n];
	    int mask=HIDE.on[j];
            if(mask==1) {
	      if(minx>P[i].z.x) minx=P[i].z.x;
	      if(maxx<P[i].z.x) maxx=P[i].z.x;
	      if(miny>P[i].z.y) miny=P[i].z.y;
	      if(maxy<P[i].z.y) maxy=P[i].z.y;
	    }
	}
	Path2D.Double gp=new Path2D.Double();
	minx=minx-1.5;
	miny=miny-1.5;
	maxx=maxx+1.5;
	maxy=maxy+1.5;
	gp.moveTo(minx,miny);
	gp.lineTo(minx,maxy);
	gp.lineTo(maxx,maxy);
	gp.lineTo(maxx,miny);
	gp.closePath();
	return gp;
    }

}


    