import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class PictureCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener, KeyListener {
    Manager M;
    PolyFlip HOME;
    MultiPoly X;
    Complex SOURCE;
    Point JX;
    ListenSquare CONTROL;
    Color BG,BASE,OUTLINE,SHADOW;

     public PictureCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 addKeyListener(this);
	 setScales(300,300,100);
	 SOURCE=new Complex();
	 BG=Color.black;
	 BASE=new Color(100,100,100);
	 SHADOW=new Color(255,255,255);
	 OUTLINE=new Color(255,255,255);
	 setGame(5,0,0);
     }


    public void setGame(int N,int a,int b) {
	Color[] COL=new Color[N];
	for(int i=0;i<N;++i) COL[i]=new Color(0,0,0,0);
	HOME=new PolyFlip(N,1,0,0,new Complex(0,0),0,1,COL);
	X=new MultiPoly(N,a);
	X.SHADOW=b;
    }


   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
    
      drawBG(g);
      if(M.C.FIT.val==1) {
        Path2D.Double gp=X.boundingBox();
        A=preFit(gp,0,0,getWidth(),getHeight());
      }
      if(M.C.FIT.val==2) {
        Path2D.Double gp=X.boundingBoxHide(M.C.HIDE);
        A=preFit(gp,0,0,getWidth(),getHeight());
      }
      drawGame(g);
      drawFrame(g);
   }

    public void drawBG(Graphics2D g) {
	g.setColor(BG);
        g.fillRect(0,0,getWidth(),getHeight());

    }

    public void drawGame(Graphics2D g) {
	HOME.renderBase(g,this,BASE);
	X.render(g,this); 
    }


    public void drawFrame(Graphics2D g) {
	g.setColor(new Color(50,100,255));
	int x=getWidth();
	int y=getHeight();
	g.fillRect(0,0,4,y);
	g.fillRect(0,0,x,4);
	g.fillRect(x-4,0,4,y);
	g.fillRect(0,y-9,x,9);
    }

    public void mousePressed(MouseEvent e) { }

    public void mouseClicked(MouseEvent e) { 
	MouseData J=MouseData.process(e);
        if(M.C.MOUSE.val==0)  scaleUp(J.X,0);
        if(M.C.MOUSE.val==2)  scaleUp(J.X,1);

	if(M.C.MOUSE.val==1) {
            SOURCE=unTransform(J.X);
	    X.flip(SOURCE);
	    ++M.C.COUNT;
	    M.C.repaint();
	}
	repaint();
    }

    public void doMouseClick(int mode, Point JX) {
        if(mode==1)  scaleUp(JX,0);
        if(mode==3)  scaleUp(JX,1);
	if(mode==2) {
            SOURCE=unTransform(JX);
	    X.flip(SOURCE);
	    ++M.C.COUNT;
	}
	repaint();
	M.C.repaint();
    }

     public void mouseReleased(MouseEvent e) {	 
     }

     public void mouseEntered(MouseEvent e) {
	 requestFocus();
     }
     public void mouseExited(MouseEvent e) {}   

     public void mouseMoved(MouseEvent e) {
	MouseData J=MouseData.process(e);
	SOURCE=unTransform(J.X);
	JX=J.X;
	X.state(SOURCE);
	if(M.C.RAISE.val==0) X.raise(SOURCE);
	repaint();
     }   

     public void mouseDragged(MouseEvent e) {
	MouseData J=MouseData.process(e);
	double x=J.X.x-JX.x;
	double y=J.X.y-JX.y;
	double ux=A[0].getTranslateX();
        double uy=A[0].getTranslateY();	
        A[0]=AffineTransform.getTranslateInstance(ux+x,uy+y);
	JX=J.X;
	repaint();
     }


    public void keyTyped(KeyEvent e) {
	char ch=e.getKeyChar();
	int mode=0;
	if(ch=='z') mode=1;
	if(ch=='q') mode=1;
	if(ch=='i') mode=1;
	if(ch==',') mode=1;
	if(ch=='x') mode=2;
	if(ch=='w') mode=2;
	if(ch=='o') mode=2;
	if(ch=='.') mode=2;
	if(ch=='c') mode=3;
	if(ch=='e') mode=3;
	if(ch=='p') mode=3;
	if(ch=='/') mode=3;
	if(mode>0) doMouseClick(mode,JX);
    }

 
    public void keyPressed(KeyEvent e) {}
    public void keyReleased(KeyEvent e) {}



}

