import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class Animate1 implements Runnable {
    Manager M;
    boolean halt;
    double[] range=new double[2];
    int[] mode=new int[3];
    int[][] data;
    double[] line=new double[2];


    public Animate1() {}

    public Animate1(Manager MM) {
	this.M=MM;
	halt=true;
    }

    /**main routine*/
    
    public void run() {
	halt=false;
	range[0]=Math.PI*M.C.PITCH[0].getParameter();  //middle bend pitch start
	range[1]=Math.PI*M.C.PITCH[1].getParameter();  //middle bend pitch end
	line[0]=Math.PI*M.C.LINE[0][0].getParameter();  //excluder angle
	line[1]=M.C.LINE[0][1].getParameter();          //excluder y=intercept
	mode[0]=M.C.SIMPLIFY.mode; //tensegrity subspace
	mode[1]=M.C.HALF.mode;    //which side of constraint plane
	mode[2]=M.C.TIP.mode;     //which endpoint
	int level=M.C.LEVEL.mode; //which level capacity: in the paper we use level=1.
	
	double[] r0=random10();
	double[] A=Tensegrity.tuneParameters(r0,mode,range,line);
	double min=Tensegrity.capacity(A,level);
	double min2=10;
	
	while(halt==false) {
	    double jump=Math.random();
	    double[] r=random10Guided(jump,r0);
	    A=Tensegrity.tuneParameters(r,mode,range,line);
	    double k=Tensegrity.capacity(A,level);

	    if(k<min) {
	        min=k;
		r0=copy(r);
		sendStuff(r[9],k,level,A);
	        M.repaint();
	    }
	    
	    if(Math.random()<-.000001) {
	        min=k;
		r0=copy(r);
		sendStuff(r[9],k,level,A);
	        M.repaint();
	    }

	    if(min2>min) {
		min2=min;
		System.out.println(min2);
	    }
	}
	halt=true;
    }

    /**supporting routines*/
    
    /**sends stuff to the other windows*/
    
    public void sendStuff(double r,double k,int level,double[] A) {
        M.S.Z=Tensegrity.toTensegrityRight(A);
	try{M.P.TEN=Tensegrity.toTensegrityLeft(A,level);}
	catch(Exception e) {}
	try{M.SE.SOURCE=new Complex(A[0],A[2]);}
	catch(Exception e) {}
	Double D=new Double(0);
	D=new Double(k);
	M.C.MESSAGE[0]="capacity "+D.toString();
	D=new Double(r);
	M.C.MESSAGE[1]="pitch position "+D.toString();
	D=new Double(A[0]);
	M.C.MESSAGE[2]="bottom slope "+D.toString();
	D=new Double(A[2]);
        M.C.MESSAGE[3]="top slope "+D.toString();
	D=new Double(A[3]);
	M.C.MESSAGE[4]="offset x "+D.toString();
	D=new Double(A[4]);
        M.C.MESSAGE[5]="offset y "+D.toString();
    }
    

    public double[] copy(double[] r) {
	double[] s=new double[r.length];
	for(int i=0;i<s.length;++i) s[i]=r[i];
	return s;
    }

    public double[] random10() {
	double[] r=new double[10];
	for(int i=0;i<10;++i) r[i]=Math.random();
	return r;
    }
    
    public double[] random10Signed() {
	double[] r=new double[10];
	for(int i=0;i<10;++i) r[i]=1-2*Math.random();
	return r;
    }

    public double[] random10Guided(double size,double[] r0) {
	double[] r=random10Signed();
	for(int i=0;i<10;++i) {
	    r[i]=(1-size)*r0[i]+size*r[i];
	    if(r[i]<0) r[i]=0;
	    if(r[1]>1) r[i]=1;
	}
	return r;
    }
    
}
