import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class ControlCanvas extends ScaleCanvas implements MouseListener,MouseMotionListener,KeyListener {
    Manager M;
    PopupManager POP;
    SelectColor CS;
    ListenSquare GO,STOP,RESET;
    ControlPanel HALF,TIP,SIMPLIFY,LEVEL;
    ControlPanelColor DISPLAY;
    ControlPanelColor ZONE;
    Animate1 AN1;
    ShapeEntryBasic[] PITCH =new ShapeEntryBasic[2];
    ShapeEntryBasic[][] LINE=new ShapeEntryBasic[5][2];
    double BMAX,BMIN;
    String[] MESSAGE=new String[6];

     public ControlCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 addKeyListener(this);
	 setScales(50,200,1000);
	 GO=new ListenSquare(450,300,35,20);
	 STOP=new ListenSquare(450,320,45,20);
	 RESET=new ListenSquare(320,240,70,30);
	 AN1=new Animate1();
	 AN1.halt=true;
	 setPanels();
	 CS=new SelectColor(M,0,350,499,49);
	 setPitch();
	 for(int i=0;i<6;++i) MESSAGE[i]="";
     }

    public void setPitch() {
	
         PITCH[0]=new ShapeEntryBasic(345,30);
	 PITCH[1]=new ShapeEntryBasic(415,30);
	 PITCH[0].I[0].val=4;
	 PITCH[0].I[1].val=12;
	 PITCH[1].I[0].val=4;
	 PITCH[1].I[1].val=12;

	 LINE[0][0]=new ShapeEntryBasic(345,130);
	 LINE[0][1]=new ShapeEntryBasic(415,130);
	 LINE[0][0].I[0].val=4;
	 LINE[0][0].I[1].val=12;
	 LINE[0][1].I[0].val=1;
	 LINE[0][1].I[1].val=8;
    }


    public void setPanels() {
	
       Color[] C0={new Color(80,120,255),
                   Color.white,
                   Color.white,
                   Color.black,
                   Color.white};
	
        String[] HalfString={"above",
			     "on",
			     "below",
                              "halfplane"};
        int[] HalfState={0,1,0};
        HALF=new ControlPanel(C0,HalfString,HalfState,3);
	HALF.mode=1;

        String[] TipString={"0",
			     "1",
                              "tip"};
        int[] TipState={1,0};
        TIP=new ControlPanel(C0,TipString,TipState,2);
	TIP.mode=0;

        String[] LevelString={"reduced","actual","capacity"};
        int[] LevelState={0,1};
        LEVEL=new ControlPanel(C0,LevelString,LevelState,2);
	LEVEL.mode=1;

	

        String[] SimplifyString={"no",
				 "planar",
				 "planar + T",
                              "simplify"};
        int[] SimplifyState={0,1,0};
        SIMPLIFY=new ControlPanel(C0,SimplifyString,SimplifyState,3);
	SIMPLIFY.mode=1;


        String[] DisplayString={"background",
				"convex hull",
				"top bend",
				"middle bend",
				"bottom bend",
				"elastic",
				"select. line",
				"display"};

       Color[] DisplayColor={
	   new Color(255,255,255),
	   new Color(200,200,200),
	   new Color(0,0,0),
	   new Color(0,0,255),
	   new Color(0,0,0),
	   new Color(255,0,0),
	   Color.black,
	   new Color(255,200,0),
	   Color.black};
	
       int[] DisplayState={1,1,1,1,1,1,1};
        DISPLAY=new ControlPanelColor(C0,DisplayString,DisplayState,7,DisplayColor);


        String[] ZoneString={"04A","04B","44A","44B","01A","01B","4AR","4BR","46A","46B","01AR","01BR","zones"};

       Color[] ZoneColor={
	   new Color(255,180,0,150),
	   new Color(255,180,0,150),
	   new Color(0,200,60,150),
	   new Color(0,200,60,150),
	   new Color(0,50,255,150),
	   new Color(0,50,255,150),
	   new Color(250,0,0,150),
	   new Color(250,0,0,150),
	   new Color(0,255,255,150),
	   new Color(0,255,255,150),
	   new Color(200,0,100,150),
	   new Color(200,0,100,150)};
       int[] ZoneState={0,0,0,0,0,0,0,0,0,0,0,0};
        ZONE=new ControlPanelColor(C0,ZoneString,ZoneState,12,ZoneColor);
    }

    
    

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      drawControls(g);
      drawMessage(g);
   }

    public void drawBG(Graphics2D g) {
	g.setColor(new Color(120,0,120));
      g.fillRect(0,0,getWidth(),getHeight()); 
    }

    public void drawMessage(Graphics2D g) {
	g.setColor(Color.white);
	g.setFont(new Font("Helvetica",Font.PLAIN,15));
	for(int i=0;i<6;++i) {
	    g.drawString(MESSAGE[i],15,230+20*i);
	}
    }

    
    public void drawControls(Graphics2D g) {
	RESET.render(g,"reset",25,0,Color.blue);
	if(AN1.halt==true) GO.render(g,"go",12,4,new Color(0,180,0));
        else  STOP.render(g,"stop",12,4,new Color(200,0,0));
      DISPLAY.render(g,90,0,110);
      ZONE.render(g,205,0,80);
      SIMPLIFY.render(g,5,60,80);
      TIP.render(g,5,130,80);
      LEVEL.render(g,5,5,80);
      HALF.render(g,90,130,110);
      POP.render(g);
      CS.render(g);
      for(int i=0;i<2;++i) PITCH[i].render(g);
      for(int i=0;i<2;++i) LINE[0][i].render(g);

      g.setFont(new Font("Helvetica",Font.PLAIN,15));
      g.setColor(Color.white);
      g.drawString("pitch      start          end",300,20);
      g.drawString("excluder   angle    y-intercept",290,120);
    }
    
    public void doAnimate() {
	if(AN1.halt==false) return;
	AN1=new Animate1(this.M);
	new Thread(AN1).start();
    }

    public void setZones(Point X,Color C) {
       int t=ZONE.process(X,C);
       if((t==2)||(t==3)||(t==6)||(t==7)) {
	   PITCH[0].I[0].val=4;
	   PITCH[0].I[1].val=12;
	   PITCH[1].I[0].val=4;
	   PITCH[1].I[1].val=12;
       }

       if((t==4)||(t==5)||(t==10)||(t==11)) {
	   PITCH[0].I[0].val=-1;
	   PITCH[0].I[1].val=30;
	   PITCH[1].I[0].val=1;
	   PITCH[1].I[1].val=12;
       }
       
       if((t==8)||(t==9)) {
	   PITCH[0].I[0].val=4;
	   PITCH[0].I[1].val=12;
	   PITCH[1].I[0].val=8;
	   PITCH[1].I[1].val=15;
       }

       if((t==0)||(t==1)) {
	   PITCH[0].I[0].val=-1;
	   PITCH[0].I[1].val=30;
	   PITCH[1].I[0].val=11;
	   PITCH[1].I[1].val=30;
       }
    }


    public int getFirstZone() {
	for(int i=0;i<12;++i) {
	    if(ZONE.L[i].on==1) return i;
	}
	return -1;
    }


    public void doReset() {
	AN1.halt=true;
	setPanels();
	setPitch();
    }


    

    
    public void mouseClicked(MouseEvent e) {
        MouseData J=MouseData.process(e);
	    for(int i=0;i<2;++i) PITCH[i].processMouse(e);
	    for(int i=0;i<2;++i) LINE[0][i].processMouse(e);
	   if(GO.inside(J.X)==1) doAnimate();
	   if(RESET.inside(J.X)==1) doReset();
	   if(STOP.inside(J.X)==1) AN1.halt=true;
	   HALF.switchMode(J.X);
	   TIP.switchMode(J.X);
	   LEVEL.switchMode(J.X);
	   SIMPLIFY.switchMode(J.X);
	   CS.process(e);
	   DISPLAY.process(J.X,CS.C);
	   setZones(J.X,CS.C);
	   POP.process(J.X);
           M.repaint();
    }

    public void mousePressed(MouseEvent e) {}
     public void mouseReleased(MouseEvent e) {}
     public void mouseEntered(MouseEvent e) {
	 requestFocus();
     }
     public void mouseExited(MouseEvent e) {}   
     public void mouseMoved(MouseEvent e) {}    
     public void mouseDragged(MouseEvent e) {
     }
    
     public void keyPressed(KeyEvent e) {}
     public void keyReleased(KeyEvent e) {}
     public void keyTyped(KeyEvent e) {	
	    for(int i=0;i<2;++i) PITCH[i].processKey(e);
	    for(int i=0;i<2;++i) LINE[0][i].processKey(e);
	 M.repaint();
     }

}

