import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**Documentation file*/


public class DocumentIntro {

    public DocumentIntro() {}


    public static void setup(DocumentCanvas D) {
    
	String S="Confiner Calculations";
        S=S+"\nby Rich Schwartz";


	S=S+"\n\nPURPOSE:";
        S=S+"\n\nThe purpose of this program is to do numerical simulations with some calculations that used to be in my paper about the optimal Moebius band.  The latest version of the paper has a different method, so you can just ignore these calculations.  On the other hand, I imagine that possibly I might pursue them at a later time.   This text will explain the operation of the program.  There is more text than fits on the screen.  You can drag the text down with the mouse. You can also reset the position of text or change the font size using the controls at the top of this window. ";

	S=S+"\n\nMOUSE:";
	S=S+"\n\nThis program is best run using a 3 button mouse.  The control panel (the one with all the buttons) just requires a 1 button mouse and occasionally the keyboard.  The other windows use the 3 buttons.  In general, a left and right click will scale the picture about the click point and a middle point will select a new source point on the window.  I have added in keyboard shortcuts in case you do not have a 3 button mouse.  The keys z,x,c, simulate the 3 kinds of clicks.  In general, you have to click on a window in order to activate the keyboard shortcuts";

	S=S+"\n\nOVERVIEW";
	S=S+"\n\nThis program has 5 windows. Here is their description:";
	S=S+"\n\nText window.  This is what you are reading.";
	S=S+"\n\nControl Window.  This is the magenta window.  This window allows you to set the kind of calculation you are doing, select confiner regions, specify excluding halfspaces, and launch the calculations. ";
	S=S+"\n\nTensegrity window:  This window draws a planar projection of the tensegrity image.  The main thing you do on this window is click around the edges of the confiner regions to specify excluder halfspaces.  Below I will run through some examples.";
	S=S+"\n\ntrapezoid window: This window reconstructs the minimal tensegrity corresponding to the tensegrity image shown in the space window.  This window is not visible when you launch the program. You need to click the `trap.' button on the control window to launch it.";
	S=S+"\n\nselector window: This shows a picture of the trapezoid from Statement 3 of THeorem 3.1 in the paper.  This trapezoid shows the range of allowable slopes for the top and bottom edges of the trapezoid shown in the trapezoid window.";
	S=S+"\n\nConcerning the popup windows, you should not bring up the same window twice. This will cause neither to work.  If you do this accidentally, kill both of them and bring up a new one.  This should fix it.";
	S=S+"\n\nYou can rescale all the windows except the control panel.";

	S=S+"\n\nEXAMPLES:";
	S=S+"\n\nHere I will explain some step by step recipes for doing the calculations.  Before doing each example, you should press the `RESET' button on the control panel. This will put the relevant part of the program in its initial state.  So, step 0 of each example is to press the RESET button.";
	
	S=S+"\n\n-----------------------example 0---------------------------";
	S=S+"\n\n1. Press go.  This will launch a calculation that I have pre-set.  I am making all the choices for you here.  You should see numerical info start appearing on the control panel. The first number is the most important one.  The value x indicates that the capacity is \u221A 3 + x.";
	S=S+"\n\n2. Press stop.  This ends the calculation.";
	
	S=S+"\n\n-----------------------example 1---------------------------";
	S=S+"\n\n1. Click on the button 44A.  A green polygon should appear in the space window.";
	S=S+"\n\n2. Using the middle mouse button, click around the edges of the green polygon.  Notice that you will be selecting different lines. These lines are the projections to the plane of the confiner half spaces.";
	S=S+"\n\n3. Press go.  This will launch the calculation.  You should see numerical info start appearing on the control panel. The first number is the most important one.  The value x indicates that the capacity is \u221A 3 + x.";
	S=S+"\n\n4. Press stop.  This ends the calculation.";

	
	S=S+"\n\n-----------------------example 2---------------------------";
	S=S+"\n\n1-4. Repeat example 1, but instead press the 44B button.  After you press go, the capacity you see will be very large and the tensegrity picture will look very stretched.  This is because you are testing the wrong endpoint.  So...";
	S=S+"\n\n5. On the control panel change the `tip' button from 0 to 1.  This will change the endpoint you are testing.  Now repeat steps 3 and 4. That is press go again and then press stop.";

	
	S=S+"\n\n-----------------------example 3---------------------------";
	S=S+"\n\n1. Click on the button 44A.  A green polygon should appear in the space window.";
	S=S+"\n\n2. Using the middle mouse button, click around the edges of the green polygon until you have highlighted the bottom edge.  This edge has slope (1/12)\u03C0 and y-intercept 9/25.  These values should appear on the control panel just under the words `excluder angle y-intercape'.";
	S=S+"\n\n3. On the `halfplane' control panel change the option from `on' to` above'.";
	S=S+"\n\n4. Press go.  Notice that the capacity is much lower and the tensegrity is not being stretched.  This time we are confining the relevant endpoint to lie outside the halfspace confiner rather than on its boundary. That is, we are not really confining it at all ";
	S=S+"\n\n 5. press stop";
	S=S+"\n\n 6. . On the `halfplane' control panel change the option from `on' to below.  Repeat steps 4.5.  This time notice that you get the stretching phenomenon and that the endpoint migrates towards the boundary of the excluding halfspace.";
	
	S=S+"\n\n-----------------------example 4---------------------------";
	S=S+"\n\n1-3. Repeat steps 1-3 from example 3.";
	S=S+"\n\n4 On the control panel, manually change the y-intercept from 9/25 from 29/25.  You need to click in the relevant field and then use the keybpard.";
	S=S+"\n\n5. Press go.  Notice that the tensegrity is again quite stretched.  This is because you have changed the excluding halfspace.";
	S=S+"\n\n6. Press stop.";
	S=S+"\n\n7 On the control panel change the excluder angle from 1/12 to 2/12.  If you prefer to see 1/6 in place of 2/12, you can press the reduce button beneath the numbers you have just entered.  Notice that you have changed the angle of the line in the space window.";
	S=S+"\n\n8 repeat steps 5-6.  Not much has changed with the calculation.";

	
	S=S+"\n\n-----------------------example 5---------------------------";
	S=S+"\n\n1. The pitch interval starts out at [4/12,4/12] which means that we are constraining the middle bend image to have pitch (4/12)\u03C0.  Change this interval so that it is [1/12,1/12]. ";
	S=S+"\n\n2. Press go and look at how the picture has changed.  The capacity is much lower because the tensegrity is not stretched.";
	S=S+"\n\n3. press stop.";
	S=S+"\n\n4  So far we have constrained the middle bend image pitch to be a single angle. If you change the pitch start to 1/12 and 3/12 you are allowing a whole interval of possibilities.";
	S=S+"\n\n5. Press go. On the information printout the `pitch position' number tells where the pitch of the current segment lies in this interval.";
	S=S+"\n\n6. Press stop.";

	
	S=S+"\n\nMODIFIERS:";

    S=S+"\n\nThe examples above should show you how to basically run the calculations in the paper.  There are some modifiers which we now discuss.";

S=S+"\n\n1. capacity options.  The reduced capacity is a simpler version of the capacity function which ignores the diagonals of the tensegrity.  Sometimes the calculations in the paper still work with the reduced capacity and sometimes not.  The presumed advantage of using the reduced capacity is that it would be easier to make such calculations rigorous.  Anyway, I was curious about using a simpler calculation.";

S=S+"\n\n2. simplify options.  When you have no simplifications, you are considering all tensegrities satifying the given constraints. With the planar option, you are only considering planar examples.  This is discussed in the paper.  The planar option leads to calculations which converge more quickly to the presumed minimum.  The `planar + T' option sets the offsets to 0 and arranges to that the T pattern is perfect: The right endpoint of the horizontal bend image is the nidpoint of the vertical bend image.  I did not talk about this simplification in the paper. You can just ignore it.";

S=S+"\n\n3. display options.  You can toggle the display of various various features shown on the space window. You can also recolor them.   On the `display' panel, the left column of buttons controls the color and the right column controls whether the corresponding object is shown or not.  To recolor things, first choose a color on the color selector, then press one of the left buttons.";

S=S+"\n\n4 zone options. You can  also toggle the display and coloring of the zones.  Here is a very important point.  When you press one of the zones, the pitch interval is automatically set to the interval in the paper corresponding to this region.  If you have several of these regions turned on at once, and you want to run a test, you should take care that you have pressed the correct zone button last.  The safest thing to do is to press reset, then turn on one zone, then proceed as in the examples above.";

        D.setExplain(S);
        D.repaint();   
	D.Y0=0;
        D.Y1=0;
    }
}

