import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class PictureCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener {
    Manager M;
    Complex[] TEN=new Complex[10];
    double[] A=new double[5];

     public PictureCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 setScales(100,250,200);
     }


    public Complex[] initExample() {
	Complex[] W=new Complex[6];
	double m=2/Math.sqrt(3);
	 W[0]=new Complex(1,0);
	 W[1]=new Complex(0,m/2);
	 W[2]=new Complex(0,-m/2);
	 W[3]=new Complex(-.3,m/2);
	 W[4]=new Complex(-.3,-m/2);
	 W[5]=new Complex(1.3,.3);
	 return W;
    }

    
   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      try{ drawTens(g);}
      catch(Exception e) {}
   }


    public void drawTens(Graphics2D g) {
	Path2D.Double p=new Path2D.Double();
	
	p.reset();
	p.moveTo(1,0);
	p.lineTo(TEN[0].x,TEN[0].y);
	p.lineTo(TEN[4].x,TEN[4].y);
	p.lineTo(TEN[3].x,TEN[3].y);
	p.closePath();
	p=transform(p);
	g.setColor(Color.red);
	g.fill(p);
	g.setColor(Color.black);
	g.draw(p);


	p.reset();
	p.moveTo(TEN[3].x,TEN[3].y);
	p.lineTo(TEN[1].x,TEN[1].y);
	p.lineTo(TEN[2].x,TEN[2].y);
	p.lineTo(TEN[4].x,TEN[4].y);
	p.closePath();
	p=transform(p);
	g.setColor(Color.blue);
	g.fill(p);
	g.setColor(Color.black);
	g.draw(p);


	
    }

    
    public void drawBG(Graphics2D g) {
	g.setColor(Color.white);
        g.fillRect(0,0,getWidth(),getHeight());
	Path2D.Double p=new Path2D.Double();
    }

    
    public void mousePressed(MouseEvent e) { }
    public void mouseClicked(MouseEvent e) { 
	MouseData J=MouseData.process(e);
        if(J.mode==1)  scaleUp(J.X,0);
        if(J.mode==3)  scaleUp(J.X,1);
	if(J.mode==2) SOURCE=unTransform(J.X);
	SOURCE.print();
	repaint();
    }
     public void mouseReleased(MouseEvent e) {	 
     }

     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   

     public void mouseMoved(MouseEvent e) {}   
     public void mouseDragged(MouseEvent e) {
     }


}

