import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class SelectorCanvas extends ScaleCanvas implements MouseListener,MouseMotionListener  {
    Manager M;

     public SelectorCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 setScales(00,-130,700);
     }

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      drawSelector(g);
   }

    public void drawBG(Graphics2D g) {
	g.setColor(Color.white);
      g.fillRect(0,0,getWidth(),getHeight()); 
    }

    public void drawSelector(Graphics2D g) {

	drawRange(g);

	Path2D.Double p=new Path2D.Double();

	p.moveTo(SOURCE.x,SOURCE.y-.05);
	p.lineTo(SOURCE.x,SOURCE.y+.05);
	p.moveTo(SOURCE.x-.05,SOURCE.y);
	p.lineTo(SOURCE.x+.05,SOURCE.y);

	p=transform(p);
	g.setColor(Color.black);
	g.draw(p);
	Double D=new Double(SOURCE.x);
	g.setColor(Color.black);
	g.setFont(new Font("Helvetica",Font.PLAIN,15));
	g.drawString(D.toString(),10,15);
	D=new Double(SOURCE.y);
	g.setColor(Color.black);
	g.setFont(new Font("Helvetica",Font.PLAIN,15));
	g.drawString(D.toString(),10,35);
	p.reset();
    }

    public void drawRange(Graphics2D g) {


	Complex z0=new Complex(0,-1/Math.sqrt(3));
	Complex z1=Complex.plus(z0,new Complex(3,4));
	Complex z2=new Complex(0,-.5);
	Complex z3=Complex.plus(z2,new Complex(3,2));

	Complex z4=Vector.findCross(z0,z1,z2,z3);
	double x=(Math.sqrt(27)-Math.sqrt(11))/4;

	Path2D.Double p=new Path2D.Double();
	p.moveTo(z0.x,z0.y);
	p.lineTo(z4.x,z4.y);
        p.lineTo(x,(2.0/3)*x - 1.0/2);
        p.lineTo(x,(2.0/3)*x - 1.0/Math.sqrt(3));
	p.closePath();
	p=transform(p);
	g.setColor(new Color(255,150,0));
	g.fill(p);
    }


    public void mouseClicked(MouseEvent e) {
        MouseData J=MouseData.process(e);
	if(J.mode==1)  scaleUp(J.X,0);
        if(J.mode==3)  scaleUp(J.X,1);
        if(J.mode==2)  SOURCE=unTransform(J.X);
	M.repaint();
    }

    public void mousePressed(MouseEvent e) {}
     public void mouseReleased(MouseEvent e) {}
     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   
     public void mouseMoved(MouseEvent e) {}    
     public void mouseDragged(MouseEvent e) {
        MouseData J=MouseData.process(e);
        if(J.mode==2)  {
	    SOURCE=unTransform(J.X);
	}
	M.repaint();

     }


}

