import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class SpaceCanvas extends ScaleCanvas implements MouseListener, KeyListener,MouseMotionListener {
    Manager M;
    Complex[] Z=new Complex[6];
    Point JX;

     public SpaceCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 addKeyListener(this);
	 setScales(400,300,350);
	 double t=5*Math.PI/12;
	 Z=initExample();
     }


    public Complex[] initExample() {
	Complex[] W=new Complex[6];
	double m=2/Math.sqrt(3);
	 W[0]=new Complex(-1,0);
	 W[1]=new Complex(0,+m/2);
	 W[2]=new Complex(0,-m/2);
	 W[3]=new Complex(.3,m/2);
	 W[4]=new Complex(.3,-m/2);
	 W[5]=new Complex(-1.3,-.3);
	 return W;
    }

    
   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      drawPoints(g);
      drawZones(g);
      drawDivider(g);
   }

    public void drawBG(Graphics2D g) {
	g.setColor(M.C.DISPLAY.M[0].C);
        g.fillRect(0,0,getWidth(),getHeight());
	Path2D.Double p=new Path2D.Double();
	p.moveTo(Z[1].x,Z[1].y);
	p.lineTo(Z[2].x,Z[2].y);
	p.lineTo(Z[0].x,Z[0].y);
	p.closePath();
	p=transform(p);
	g.setColor(M.C.DISPLAY.M[1].C);
	if(M.C.DISPLAY.L[1].on==1) g.fill(p);


	int a=M.C.TIP.mode;
	fillPoint(g,Z[3+a],.01,Color.blue,32);

	
    }

    public void drawSegment(Graphics2D g,Complex a,Complex b,Color C) {
	drawSegment(g,a,b,C,1);
    }
    
    public void drawSegment(Graphics2D g,Complex a,Complex b,Color C,int thick) {
	Path2D.Double p=new Path2D.Double();
	p.moveTo(a.x,a.y);
	p.lineTo(b.x,b.y);
	p=transform(p);
	g.setColor(C);
	g.setStroke(new BasicStroke(thick));
	g.draw(p);
	g.setStroke(new BasicStroke(1));
    }


    
    
    public void drawDivider(Graphics2D g) {
	if(M.C.DISPLAY.L[6].on==0) return;
	Complex[] A2=getLine();
	drawSegment(g,A2[0],A2[1],M.C.DISPLAY.M[6].C,2);
    }

    public Complex[] getLine() {
	Complex[] A=new Complex[2];
	A[0]=new Complex();
	A[1]=new Complex();
	A[0].x=-2;
	A[1].x=1;
	double m=Math.PI*M.C.LINE[0][0].getParameter();
	m=Math.tan(m);
	double b=M.C.LINE[0][1].getParameter();
	for(int i=0;i<2;++i) {
	    A[i].y=m*A[i].x+b;
	}
	return A;
    }

    
    public void drawZones(Graphics2D g) {
	for(int i=0;i<12;++i) {
	   if(M.C.ZONE.L[i].on==1) drawZone(g,i,M.C.ZONE.M[i].C);
	}
    }


    public void drawZone(Graphics2D g,int choice,Color C) {
	int[][] data=TensegrityData.getData(choice);
	Path2D.Double p=toPath(data);
	drawWithOutline(g,p,C);
    }



    /***generates the polygon from the data*/
    
    public static Complex[] toLine(double m,double b) {
	Complex[] A=new Complex[2];
	A[0]=new Complex(0,b);
	A[1]=new Complex(1,m+b);
	return A;
    }

    public static Complex[] toLine(int[] d) {
	double m=Math.tan(Math.PI*d[0]/d[1]);
	double b=1.0*d[2]/d[3];
	return toLine(m,b);
    }
    

    public static Complex[][] toEdges(int[][] data) {
	int n=data.length;
	Complex[][] Z=new Complex[n][2];
	for(int i=0;i<n;++i) Z[i]=toLine(data[i]);
	return Z;
    }

    public static Complex[] toVertices(int[][] data) {
	int n=data.length;
	Complex[][] Z=toEdges(data);
	Complex[] W=new Complex[n];
	for(int i=0;i<n;++i) {
	    int j=(i+1)%n;
	    W[i]=Vector.findCross(Z[i][0],Z[i][1],Z[j][0],Z[j][1]);

	}
	return W;
    }

    public static Complex center(int[][] data) {
	Complex[] Z=toVertices(data);
	double x=0;
	double y=0;
	for(int i=0;i<Z.length;++i) {
	    x=x+Z[i].x;
	    y=y+Z[i].y;
	}
	x=x/Z.length;
	y=y/Z.length;
	return new Complex(x,y);
    }
    

    public static Complex polygonSample(int[][] data,double r) {
	int N=data.length;
	int k0=(int)(N*r);
	double r1=N*r-k0;
	int k1=(k0+1)%N;
	Complex[] Z=toVertices(data);
        double x=(1-r1)*Z[k0].x + r1*Z[k1].x;
        double y=(1-r1)*Z[k0].y + r1*Z[k1].y;
	return new Complex(x,y);
    }
    

    public static Path2D.Double toPath(int[][] data) {
	int n=data.length;
	Complex[] W=toVertices(data);
	PolygonWrapper X=new PolygonWrapper(n,W);
	return X.toPath();
    }

    public void drawWithOutline(Graphics2D g,Path2D.Double p,Color C) {
	p=transform(p);
	g.setColor(C);
	g.fill(p);
	g.setColor(Color.black);
	g.draw(p);
    }
    
    
    public void drawPoints(Graphics2D g) {
	Path2D.Double p=new Path2D.Double();
	Complex O=new Complex(0,0);
	fillPoint(g,new Complex(0,0),.003,Color.yellow,32);
	if(M.C.DISPLAY.L[4].on==1) drawSegment(g,O,Z[0],M.C.DISPLAY.M[4].C);
	if(M.C.DISPLAY.L[3].on==1) drawSegment(g,Z[3],Z[4],M.C.DISPLAY.M[3].C);
	if(M.C.DISPLAY.L[2].on==1) drawSegment(g,Z[1],Z[2],M.C.DISPLAY.M[2].C);

	if(M.C.DISPLAY.L[5].on==1) {
	    Color COL2=M.C.DISPLAY.M[5].C;
	    drawSegment(g,O,Z[3],COL2);
	    drawSegment(g,Z[3],Z[1],COL2);
	    drawSegment(g,Z[0],Z[4],COL2);
	    drawSegment(g,Z[4],Z[2],COL2);
	}
    }


    public void setPoint() {
	int[] A=recognizeData(SOURCE);
      	M.C.LINE[0][0].I[0].val=A[0];
	M.C.LINE[0][0].I[1].val=A[1];
	M.C.LINE[0][1].I[0].val=A[2];
	M.C.LINE[0][1].I[1].val=A[3];
    }

    

    public int[] recognizeData(Complex A) {
	int[] index={0,0};
	double min=100;
	double test=0;
	for(int i=0;i<12;++i) {
	    int[][] data=TensegrityData.getData(i);	
	    Complex[][] Z=toEdges(data);
	    int n=data.length;
	
	    for(int j=0;j<n;++j) {
	    test=Complex.area(Z[j][0],Z[j][1],A);
	    if(M.C.ZONE.L[i].on==0) test=1000;
	       if(test<min) {
	  	  min=test;
		  index[0]=i;
		  index[1]=j;
	       }
	    }
	}
	int[][] data=TensegrityData.getData(index[0]);
	return data[index[1]];
    }

    
    public void mousePressed(MouseEvent e) { }


    public void mouseClicked(MouseEvent e) { 
	MouseData J=MouseData.process(e);
	JX=new Point(J.X);
	doMouseClick(J.mode);
    }

    public void doMouseClick(int mode) { 
        if(mode==1)  scaleUp(JX,0);
        if(mode==3)  scaleUp(JX,1);
	if(mode==2) {
	     SOURCE=unTransform(JX);
	     setPoint();
	}
	repaint();
	M.repaint();
    }






     public void mouseReleased(MouseEvent e) {	 
     }

     public void mouseEntered(MouseEvent e) {
	 requestFocus();
     }

     public void mouseExited(MouseEvent e) {}   

     public void mouseMoved(MouseEvent e) {
	 MouseData J=MouseData.process(e);
	 JX=new Point(J.X);
     }
  
     public void mouseDragged(MouseEvent e) {
	 MouseData J=MouseData.process(e);
	 if(J.mode==2) {
	      SOURCE=unTransform(J.X);
  	      setPoint();
	 }
	repaint();
	M.repaint();
     }

    public void keyTyped(KeyEvent e) {
	char x = e.getKeyChar();
	if(x=='z') doMouseClick(1);
	if(x=='x') doMouseClick(2);
	if(x=='c') doMouseClick(3);

    }


    public void keyPressed(KeyEvent e) {}
    public void keyReleased(KeyEvent e) {}


}

