import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;


public class TriangleGenerator {




    public static Complex[] triangle() {
	boolean test=false;
	Complex[] Z=new Complex[3];
	while(test==false) {
	    Z=triangleRaw();
	    if(triConstraints(Z)==true) test=true;
	}
	return Z;
    }

    public static double[] segmentPair(double a,double b) {
	boolean test=false;
	Complex[] Z=new Complex[4];
	double[] ran=new double[6];
	while(test==false) {
	    ran=getRandom();
	    Z=fromParameters(a,b,ran);
	    if(segConstraints(Z)==true) test=true;
	}
	return ran;
    }
    
    public static double[] segmentPair(double size,double[] ran0,double a,double b) {
	boolean test=false;
	Complex[] Z=new Complex[4];
	double[] ran=new double[6];
	while(test==false) {
	    ran=getRandom(size,ran0);
	    Z=fromParameters(a,b,ran);
	    if(segConstraints(Z)==true) test=true;
	}
	return ran;
    }

    public static boolean triConstraints(Complex[] Z) {
	double d=0;
	double per=perimeter(Z);
	if(Math.abs(Z[2].y)>1.0/12) return false;
	if(per>2*Math.sqrt(3)) return false;
	return true;
    }

    public static boolean segConstraints(Complex[] Z) {
	boolean test=cross(Z);
	if(test==true) return false;
	return true;
    }

    public static Complex[] triangleRaw() {
	double B=1+.15*Math.random();
	double T=1+.15*Math.random();
	Complex[] Z=new Complex[3];
	Z[0]=new Complex(B/2,-T/2);
	Z[1]=new Complex(B/2,+T/2);
	Z[2]=new Complex(-B/2,(1.0/30)*Math.random());
	return Z;
    }


    public static double tensegrityQuality(double a,double b,double[] ran,Complex[] TRI) {
	Complex[] SEG=fromParameters(a,b,ran);
	return tensegrityQuality(TRI,SEG);
    }

    public static double tensegrityQuality(Complex[] Z,Complex[] W) {
	Complex[] T=tensegrity(Z,W);
	double d1=perimeter(T);
	double d2=perimeter(Z);
	return d1-d2;
    }


    public static  Complex[] tensegrity(double a,double b,double[] ran,Complex[] TRI) {
	Complex[] SEG=fromParameters(a,b,ran);
	return tensegrity(TRI,SEG);
    }
    
    public static  Complex[] tensegrity(Complex[] TRI,Complex[] SEG) {
	Complex a=Complex.plus(TRI[0],TRI[1]);
	a.x=a.x-1.0/24;
	Complex b=new Complex(TRI[0].x,1.0/3);
	a=Complex.times(a,new Complex(.5,0));
	Complex[] T={TRI[0],a,SEG[2],SEG[0],TRI[1],TRI[2],SEG[3],SEG[1]};
	return T;
    }

    public static double[] getRandom() {
	double[] ran=new double[6];
	for(int i=0;i<4;++i) ran[i]=2*Math.random()-1;
	ran[4]=Math.random();
	ran[5]=Math.random();
	return ran;
    }

    public static double[] getRandom(double size,double[] ran0) {
	double[] ran=getRandom();
	double[] ran2=new double[6];
	for(int i=0;i<6;++i) ran2[i]=(1-size)*ran0[i]+size*ran[i];
	return ran2;
    }


    
    public static Complex[] fromParameters(double a,double b,double[] ran) {
	Complex[] SEG=new Complex[4];
	SEG[0]=new Complex(ran[0],ran[1]);
	SEG[2]=new Complex(ran[2],ran[3]);
	double r1=1-1.0/16+.25*ran[4];
	double r3=1-1.0/16+.25*ran[5];
	double v1=r1*Math.cos(a);
	double v2=r1*Math.sin(a);
	SEG[1]=Complex.minus(SEG[0],new Complex(v1,v2));
	double w1=r1*Math.cos(b);
	double w2=r1*Math.sin(b);
	SEG[3]=Complex.minus(SEG[2],new Complex(w1,w2));
	return SEG;
    }


    
    public static Complex[] fromParameters(double a,double b) {
	double[] ran=getRandom();
	return fromParameters(a,b,ran);
    }
    

    

    public static boolean cross(Complex[] Z) {
	Complex W=Vector.findCross(Z[0],Z[1],Z[2],Z[3]);
	double d=Complex.dist(Z[0],W)+Complex.dist(W,Z[1])-Complex.dist(Z[0],Z[1]);
	if(d>.0000000001) return false;
	d=Complex.dist(Z[2],W)+Complex.dist(W,Z[3])-Complex.dist(Z[2],Z[3]);
	if(d>.0000000001) return false;
	return true;
    }


    public static double perimeter(Complex[] T) {
	double d=0;
	for(int i=0;i<T.length;++i) {
	    int j=(i+1)%T.length;
	    d=d+Complex.dist(T[i],T[j]);
	}
	return d;
    }
	
    
}


