import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class Animate implements Runnable {
    Manager M;
    boolean halt;
    double[][] MIN=new double[6][2];
    double[][] RANDOM=new double[6][24];
    long TIME0,TIME1;
    int STATE;
    int[][] SIGN=new int[6][7];
    long COUNT;


    public Animate() {}

    public Animate(Manager MM) {
	this.M=MM;
	halt=true;
    }

    public void run() {
	initialize();
	System.out.println("start");
        COUNT=0;
	STATE=0;
	
	while(halt==false) {
	    for(int i=0;i<6;++i) {
		if(M.C.CHOICE.L[i].on==1) update(i);
	    }
	}
    }


    public void initialize() {
	halt=false;
	for(int i=0;i<6;++i) {
	    for(int j=0;j<2;++j) MIN[i][j]=100;
	}
	RANDOM[0]=random(24);
	RANDOM[1]=random(24);
	RANDOM[2]=random(24);
	RANDOM[3]=random(14);
	RANDOM[4]=random(14);
	RANDOM[5]=random(16);
	TIME0=Time.time();
	TIME1=TIME0;
    }


    public void update(int k) {
	    int simplify=M.C.SIMPLIFY.mode;
	    double step=M.C.PARAMETERS[1].getValue();
	    int[][] a=new int[2][2];
	    for(int i=0;i<2;++i) {
		for(int j=0;j<2;++j) {
		    a[i][j]=M.C.PITCH[j][i].val;
		}
	    }

	    double[] mask=new double[6];
	    for(int i=0;i<6;++i) {
		mask[i]=1.0*M.C.RELAX[k].on[i]*M.C.getFactor(k);
	    }
	 
	    int N=RANDOM[k].length;
	    double s=step*Math.random();
	    double[] r1=randomSigned(RANDOM[k].length);
	    double[] r=guided(N,RANDOM[k],r1,s);
	    double[] r2=filter(k,r);

	    Vector[] V=new Vector[0];
	    if(k<5) V=Configs.configuration(k,r2);
	    else {
		int choice=M.C.TYPE.mode;
		if(choice==0) V=Configs.configuration5(r2,a);
		if(choice==1) V=Configs.configuration6(r2,a);
	      
	    }
	    double c=Tensegrity.capacity(SIGN[k],V,k,mask);
	    
	    double penalty=M.C.PARAMETERS[3].getValue();
	    if(k==5) c=c+penalty*Tensegrity.crossingEnhancement(V,M.C.TYPE.mode,M.C.CROSS.on);
	    checkMinima(k,c,r,V);
    }

    public void checkMinima(int k,double c,double[] r,Vector[] V) {

	boolean refresh=false;
	long t=Time.time()-TIME1;
	
	if(t>M.C.PARAMETERS[0].getValue()*1000) {
	     refresh=true;
	     TIME1=TIME1+t;
	     STATE=1-STATE;
	     ++COUNT;
             resetSign(k);
	}

	if(refresh==true) {
	     RANDOM[k]=random(r.length);
	     MIN[k][0]=100;
	}

	   if(c<MIN[k][0]) {
		MIN[k][0]=c;
		RANDOM[k]=copy(r);
	        sendStuff(k,V,false);
	    }

	    if(MIN[k][0]<MIN[k][1]) {
		RANDOM[k]=copy(r);
		 MIN[k][1]=MIN[k][0];
		 boolean display=false;
		 if(k==M.C.CHOICE2.val) display=true;
		 sendStuff(k,V,display);
	    }

	    if(MIN[k][1]<0) {
		MIN[k][0]=100;
		MIN[k][1]=100;
	        ++M.C.FACTOR[k].val;
		if(M.C.FACTOR[k].val>50) {
		    System.out.println("fail");
		    halt=true;
		}
		M.C.repaint();
	    }
    }


    public static int randomSign() {
	if(Math.random()<.5) return 1;
	return -1;
    }
    
    public void resetSign(int k) {

	if(M.C.LEARN.mode==1) {
	     SIGN[k]=Configs.preferredSigns(k);
	     return;
	}

	//picks the best 3/4 of the time and otherwise picks randomly
	if((COUNT%4!=0)&&(M.C.LEARN.mode==2)) {
	     SIGN[k]=Configs.preferredSigns(k);
	     return;
	}
	
	
	for(int i=0;i<6;++i) SIGN[k][i]=Configs.randomSign();
	if(k<3) SIGN[k][6]=1;
	if(k==3) SIGN[k][3]=1;
	if(k==4) SIGN[k][4]=1;

	SIGN[k][0]=1;
	SIGN[k][1]=1;
	int[] u={3,4,4,3,2};
	if(k<5) SIGN[k][u[k]]=-1;

	if(k==5) {
	    if(M.C.TYPE.mode==0) {
		SIGN[k][3]=-1;
		SIGN[k][4]=1;
	    }

	    if(M.C.TYPE.mode==1) {
		SIGN[k][2]=-1;
		SIGN[k][4]=1;
	    }
	}


    }
	

    public void sendStuff(int choice,Vector[] V,boolean config) {
	int N=V.length;
        Complex[] Z=new Complex[N];
	for(int i=0;i<N;++i) {
	    Z[i]=new Complex(V[i].x[0],V[i].x[1]);
	}
	if(config==true) {
	     M.S.Z=Z;
	     for(int i=0;i<7;++i) M.S.SIGN[i]=SIGN[choice][i];
	     M.S.repaint();
	     double[] s=getSlopes(choice,V);
	     try{M.SE.SOURCE=new Complex(s[0],s[1]);
		 M.SE.repaint();}
	     catch(Exception e) {}
	}

	for(int k=0;k<6;++k) {
	  double f=M.C.getFactor(k);
	  Double F=new Double(f);
	  Double R=new Double(MIN[k][0]);
   	  M.C.MESSAGE[k][0]="("+F.toString()+")    "+R.toString();
	  R=new Double(MIN[k][1]);
	  M.C.MESSAGE[k][1]=R.toString();
	}
	String t=Time.toString("time  ",Time.time()-TIME0);
	M.C.MESSAGE[6][0]=t;
	Long c=new Long(COUNT);
	M.C.MESSAGE[6][1]="refresh "+c.toString();
	M.repaint();
    }

    public static double[] copy(double[] r0) {
	double[] r=new double[r0.length];
	for(int i=0;i<r0.length;++i) r[i]=r0[i];
	return r;
    }

    /**getting the slopes for the selector*/

    public double[] getSlopes(int choice, Vector[] V) {
	if(choice==5) return null;
	int[] D={3,4,4,3,2};
	int d=D[choice];
	double B=Vector.dist(V[0],V[1]);
	double T=Vector.dist(V[2*d],V[2*d+1]);
	double b=Math.sqrt(B*B-1);
	double t=-Math.sqrt(T*T-1);
	double[] tb={b,t};
	return tb;
    }




    /***the random variables**/
    
    public static double[] guided(int N,double[] r0,double[] r1,double t) {
	double[] r=new double[N];
	for(int i=0;i<N;++i) {
             r[i]=(1-t)*r0[i]+t*r1[i];
             if(r[i]<0) r[i]=r0[i];
             if(r[i]>1) r[i]=r0[i];
        }

	return r;
    }
    
    public static double[] interpolate(double[] a,double[] b,double s) {
	int N=a.length;
	double[] c=new double[N];
	for(int i=0;i<N;++i) {
	    c[i]=(a[i]+s*b[i])/(1+s);
	}
	return c;
    }

    public static double[] random(int k) {
	double[] d=new double[k];
	for(int i=0;i<k;++i) d[i]=Math.random();
	return d;
    }
    
    public static double[] randomSigned(int k) {
	double[] d=new double[k];
	for(int i=0;i<k;++i) d[i]=2*Math.random()-1;
	return d;
    }

    public static double[] project(int mode,double[] r) {
	if(mode==0) return r;
	int N=r.length;
	double[] s=new double[N];
	int L=16;
	if(N==16) L=12;
	if(N==14) L=10;
	for(int i=0;i<N;++i)  {
	    s[i]=r[i];
	    if(i>=L) s[i]=0;
	}
	if((N!=16)&&(mode==2)) s[8]=0;
	if((N==16)&&(mode==2)) s[10]=0;
	return s;
    }
    

    public static double[] mask(double[] a,double[] b,Lever MASK) {
	int N=a.length;
	double[] c=new double[N];
	for(int i=0;i<N;++i) {
	    c[i]=a[i];
	    if(MASK.on[i]==1) c[i]=b[i];
	}
	return c;
    }
    

    public double[] filter(int k,double[] r) {
         double[] r2=project(M.C.SIMPLIFY.mode,r);
	 if(k==5) return r2;
	 if(M.C.COERCE.mode==0) return r2;
	 double[] opt=Configs.optimum(k);
	 if(M.C.COERCE.mode==1) r2=interpolate(r2,opt,M.C.PARAMETERS[2].getValue());
	 if(M.C.COERCE.mode==2) r2=mask(r2,opt,M.C.MASK);
	 return r2;
    }

    
}
