import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**These are the configurations for the 5 calculations*/

public class Configs  {


    public static int variableNumber(int choice) {
	if(choice<3) return 24;
	return 14;
    }

    /**p stands for the pitch range*/
    
    public static Vector[] configuration(int choice,double[] r) {
	if(choice==0) return configuration0(r);
	if(choice==1) return configuration1(r);
	if(choice==2) return configuration2(r);
	if(choice==3) return configuration3(r);
	if(choice==4) return configuration4(r);
	return null;
    }



    public static Vector[] configuration0(double[] r) {
	    double[] bend=Tensegrity.bends0(take(r,0,5));
	    double[] pitch=Tensegrity.pitch0(take(r,6,7));
	    double[] c3=Tensegrity.offset(take(r,8,9));
	    double[] c1=Tensegrity.center(take(r,10,11),-.5,1-Math.sqrt(3)/2,.5);
	    double[] c5=Tensegrity.center(take(r,12,13),-.5,-1+Math.sqrt(3)/2,.5);
	    double[] c2=Tensegrity.center(-1,2,5,c5,bend,pitch,take(r,14,14));
	    double[] c4=Tensegrity.center(+1,4,1,c1,bend,pitch,take(r,15,15));
	    double l=Math.sqrt(1+bend[0]*bend[0]);
	    double[] c0={-l/2,0};
	    double[][] c={c0,c1,c2,c3,c4,c5};
	    double[] t=take(r,16,23);
	    double[] tilt={0,0,t[0],t[1],t[2],t[3],0,0,t[4],t[5],t[6],t[7]};
	    Vector[] V=Tensegrity.assemble(bend,pitch,c,tilt);
	    return V;
    }


    public static Vector[] configuration1(double[] r) {
	    double[] bend=Tensegrity.bends1(take(r,0,5));
	    double[] pitch=Tensegrity.pitch1(take(r,6,7));
	    double l=Math.sqrt(1+bend[0]*bend[0]);
	    double[] c0={-l/2,0};
	    double[] c4=Tensegrity.offset(take(r,8,9));
	    double[] c1=Tensegrity.center(take(r,10,11),-.5,1-Math.sqrt(3)/2,.5);
	    double[] c5=Tensegrity.center(take(r,12,13),-.5,-1+Math.sqrt(3)/2,.5);
	    double[] c2=Tensegrity.center(-1,2,5,c5,bend,pitch,take(r,14,14));
	    double[] c3=Tensegrity.center(+1,3,1,c1,bend,pitch,take(r,15,15));
	    double[][] c={c0,c1,c2,c3,c4,c5};
	    double[] t=take(r,16,23);
	    double[] tilt={0,0,t[0],t[1],t[2],t[3],t[4],t[5],0,0,t[6],t[7]};
	    Vector[] V=Tensegrity.assemble(bend,pitch,c,tilt);
	    return V;
    }

    public static Vector[] configuration2(double[] r) {
	    double[] bend=Tensegrity.bends1(take(r,0,5));
	    double[] pitch=Tensegrity.pitch1(take(r,6,7));
	    double l=Math.sqrt(1+bend[0]*bend[0]);
	    double[] c0={-l/2,0};
	    double[] c4=Tensegrity.offset(take(r,8,9));
	    double[] c1=Tensegrity.center(take(r,10,11),-.5,1-Math.sqrt(3)/2,.5);
	    double[] c5=Tensegrity.center(take(r,12,13),-.5,-1+Math.sqrt(3)/2,.5);
	    double[] c3=Tensegrity.center(-1,3,5,c5,bend,pitch,take(r,14,14));
	    double[] c2=Tensegrity.center(+1,2,1,c1,bend,pitch,take(r,15,15));
	    double[][] c={c0,c1,c2,c3,c4,c5};
	    double[] t=take(r,16,23);
	    double[] tilt={0,0,t[0],t[1],t[2],t[3],t[4],t[5],0,0,t[6],t[7]};
	    Vector[] V=Tensegrity.assemble(bend,pitch,c,tilt);
	    return V;
    }

    public static Vector[] configuration3(double[] r) {
	    double[] bend=Tensegrity.bends3(take(r,0,3));
	    double[] pitch=Tensegrity.pitch3(take(r,4,4));
	    double l=Math.sqrt(1+bend[0]*bend[0]);
	    double[] c0={-l/2,0};
	    double[] c1=Tensegrity.center(take(r,5,6),-.5,1-Math.sqrt(3)/2,.5);
	    double[] c2=Tensegrity.center(+1,2,1,c1,bend,pitch,take(r,7,7));
	    double[] c3=Tensegrity.offset(take(r,8,9));
	    double[][] c={c0,c1,c2,c3};
	    double[] t=take(r,10,13);
	    double[] tilt={0,0,t[0],t[1],t[2],t[3],0,0};
	    Vector[] V=Tensegrity.assemble(bend,pitch,c,tilt);
	    return V;
    }


    public static Vector[] configuration4(double[] r) {
	    double[] bend=Tensegrity.bends4(take(r,0,3));
	    double[] pitch=Tensegrity.pitch4(take(r,4,4));
	    double l=Math.sqrt(1+bend[0]*bend[0]);
	    double[] c0={-l/2,0};
	    double[] c1=Tensegrity.center(take(r,5,6),-.25,Math.sqrt(3)/12,.25);
	    double[] c2=Tensegrity.offset(take(r,7,8));
	    double[] c3=Tensegrity.center(1,3,1,c1,bend,pitch,take(r,9,9));
	    double[][] c={c0,c1,c2,c3};
	    double[] t=take(r,10,13);
	    double[] tilt={0,0,t[0],t[1],t[2],t[3],0,0};
	    Vector[] V=Tensegrity.assemble(bend,pitch,c,tilt);

	    Vector W=new Vector(0,0,0);
	    
	    W=new Vector(V[2]);
	    V[2]=new Vector(V[3]);
	    V[3]=new Vector(W);
	    
	    W=new Vector(V[4]);
	    V[4]=new Vector(V[5]);
	    V[5]=new Vector(W);
	    
	    return V;
    }


    public static Vector[] configuration5(double[] r,int[][] p) {
	    double[] bend=Tensegrity.bends5(take(r,0,3));
	    double[] pitch=Tensegrity.pitch5(take(r,4,5),p);
	    double l=Math.sqrt(1+bend[0]*bend[0]);
	    double[] c0={-l/2,0};
	    double[] c1=Tensegrity.center(take(r,6,7),0,0,1);
	    double[] c2=Tensegrity.center(take(r,8,9),0,0,1);
	    double[] c3=Tensegrity.offset(take(r,10,11));
	    double[][] c={c0,c1,c2,c3};
	    double[] t=take(r,12,15);
	    double[] tilt={0,0,t[0],t[1],t[2],t[3],0,0};
	    Vector[] V=Tensegrity.assemble(bend,pitch,c,tilt);
	    return V;
    }



    public static Vector[] configuration6(double[] r,int[][] p) {
	    double[] bend=Tensegrity.bends4(take(r,0,3));
	    double[] pitch=Tensegrity.pitch6(take(r,4,5),p);
	    double l=Math.sqrt(1+bend[0]*bend[0]);
	    double[] c0={-l/2,0};
            double[] c1=Tensegrity.center(take(r,6,7),0,0,1);
	    double[] c2=Tensegrity.offset(take(r,10,11));
	    double[] c3=Tensegrity.center(take(r,8,9),0,0,1);
	    double[][] c={c0,c1,c2,c3};
	    double[] t=take(r,12,15);
	    double[] tilt={0,0,t[0],t[1],t[2],t[3],0,0};
	    Vector[] V=Tensegrity.assemble(bend,pitch,c,tilt);
	    return V;
    }


    /**getting the best guess as to the optimizing signs*/
    
    public static int[] preferredSigns(int k) {
	int[][] s={{1,1,-1,-1,-1,1,1},{1,1,-1,-1,1,0,0},{1,0,-1,1,1,0,0}};
	int[] t={0,0,0,0,0,0,0};
	if(k<3) t=s[0];
	if(k==3) t=s[1];
	if(k==4) t=s[2];
	if(k==5) t=s[1];
	for(int i=0;i<7;++i) {
	    if(t[i]==0) t[i]=randomSign();
	}
	return t;
    }
    
    public static int randomSign() {
	if(Math.random()<.5) return 1;
	return -1;
    }

    public static double[] simplify(int choice,double[] r0) {
	int l=16;
	if(choice>=3) l=10;
	double[] r=new double[r0.length];
	for(int i=0;i<r0.length;++i) {
	    r[i]=r0[i];
	    if(i>=l) r[i]=0;
	}
	return r;
    }
    
    

    public static double[] take(double[] r,int a,int b) {
	int k=b-a+1;
	double[] s=new double[k];
	for(int i=0;i<k;++i) s[i]=r[a+i];
	return s;
    }

    /**Here are useful color schemes*/

    public static void assignColors(int choice,ControlPanelColor X) {
	if(choice==0) assignColors0(X);
	if(choice==1) assignColors1(X);
	if(choice==2) assignColors2(X);
	if(choice==3) assignColors3(X);
	if(choice==4) assignColors4(X);
	if(choice==5) assignColors1(X);
    }

    public static void assignColors0(ControlPanelColor X) {
	X.M[2].C=Color.black;
	X.M[3].C=new Color(0,0,255);
	X.M[4].C=new Color(255,100,0);
	X.M[5].C=new Color(50,50,50);
	X.M[6].C=new Color(50,100,255);
	X.M[7].C=new Color(200,0,0);
	X.M[1].C=new Color(0,200,0,100);
	for(int i=2;i<8;++i) X.L[i].on=1;
    }

    public static void assignColors1(ControlPanelColor X) {
	X.M[2].C=Color.black;
	X.M[3].C=new Color(0,0,255);
	X.M[4].C=new Color(200,0,0);
	X.M[5].C=new Color(50,100,255);
	X.M[6].C=new Color(50,50,50);
	X.M[7].C=new Color(200,0,0);
	X.M[1].C=new Color(0,200,0,100);
	for(int i=2;i<8;++i) X.L[i].on=1;
    }

    public static void assignColors2(ControlPanelColor X) {
	X.M[2].C=Color.black;
	X.M[3].C=new Color(200,0,0);
	X.M[4].C=new Color(200,0,0);
	X.M[5].C=new Color(0,0,255);
	X.M[6].C=new Color(50,50,50);
	X.M[7].C=new Color(0,0,255);
	X.M[1].C=new Color(0,200,0,100);
	for(int i=2;i<8;++i) X.L[i].on=1;
    }



    public static void assignColors3(ControlPanelColor X) {
	X.M[2].C=Color.black;
	X.M[3].C=new Color(200,0,0);
	X.M[4].C=new Color(255,100,0);
	X.M[5].C=new Color(50,50,50);
	X.M[1].C=new Color(0,200,0,100);
	for(int i=2;i<6;++i) X.L[i].on=1;
	X.L[6].on=0;
	X.L[7].on=0;
	X.L[1].on=1;
    }


    public static void assignColors4(ControlPanelColor X) {
	X.M[2].C=Color.black;
	X.M[3].C=new Color(200,0,0);
	X.M[4].C=new Color(50,50,50);
	X.M[5].C=new Color(255,100,0);
	X.M[1].C=new Color(0,200,0,100);
	for(int i=2;i<6;++i) X.L[i].on=1;
	X.L[6].on=0;
	X.L[7].on=0;
	X.L[1].on=1;
    }


    /**These are the parameters for the presumed optimizers*/

    public static double[] optimum(int choice) {
	if(choice<3) return optimum0();
	if(choice==3) return optimum3();
	if(choice==4) return optimum4();
	return null;
    }
        
    public static double[] optimum0() {
	double[] r=new double[24];
	double s=Math.sqrt(3);
	    r[0]=0;
	    r[1]=2-s;
	    r[2]=1/s;
	    r[3]=.5;
	    r[4]=1/s;
	    r[5]=2-s;
	    
	    r[6]=5.0/6; 
	    r[7]=1.0/6;
	    
	    r[8]=0;
	    r[9]=.5;
	    r[10]=.5;
	    r[11]=.5;
	    r[12]=.5;
	    r[13]=.5;
	    r[14]=3/s-1;
	    r[15]=2-3/s;
	    for(int i=16;i<24;++i) r[i]=0;
	    return r;
    }

    
    public static double[] optimum3() {
	double[] r=new double[14];
	double s=Math.sqrt(3);
	    r[0]=0;
	    r[1]=2-s;
	    r[3]=.5;
	    r[2]=1/s;

	    //pitch
            r[4]=5.0/6;

	    //c1
            r[5]=.5;
	    r[6]=.5;

	    //c2
	    r[7]=2-3/s;

	    //c3
	    r[8]=0;
	    r[9]=.5;
	    
	    for(int i=10;i<14;++i) r[i]=0;
	    return r;
    }

    
    public static double[] optimum4() {
	double[] r=new double[14];
	double s=Math.sqrt(3);
	    r[0]=0;
	    r[1]=.5;
	    r[2]=.5;
	    r[3]=1.0/s;


	    //pitch
            r[4]=5.0/11;

	    //c1
            r[5]=.5;
	    r[6]=.5;

	    //c2
	    r[7]=0;
	    r[8]=.5;
	    
	    //c3
	    r[9]=.5;
	    
	    
	    for(int i=10;i<14;++i) r[i]=0;
	    return r;
    }



}
