import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;



public class ControlCanvas extends ScaleCanvas implements MouseListener,MouseMotionListener,KeyListener {
    Manager M;
    SelectColor CS;
    ListenSquare GO,STOP;
    ControlPanel HALF,SIMPLIFY,SIGNS,CHOICE,COERCE,TYPE,LEARN;
    ControlPanelColor DISPLAY;
    Animate AN1;
    String[][] MESSAGE=new String[8][2];
    Complex OFFSET;
    PopupManager POP;
    EnhancedSlider[] PARAMETERS=new EnhancedSlider[4];
    SelectInteger[][] PITCH=new SelectInteger[2][2];
    Lever MASK;
    Lever[] FACTOR=new Lever[6];
    Lever[] RELAX=new Lever[6];
    Lever CHOICE3;
    Lever2 CHOICE2;
    Lever CROSS;
    ListenSquare[] INFO=new ListenSquare[11];
    
     public ControlCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 addKeyListener(this);
	 setScales(50,120,1000);
	 setAnimation();
	 setPanels();
	 setLevers();
	 setSliders();
	 setPitch();
	 setMessages();
	 setInfo();
	 Configs.assignColors(0,DISPLAY);
     }



    public void setPitch() {
	for(int i=0;i<2;++i) {
	    for(int j=0;j<2;++j) {
	     PITCH[i][j]=new SelectInteger(335+80*i,80+40*j,40,20,0,-10,130,1);
	    }
	}
    }

    public void setInfo() {


	INFO[0]=new ListenSquare(155,150,12,12);
	INFO[1]=new ListenSquare(620,5,12,12);
	INFO[2]=new ListenSquare(250,35,12,12);
	INFO[3]=new ListenSquare(102,215,12,12);
	INFO[4]=new ListenSquare(190,215,12,12);
	INFO[5]=new ListenSquare(620,564,12,12);
	INFO[6]=new ListenSquare(620,604,12,12);
	INFO[7]=new ListenSquare(620,644,12,12);
	INFO[8]=new ListenSquare(620,684,12,12);
	INFO[9]=new ListenSquare(620,435,12,12);
	INFO[10]=new ListenSquare(620,215,12,12);

    }
    
    public void setAnimation() {
	 GO=new ListenSquare(110,150,40,20);
	 STOP=new ListenSquare(110,170,40,20);
	 AN1=new Animate();
	 AN1.halt=true;
    }

    public void setMessages() {
	 for(int i=0;i<7;++i) {
	     MESSAGE[i][0]=".";
	     MESSAGE[i][1]=".";
	 }
    }

    public void setLevers() {
	CHOICE2=new Lever2(618,243,0,6,false);
	CHOICE3=new Lever(260,192,0,5,false);
	CROSS=new Lever(400,192,0,4,false);
	MASK=new Lever(5,325,0,24,false);      //matching coords with the optimum
	
	for(int i=0;i<6;++i) {
	    RELAX[i]=new Lever(100,245+15*i,0,6,false);
	    FACTOR[i]=new Lever(190,245+15*i,0,51,true);
	    FACTOR[i].val=50;
	}
	    RELAX[3]=new Lever(100,245+45,0,3,false);
	    RELAX[4]=new Lever(100,245+60,0,4,false);
	    RELAX[5].count=4;
	    
	    for(int i=0;i<6;++i) {
		for(int j=0;j<6;++j) {
		RELAX[j].on[i]=1;
		}
	    }
    }

    public double getFactor(int k) {
	return 1.0*FACTOR[k].val/(FACTOR[k].count-1);
    }
    

    public void setSliders() {
	 CS=new SelectColor(M,0,710,649,49);
	 PARAMETERS[0]=new EnhancedSlider(0,550,540,39,100,new Color(0,0,100),"(0) refresh time");
	 PARAMETERS[1]=new EnhancedSlider(0,590,540,39,100,new Color(0,0,200),"(1) step");
	 PARAMETERS[2]=new EnhancedSlider(0,630,540,39,100,new Color(0,0,100),"(2) coerce to presumed optimum");
	 PARAMETERS[3]=new EnhancedSlider(0,670,540,39,100,new Color(0,150,150),"(4) crossing penalty");
	 for(int i=0;i<4;++i) PARAMETERS[i].forceValue(1);
	 PARAMETERS[0].forceValue(1.0);
	 PARAMETERS[2].forceValue(32.0);
	 PARAMETERS[3].forceValue(128.0);
	 OFFSET=new Complex(0,0);
    }


    

    public void setPanels() {
	
	Color[] C0={new Color(60,140,255),
                   Color.white,
                   Color.white,
                   Color.black,
                   Color.white};
       
       Color[] C1={new Color(0,200,200),
                   Color.white,
                   Color.black,
                   Color.black,
                   Color.white};
       
       Color[] C2={new Color(100,0,200),
                   Color.white,
                   Color.white,
                   Color.white,
                   Color.white};
	

        String[] SimplifyString={"full",
				 "planar",
				 "planar + T",
                              "subspace"};
        int[] SimplifyState={0,0,1};
        SIMPLIFY=new ControlPanel(C0,SimplifyString,SimplifyState,3);
	SIMPLIFY.mode=2;

	
        String[] CoerceString={"none",
				 "graduated",
			       "coords",
			        "coerce"};
        int[] CoerceState={0,1,0};
        COERCE=new ControlPanel(C0,CoerceString,CoerceState,3);
	COERCE.mode=1;

	
        String[] TypeString={"1","2","type"};
        int[] TypeState={1,0};
        TYPE=new ControlPanel(C1,TypeString,TypeState,2);
	TYPE.mode=0;


	
        String[] LearnString={"random","best","biased","sign choice"};
        int[] LearnState={0,0,1};
        LEARN=new ControlPanel(C0,LearnString,LearnState,3);
	LEARN.mode=2;


	

        String[] ChoiceString={"geom 3","geom 4","geom 5","geom 2","geom 1","crossing","calc choice"};
        int[] ChoiceState={1,0,0,0,0,0,0};
        CHOICE=new ControlPanel(C0,ChoiceString,ChoiceState,6);
	CHOICE.mode=0;

	


        String[] DisplayString={"background",
				"perimeter",
				"bend0",
				"bend1",
				"bend2",
				"bend3",
				"bend4",
				"bend5",
				"display"};

       Color[] DisplayColor={
	   Color.white,
	   new Color(0,200,0,200),
	   new Color(0,0,0,70),
	   new Color(0,0,255,70),
	   new Color(255,0,0,70),
	   new Color(0,0,0,70),
	   new Color(0,0,0,70),
	   new Color(200,0,200),
	   new Color(0,0,0)};
       
       int[] DisplayState={1,1,1,1,1,1,1,1};
        DISPLAY=new ControlPanelColor(C2,DisplayString,DisplayState,8,DisplayColor);
    }

    public int[] getSigns() {
	int[] A={1,1,1,1,1};
	for(int i=0;i<4;++i) {
	    if(SIGNS.L[3-i].on==0) A[i]=-1;
	}
	return A;
    }

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      drawControls(g);
      drawMessage(g);
   }

    public void drawBG(Graphics2D g) {
	g.setColor(new Color(120,0,120));
      g.fillRect(0,0,getWidth(),getHeight()); 
    }

    public void drawMessage(Graphics2D g) {
	g.setColor(new Color(0,0,50));
	if(AN1.STATE==1) g.setColor(new Color(0,50,0));
	if(failState()==true) g.setColor(new Color(70,0,0));
	g.fillRect(5,340,610,205);
	g.setColor(Color.white);
	g.drawRect(5,340,610,205);
	g.setColor(Color.white);
	g.setFont(new Font("Helvetica",Font.PLAIN,20));
	for(int i=0;i<7;++i) g.drawString(MESSAGE[i][0],15,358+30*i);
	for(int i=0;i<7;++i) g.drawString(MESSAGE[i][1],335,358+30*i);
    }

    public boolean failState() {
	for(int i=0;i<6;++i) {
	    if(FACTOR[i].val>50) return true;
	}
	return false;
    }

    
    public void drawControls(Graphics2D g) { 
	if(AN1.halt==true)  GO.render(g,"go",12,4,new Color(0,180,0));
        else  STOP.render(g,"stop",12,4,new Color(200,0,0));
  
      if(COERCE.mode==2) MASK.render(g,"mask",new Color(0,150,0));

      drawMask(g);
      drawCrossingControl(g);
      for(int i=0;i<11;++i) INFO[i].infoRender(g);
      POP.render(g);
      COERCE.render2(g,5,70,80);
      SIMPLIFY.render2(g,5,0,80);
      LEARN.render2(g,5,140,80);
      DISPLAY.render(g,90,0,100);
      CHOICE.render2(g,5,225,80);
      CS.render(g);
      for(int i=0;i<4;++i) PARAMETERS[i].render(g);
     }



     public void drawMask(Graphics2D g) {

      for(int i=0;i<6;++i) {
	  String S="capacity mask";
	  if(i>0) S="";
          RELAX[i].render(g,S,new Color(50,100,255));
      }

      for(int i=0;i<6;++i) {
	  String S="relax factor";
	  if(i>0) S="";
          if(i<5) FACTOR[i].render2(g,S,new Color(0,0,200));
          if(i==5) FACTOR[i].render2(g,S,new Color(0,150,150));
      }
    }
    
    public void drawCrossingControl(Graphics2D g) {
      g.setColor(Color.black);
      g.fillRect(250,50,290,160);
      g.setColor(Color.white);
      g.drawRect(250,50,290,160);
      g.setFont(new Font("Helvetica",Font.PLAIN,14));
      g.drawString("crossing calculations (topology lemma)",260,67);
      g.setFont(new Font("Helvetica",Font.PLAIN,12));
      g.drawString("pitch range[",260,95);
      g.drawString("pitch range[",260,135);
      g.drawString("]\u00D7 \u03C0/120",490,95);
      g.drawString("]\u00D7 \u03C0/120",490,135);

      TYPE.render(g,495,155,40);
      for(int i=0;i<2;++i) {
	  for(int j=0;j<2;++j) {
	      PITCH[i][j].render(g,new Color(0,200,200),Color.white,Color.white);
	  }
      }
      
      CHOICE2.render(g,"view",new Color(200,0,200));
      CHOICE3.render2(g,"calculation choice",new Color(0,200,200));
      CROSS.render(g,"crossing focus",new Color(0,200,200));
      



    }

    public int[][] loopOrder() {
	int[][] A1={{0,2,4,6,8,10,1},{1,3,5,7,9,11,0},{1,1,-1,-1,-1,1,1}};
	return A1;
    }

    public int[] divider() {
	int[] B0={6,7};
	int[] B1={8,9};
	int[] B2={4,5};
	int k=CHOICE2.val;
	if(k==0) return B0;
	if(k==1) return B1;
	if(k==2) return B1;
	if(k==3) return B0;
	if(k==4) return B2;
	if(k==5) return B0;
	if(k==6) return B2;
	return null;
    }
    
        
    public void doAnimate() {
	if(AN1.halt==false) return;
	AN1=new Animate(this.M);
	new Thread(AN1).start();
    }

    public void setMasks(Point X) {
	for(int i=0;i<6;++i) {
	    RELAX[i].toggle(X);
	    FACTOR[i].process(X);
	}
    }

    public void chooseCalc(Point X) {
	CHOICE.toggle(X);
	int t=CHOICE2.process(X);
        Configs.assignColors(t,DISPLAY);
    }

    public void setTests(Point X) {
	   for(int i=0;i<2;++i) {
	       for(int j=0;j<2;++j) {
		   PITCH[i][j].modify(X);
	       }
	   }
    }

    public void crossingCalcChoice(Point X) {
	CROSS.toggle(X);
	int k=CHOICE3.process(X);
	if(k==-1) return;

	FACTOR[5].val=50;
	for(int i=0;i<5;++i) CHOICE.L[i].on=0;
	CHOICE.L[5].on=1;
	CHOICE2.val=5;
	for(int i=0;i<4;++i) CROSS.on[i]=0;
	PARAMETERS[3].forceValue(128);
	Configs.assignColors(5,DISPLAY);

	
	if(k==0) {
            TYPE.forceMode(0);
	    PITCH[0][0].val=-4;
	    PITCH[1][0].val=+10;
	    PITCH[0][1].val=40;
	    PITCH[1][1].val=40;
	}
	
	if(k==1) {
	    TYPE.forceMode(1);
	    PITCH[0][0].val=-4;
	    PITCH[1][0].val=+10;
	    PITCH[0][1].val=80;
	    PITCH[1][1].val=80;
	}
	
	if(k==2) {
	    TYPE.forceMode(0);
	    PITCH[0][0].val=+10;
	    PITCH[1][0].val=+10;
	    PITCH[0][1].val=40;
	    PITCH[1][1].val=66;
	    CROSS.on[3]=1;
	}
	
	if(k==3) {
	    TYPE.forceMode(1);
	    PITCH[0][0].val=+10;
	    PITCH[1][0].val=+10;
	    PITCH[0][1].val=56;
	    PITCH[1][1].val=80;
	    CROSS.on[3]=1;
	}
	
	if(k==4) {
	    TYPE.forceMode(1);
	    PITCH[0][0].val=+40;
	    PITCH[1][0].val=+40;
	    PITCH[0][1].val=80;
	    PITCH[1][1].val=124;
	    CROSS.on[1]=1;
	}
    }

    public void documentStuff(Point X) {

	int t=0;

	t=DISPLAY.getInfo(X);
	if(t==1) DocumentControl.display(M.D);

	t=SIMPLIFY.getInfo(X);
	if(t==1) DocumentControl.subspace(M.D);

	t=COERCE.getInfo(X);
	if(t==1) DocumentControl.coerce(M.D);

	t=LEARN.getInfo(X);
	if(t==1) DocumentControl.sign(M.D);

	t=CHOICE.getInfo(X);
	if(t==1) DocumentControl.choice(M.D);
	
	if(CS.INFO.inside(X)==1)  DocumentControl.color(M.D);

	if(INFO[0].inside(X)==1) DocumentControl.go(M.D);
	if(INFO[1].inside(X)==1) DocumentControl.popup(M.D);
	if(INFO[2].inside(X)==1) DocumentControl.crossing(M.D);
	if(INFO[3].inside(X)==1) DocumentControl.mask(M.D);
	if(INFO[4].inside(X)==1) DocumentControl.mask(M.D);
	if(INFO[5].inside(X)==1) DocumentControl.refresh(M.D);
	if(INFO[6].inside(X)==1) DocumentControl.step(M.D);
	if(INFO[7].inside(X)==1) DocumentControl.coerce2(M.D);
	if(INFO[8].inside(X)==1) DocumentControl.penalty(M.D);
	if(INFO[9].inside(X)==1) DocumentControl.output(M.D);
	if(INFO[10].inside(X)==1)  DocumentControl.view(M.D);

    }
    

    
    
    public void mouseClicked(MouseEvent e) {
        MouseData J=MouseData.process(e);
	   if(GO.inside(J.X)==1) doAnimate();
	   if(STOP.inside(J.X)==1) AN1.halt=true;
	   SIMPLIFY.switchMode(J.X);
	   chooseCalc(J.X);
	   COERCE.switchMode(J.X);
	   TYPE.switchMode(J.X);
	   LEARN.switchMode(J.X);
	   setTests(J.X);
	   MASK.toggle(J.X);
           setMasks(J.X);
	   CS.process(e);
	   DISPLAY.process(J.X,CS.C);
	   crossingCalcChoice(J.X);
	   POP.process(J.X);
	   documentStuff(J.X);
           M.repaint();
	   for(int i=0;i<4;++i) PARAMETERS[i].configure(J.X);
	  if(J.mode==1)  scaleUp(J.X,0);
          if(J.mode==3)  scaleUp(J.X,1);
          if(J.mode==2)  {
	  SOURCE=unTransform(J.X);
	}
	M.repaint();
	doTest();
    }
    

    public void mousePressed(MouseEvent e) {
	MouseData J=MouseData.process(e);
	   for(int i=0;i<4;++i) PARAMETERS[i].activate(J.X);
    }
    
     public void mouseReleased(MouseEvent e) {}
     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   
     public void mouseMoved(MouseEvent e) {}    
     public void mouseDragged(MouseEvent e) {
        MouseData J=MouseData.process(e);
	CS.process(e);
	for(int i=0;i<4;++i) PARAMETERS[i].configure(J.X);
	M.repaint();

     }
    
     public void keyPressed(KeyEvent e) {}
     public void keyReleased(KeyEvent e) {}
    public void keyTyped(KeyEvent e) {}
    
    public void doTest() {
	Vector A1=new Vector(0,0,0);
	Vector A2=new Vector(1,1,0);
	Vector B1=new Vector(1,0,0);
	Vector B2=new Vector(0,1,0);
	int[] mask={0,0,0,0};
	double X=CrossingTest.cross(A1,A2,B1,B2,mask);
	System.out.println(X);
    }


}

