
/**tests if two segments cross*/

public class CrossingTest {



    /**This piecewise rational function is positive exactly when the projected segment
       proj(A1 A2)   crosses the projected  segment proj(B1 B2). 
       Here proj is projection into the XY plane.*/
    
    public static double cross(Vector A1,Vector A2,Vector B1,Vector B2,int[] mask) {
	double[] a={A1.x[0],A2.x[0],B1.x[0],B2.x[0]};
	double[] b={A1.x[1],A2.x[1],B1.x[1],B2.x[1]};
	return cross(a,b,mask);
    }
    
    public static double cross(double[] a,double[] b,int[] mask) {
	double[] X=crossRaw(a,b);
	double min=1000;
	for(int i=0;i<4;++i) {
	    if((mask[i]==0)&&(min>X[i])) min=X[i];
	}
	if(min<0) min=0;
	min=2*min;
	return min;
    }

    public static double[] crossRaw(double[] a,double[] b) {
	double x1=triple(a,b,1,0,3);
	double x2=triple(a,b,1,2,3);
	double x3=triple(a,b,0,1,2);
	double x4=triple(a,b,0,3,2);
	double[] X={x1,x2,x3,x4};
	double y=quad(a,b,2,0,3,1);
	for(int i=0;i<4;++i) X[i]=X[i]/y;
	return X;
    }
    

    public static double quad(double[] a,double[] b,int i,int j,int k,int l) {
	double x=det(a,b,i,j)+det(a,b,j,k)+det(a,b,k,l)+det(a,b,l,i);
	return x;
    }

    public static double triple(double[] a,double[] b,int i,int j,int k) {
	double x=det(a,b,i,j)+det(a,b,j,k)+det(a,b,k,i);
	return x;
    }

    public static double det(double[] a,double[] b,int i,int j) {
	return a[i]*b[j]-a[j]*b[i];
    }
    
    

}


