import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**Documentation file*/


public class DocumentControl {

    public static void sendTo(DocumentCanvas D,String S) {
	try{
          D.setExplain(S);
          D.repaint();   
	  D.Y0=0;
          D.Y1=0;
	}
	catch(Exception e) {}
    }


    public static void display(DocumentCanvas D) {
	String S="tensegrity display";

	S=S+"\n\nThis control panel toggles the main display on the tensegrity window.  You can change the display of the signed segments (aka bends) in the tensegrity and also in the unsigned segments (aka perimeter).  The left column of buttons controls the color and the right row toggles the display.  To change a color to (say) blue, first select a blue color on the color selector and then press the relevant left button.  To get a feel for how the display works, turn off alll the features but one and then see what happens when you change its color.";
	sendTo(D,S);
    }

    public static void subspace(DocumentCanvas D) {
	String S="subspace selection";

	S=S+"\n\nAs we mention in the paper, we are looking for the minimum of some function on a finite dimensional tensegrity parameter space.  You can either search through the whole space or select some subspaces.  Here are the options.:";
	S=S+"\n\nfull: This is the entire space.";
	
	S=S+"\n\nplanar: This is the subspace of parameters which specify tensegrities that lie in the plane.  I think that, in all cases, the minima for the relevant capacity function lie in this subspace. Numerically, it seems that the relevant function achieves smaller values much more quickly when restricted to this subspace.";
	
	S=S+"\n\nplanar +T: This is the subspace of the planar space consisting of parameters which specify tensegrities having a touching T pattern.  What this means is that the endpoint of the horizontal signed segment is contained in the vertical signed segment. In terms of the offset vector (x,y) from the paper, we have x=0.  Since all the presumed minima lie in this subspace, it is a natural subspace to consider.";
	
	sendTo(D,S);
    }

    public static void coerce(DocumentCanvas D) {
	String S="variable coercion selection";

	S=S+"\n\nIn each of the tensegrity families associated with the Geometry Lemma calculations, there is a presumed minimizer, the tensegrity corresponding to the equilateral triangular Moebius band.   This control panel lets you explore parameters near this special point in two ways.  Here are the options.";
	
	S=S+"\n\nnone: This does not use the features.  For the calculations associated to the Topology Lemma, namely those associated with `crossing', you should use this option.";

	S=S+"\n\ngraduated:  This option lets you take an interpolation between a random point and the special point.  You use the 'coerce...' slider to determine the strength of the interpolation. The larger the number, the more you are pulling towards the special point.  Chapter 6 of the paper gives the precise formula.  If you set the coerce slider to a very large number, you can get a good feeling for what the special tensegrity looks like in all cases.";

	S=S+"\n\ncoords:  With this option, you can set variables of your choosing equal to the parameters for the special tensegrity.  When you choose this option, you see a row of green buttons on the control panel.  When you click on one of these buttons it turns it orange.  The program then sets this variable equal to the value from the special parameter.  You can choose as many variables as you like.";
	sendTo(D,S);
    }


    public static void sign(DocumentCanvas D) {
	String S="sign selection";

	S=S+"\n\nWe run a numerical optimization algorithm, based ona parameter T you can specify to taste.  The algorihm runs a hill-climbing algorithm for T seconds and then starts over with a new random start.  The parameter space is a finite union of cubes, each indexed by some choice of signs.   So, the algorithm bounces from component to component every T seconds.  There are two ways to specify the sign choices:";

	S=S+"\n\nrandom:  In this case, the computer makes a random sign choice each time.  Thus the computer randomly bounces from component to component.  This definitely covers all the cases, but it is inefficient.  Most of the time the computer is exploring irrelevant components.";

	S=S+"\n\nbest: Having run the program for a long time, I recognized which sign choice is the best.  With this option, the program always makes the preferred sign choice.  This is more efficient, but one might wonder if perhaps I have missed something.  You can play around with it yourself and convince yourself that the sign choice is correct.";

	S=S+"\n\nbiased: With this option, the program picks randomly 1/4 of the time and picks the presumed best choice 3/4 of the time.";

	sendTo(D,S);
    }



    public static void choice(DocumentCanvas D) {
	String S="calc choice";
	S=S+"\n\nThis control panel lets you select which calculations you do.  In all, there are 10 tensegrities.  5 of these come from the Geometry Lemma in the paper and 5 come from the Topology Lemma.  The first 5 buttons control the Geometry Lemma calculations.  The numbers indicate the correspondence between the calculations here and the ones in the paper.  The ordering is different here.  This is just a reflection of my own laziness.  You can run these concurrently.  The remaining button controls the 5 Topology Lemma calculations.   When you turn on this button, you then need to make a selection from the 'choice' row of buttons in the little black window.   This lets you run one of the 5 Topology Lemma calculations along with any of the Geometry Lemma calculations you would like to run.  I recommend running the Topology Lemma calculation on its own, without any of the Geometry Lemma calculations selected. This will make it more clear that you are monitoring the right thing.";
	sendTo(D,S);
    }



    public static void color(DocumentCanvas D) {
	String S="color selector";
	S=S+"\n\nYou can either choose a preset color or you can specify the RGB\u03B1 coordinates of the color.  Here \u03B1 is the transparancy.  Once you select a color, you can use the first column of buttons on the display panel to change the colors in the tensegrity window.";
	sendTo(D,S);
    }
    
    public static void go(DocumentCanvas D) {
	String S="go/stop button";
	S=S+"\n\nWhen you press the go button it launches the calculations and the stop button appears.  When you press the stop button it stops the calculation and the go button reappears.  The calculations also stop if one of them goes negative. You can arrange this by setting the capacity mask to (0,...,0) for instance.";
	sendTo(D,S);
    }

    public static void view(DocumentCanvas D) {
	String S="view choice";
	
	S=S+"\n\nWhen you run more than one calculation at the same time, you use this column of buttons to focus on one of the calculations.  If you select the first button, then the computation sends data to the trapezoid and T pattern windows based on the first calculation.  Likewise for the other calculations.   Regardless of which of these buttons you have selected, the program sends data to these auxiliary windows whenever it reaches a new record minimum.";

	S=S+"\n\nThe view window has one more function. When you click on a view button, the program automatically resets the colors on the display window, so as to highlight the structure of the tensetrity.";
	
	sendTo(D,S);
    }


    public static void popup(DocumentCanvas D) {
	String S="popup windows";
	S=S+"\n\nWhen you press these buttons, new windows pop up. One of these windows is the information window you are now reading.  The other two windows monitor the output of the calculations.  The trapezoid window shows the minimal planar realization of the tensegrity, in the sense discussed in Chapter 3 of the paper.  The T-pattern window displays the pair (b,t), where b and t are the slopes of the bends in the trapezoid window corresponding to the T-pattern.  The left vertex of the quadrilateral in the T-pattern window corresponds to the presumed minimizer, the equilateral triangle example.";

	S=S+"\n\nThe popup windows are a bit delicate. If you mistakenly launch the same one more than once, neither copy will function properly. In this case, you should kill all open instances of the popup window and relaunch a single new one.";
	
	sendTo(D,S);
    }

    public static void crossing(DocumentCanvas D) {
	String S="crossing calculation controls";
	S=S+"\n\nThis black window controls the 5 calculations associated to the Topology Lemma in the paper.  Here are the individual features:";

	S=S+"\n\ncalculation choice: This row of 5 squares lets you select which of the 5 calculations you want to perform.  When you press these squares, the parameters for the calculation are automatically set.  You can run the calculation as is, or you can modify the calculation using the remaining controls inside this window.  The rest of the controls are the modifiers.";

	S=S+"\n\ncrossing focus:  These specify the index (or indices) for the modified crossing penalty function discussed at the end of Chapter 3 in the paper.  We only discussed the case when 0 or 1 of the indices is turned on, but you have the option of turning on more.  You can experiment with turning these on and off and convince yourself that we have preset them correctly.  We discuss this in the paper, in a remark at the end of Chapter 4.";

	S=S+"\n\ntype:  There are 2 types of tensegrities we consider.  All of them are cyclic stacked tensetrities (as defined in the paper) having 4 quadrilaterals.  In Type 1, the two signed edges in the T pattern are edge 1 and edge 4.  In type 2, the two edges are edge 1 and edge 3.  In terms of the planar realization we can say it like this: In type 1, both of the extra bends lie in the same component of the paper Moebius band minus the T-pattern.  In type 2, one extra bend lies in each component.";

	S=S+"\n\narrow keys:  There are two rows of arrow keys.  Each row controls the pitch range for one of the two extra signed edges.  If the number displayed is k then the corresponding angle is (k/120)\u03C0.  Thus, if the number is 40, the angle is /u03C0/3.   You can click on these arrows to change the pitch ranges.";
	
	sendTo(D,S);
    }


    

    public static void mask(DocumentCanvas D) {
	String S="mask buttons";
	S=S+"\n\nIn the paper I discussed a more complicated capacity function that is based on a vector u which I call a mask. Call a vector binary if it has all coordinates equal to 0 or 1.  The first rows of buttons lets you choose, for each calculation, a binary vector. Call a vector special if it has the form\n\n(k/50)v\n\nwhere k=0,...,50 and v is a binary vector.  The second rows of buttons lets you choose the integer k.  So, using all these buttons together you can choose a special vector as a mask.";

	S=S+"\n\nWhen you choose a special vector for a mask and run the program, the program tries to minimize the corresponding capacity.  As soon as it finds a point whose capacity is less than the capacity of the equilateral example, the program automatically increments the value k.  Once the value k reaches 51, the program halts and notes the failure.  The reason is that if k>50 then the corresponding capacity is not necessarily less than the plain capacity.  The plain capacity uses the mask (1,...,1) in all cases.  The added flexibility in our calculations gives some feel for which expressions in the capacity function are important.";
	
	sendTo(D,S);
    }



    public static void refresh(DocumentCanvas D) {
	String S="refresh time slider";
	
	S=S+"\n\nYou can operate this slider in one of two ways.  Either you can drag the position marker along the big part of the slider or you can use the arrow keys to change the value by a factor of 2.  When you press the thin rectangle next to the arrow keys, it resets the position value to the center.";

	S=S+"\n\nOur numerical optimization resets after T units of time, choosing a different initial start.   This slider lets you choose the value of T.  When T is small, the algorithm is fairly close to a random sampler.  When T is large the algorithm is close to the classic hill climbing algorithm.  You can adjust the time on the fly.  This lets you change the character of the optimization algorithm in such a way as to interpolate between these two extremes.";

	sendTo(D,S);
    }


    public static void step(DocumentCanvas D) {
	String S="step size slider";

	S=S+"\n\nYou can operate this slider in one of two ways.  Either you can drag the position marker along the big part of the slider or you can use the arrow keys to change the value by a factor of 2.  When you press the thin rectangle next to the arrow keys, it resets the position value to the center.";

	
	S=S+"\n\nOur numerical optimization algorithm works as follows.  We start with a random point and then move to a nearby random point if this move lowers the function we are trying to minimizer.  This slider controls the size of the random step we take. I am not sure exactly which value gives the best algorithm.  You just have to play around with it.";

	sendTo(D,S);
    }
    
    
    public static void coerce2(DocumentCanvas D) {
	String S="coercion slider";

	S=S+"\n\nYou can operate this slider in one of two ways.  Either you can drag the position marker along the big part of the slider or you can use the arrow keys to change the value by a factor of 2.  When you press the thin rectangle next to the arrow keys, it resets the position value to the center.";
	
	S=S+"\n\nIn each of the tensegrity families associated with the Geometry Lemma calculations, there is a presumed minimizer, the tensegrity corresponding to the equilateral triangular Moebius band.  This slider works when the 'coerce to optimum' option is set to 'graduated'.  This option lets you take an interpolation between a random point and the special point.  You use this slider to determine the strength of the interpolation. The larger the number, the more you are pulling towards the special point.  Chapter 6 of the paper gives the precise formula.  If you set the coerce slider to a very large number, you can get a good feeling for what the special tensegrity looks like in all cases.";

	sendTo(D,S);
    }


    public static void penalty(DocumentCanvas D) {
	String S="crossing penalty slider";

	S=S+"\n\nYou can operate this slider in one of two ways.  Either you can drag the position marker along the big part of the slider or you can use the arrow keys to change the value by a factor of 2.  When you press the thin rectangle next to the arrow keys, it resets the position value to the center.";

	
	S=S+"\n\nThis slider determines the coefficient of the crossing penalty function, as discussed at the end of Chapter 3 of the paper. The larger you make this variable, the more the computer is forced to ignore the configurations in which the two relevant segments cross.  We are only interested in the configs where the two relevant segments do not cross, so there is no harm in making this variable very large. If you make the variable very small, then the calculations will fail.";
	sendTo(D,S);
    }
    
    public static void output(DocumentCanvas D) {
	String S="numerical output";

	S=S+"\n\nThis window displays the numerical output of the calculations.  Each row gives the output for the corresponding calculation.  The first number gives the local minimum.  This is the minimum value achieved during each cycle of the optimization algorithm.  The right number gives the global minimum.  This is the minimum value achieved over all cycles.  So, the left number bounces up and down and the right one steadily decreases.";

	S=S+"\n\nWhat the number shows is the minimum capacity minus the capacity of the tensegrity corresponding to the equilateral triangle example.  In all but one case we are subtracting of 2\u221A3.  In the one remaining case, corresponding to the `geom1' calculation, we are subtracting off \u221A3.  This exceptional case corresponds to the B family in the calculations discussed in Chapter 5 of the paper. The point of our calculations is that the displayed numbers remain positive.";
	
	sendTo(D,S);
    }
    
    
}


