import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**Documentation file*/


public class DocumentIntro {

    public DocumentIntro() {}


    public static void setup(DocumentCanvas D) {
    
	String S="Calculations for the Moebius Band Paper";
        S=S+"\nby Rich Schwartz";


	S=S+"\n\nPURPOSE:";
        S=S+"\n\nThe purpose of this program is to do numerical simulations with the calculations from my paper about the optimal Moebius band and tensegrities.  This text will explain the operation of the program.  There is more text than fits on the screen.  You can drag the text down with the mouse. You can also reset the position of text or change the font size using the controls at the top of this window. ";

	S=S+"\n\nMOUSE:";
	S=S+"\n\nThis program is best run using a 3 button mouse.  The control panel (the one with all the buttons) just requires a 1 button mouse and occasionally the keyboard.  The other windows use the 3 buttons.  In general, a left and right click will scale the picture about the click point and a middle point will select a new source point on the window.  I have added in keyboard shortcuts in case you do not have a 3 button mouse.  The keys z,x,c, simulate the 3 kinds of clicks.  In general, you have to click on a window in order to activate the keyboard shortcuts";

	S=S+"\n\nQUESTION BOXES:";
	S=S+"\n\nMany of the controls of this program have little black question boxes beside them. If you click on these question boxes, you can learn more about the function of the controls.  If you click on one of the question boxes, the text here will be replaced.  You can return this text here by clicking on the question box at the top of this window.";

	
	S=S+"\n\nOVERVIEW";
	S=S+"\n\nThis program has 5 windows. Here is their description:";
	S=S+"\n\nText window.  This is what you are reading.";
	S=S+"\n\nControl Window.  This is the big multi-colored window.  This window allows you to choose the calculation you are doing, and modify the calculation and display in various ways.";
	S=S+"\n\nTensegrity window:  This window draws a planar projection of the tensegrity image. (Atcually, at the moment, we are only considering planar tensegrities.  The reasons for this (besides laziness) are explained in chapter 6 of the paper.";
	S=S+"\n\ntrapezoid window: This window reconstructs the minimal tensegrity corresponding to the tensegrity image shown in the space window.  This window is not visible when you launch the program. You need to click the `trap.' button on the control window to launch it.";
	S=S+"\n\nT pattern window: This window keeps track of the pair (b,t).  If the uniqueness part of the Geometry Lemma calculations are true then the point recorded in this window as the calculations run should converge to the bottom left vertex.";
	S=S+"\n\nConcerning the popup windows, you should not bring up the same window twice. This will cause neither to work.  If you do this accidentally, kill both of them and bring up a new one.  This should fix it.";
	S=S+"\n\nYou can rescale all the windows except the control panel.";

	S=S+"\n\nGENERAL OPERATIONS:";
	S=S+"\n\nUsing the `calc choice' window you can select which of the calculations you run.  The first 5 options correspond to the 5 calculations which go into the Geometry Lemma.  The last option lets you run, one at a time, any of the 5 calculations which go into the Topology Lemma.  You can use the left lever in the 'crossing calculations' window to select which of these 5 calculations you want to perform.  When you press go, all the calculations you have selected will run concurrently.  You can modfy the calculations in various ways.";

	
	S=S+"\n\nA GEOMETRY LEMMA CALCULATIONS:";

	S=S+"\n\nWhen the program opens, it is all ready to do one of the geometry calculations.  Just press go.  You will see changing numbers appear on the top line of the dark green numerical display.  The left number reports on the local minimum value and the right number reports on the global minimum value.  The local minimum value is just the minimum value computed every 4 seconds, every time the optimization routine refreshes.  The global minimum value is the overall minimum.  What we are displaying is the capacity minus 2\u221A3. If you open up the trapezoid window you can see the planar realization o the tensegrity.  The capacity of the tensegrity is, in all but one case, sum of the lengths of the vertical sides of the parallelogram in Figure.  In the one exceptional case (corresponding to the family B in the paper) the capacity is the sum of the lengths of the vertical sides of the shaded trapezoid.";
	S=S+"\n\nYou can make the calculation more efficient by setting the `sign choice' option to 'preferred'.  This picks out the sign choice which is (obviously) empirically the best one.";
	S=S+"\n\nYou do other geometry calculations by turning on some of the buttons on the 'calc choice' button.  The row of squares called 'view' indicates which data is sent to the trapezoid window.  If you are interested in a particular calculation, you should set this control accordingly.";
	
	S=S+"\n\nA TOPOLOGY LEMMA CALCULATION:";

	S=S+"\n\nHere I will explain how to do one of the Topology Lemma calculations. The others are similar.";
	S=S+"\n\n0. Click somewhere on the magenta part of the window to make sure that the window is fully rendered.";
	S=S+"\n\n1. On the `calculation choice' control panel inside the small black window on the control panel, click the leftmost button.";
	S=S+"\n\n2. On the 'coerce to optimum' control panel, select the 'none' option.";
	S=S+"\n\n3. Press go.";
	S=S+"\n\nYou will get the same kind of information you got from the Geometry Lemma calculations.   You must do the 5 topology lemma calculations separately. The `calculation choice' bar determines which calculation is being done.  This is a slightly annoying situation.  I may update the program so that you can do all the calculations at the same time.";

	
	S=S+"\n\nA MODIFIERS";
	S=S+"\n\nYou can modify the calculations in various ways by using the control panel.  If you click the question boxes on the control panels, you can learn about how to make modifications.";
	
        D.setExplain(S);
        D.repaint();   
	D.Y0=0;
        D.Y1=0;
    }
}

