import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;


public class Lever {
    ListenSquare[] L=new ListenSquare[200];
    int[] on=new int[200];
    int val;
    int x,y;
    int count;

    public Lever(int x,int y,int value,int c,boolean thin) {
    this.x=x;
    this.y=y;
    this.val=value;
    this.count=c;
    int W=12;
    if(thin==true) W=8;
    for(int i=0;i<=count;++i) {
          L[i]=new ListenSquare(x+W*i,y,W,12,null);
          L[i].on=1;
    }
  }

    public void render(Graphics2D g,String S,Color C) {
	for(int i=0;i<count;++i) {
	    if(on[i]==1) L[i].render(g,Color.orange);
	    if(on[i]==0) L[i].render(g,C);
	}
	//	L[count].infoRender(g); 
        g.setFont(new Font("Helvetica",Font.PLAIN,11));
        g.drawString(S,x,y-5);
    }

    public void render2(Graphics2D g,String S,Color C) {
	for(int i=0;i<count;++i) {
	    if(i==val) L[i].renderSmooth(g,Color.orange,Color.orange);
	    if(i!=val) L[i].renderSmooth(g,C,new Color(0,0,0,100));
	}
	//	L[count].infoRender(g);
	g.setColor(Color.white);
        g.setFont(new Font("Helvetica",Font.PLAIN,11));
        g.drawString(S,x,y-5);
    }


    public int process(Point X) {
	if(L[count].inside(X)==1) return(99);
	for(int i=0;i<count;++i) {
	    if(L[i].inside(X)==1) {
            val=i;
	    return(i);
	    }
	}
	return(-1);
    }

    public int total() {
	int c=0;
	for(int i=0;i<count;++i) c=c+on[i];
	return(c);
    }

    public int toggle(Point X) {
	if(L[count].inside(X)==1) return(99);
	for(int i=0;i<count;++i) {
	    if(L[i].inside(X)==1) {
		on[i]=1-on[i];
		return(i);
	    }
	}
	return(-1);
    }

    public int[] onValues() {
	int n=this.total();
	int[] N=new int[n];
	int c=0;
	for(int i=0;i<count;++i) {
	    if(on[i]==1) {
             N[c]=i;
	     ++c;
	    }
	}
	return(N);
    }



    public void turnOn() {
	for(int i=0;i<50;++i) on[i]=1;
    }

    public void turnOff() {
	for(int i=0;i<50;++i) on[i]=0;
    }


    public int isUsed(Point X) {
	for(int i=0;i<count;++i) {
	    if(L[i].inside(X)==1) return(i);
	}
	return(-1);
    }


}
