import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class PictureCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener {
    Manager M;
    Complex[] TEN=new Complex[14];
    double[] A=new double[5];

     public PictureCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 setScales(50,550,150);
     }


   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      drawTens(g);
   }

    

    public void drawTens(Graphics2D g) {
	Path2D.Double p=new Path2D.Double();
	int[] B=M.C.divider();
	int k=M.C.CHOICE2.val;
	double[] mask=new double[6];
	for(int i=0;i<6;++i) mask[i]=1.0*M.C.RELAX[k].on[i]*M.C.getFactor(k);
	TEN=Tensegrity.tensegrity(M.S.SIGN,M.S.Z,mask);
	if(TEN==null) return;


	Complex[] T0={TEN[0],TEN[1],TEN[B[1]],TEN[B[0]]};
	PolygonWrapper X=new PolygonWrapper(4,T0);
	p=X.toPath();
	p=transform(p);
	g.setColor(new Color(220,220,220));
	g.fill(p);

	int N=TEN.length;
	
	for(int i=0;i<N/2;++i) {
	    p.reset();
	    p.moveTo(TEN[2*i+0].x,TEN[2*i+0].y);
	    p.lineTo(TEN[2*i+1].x,TEN[2*i+1].y);
	    p=transform(p);
	    g.setColor(M.C.DISPLAY.M[1+i].C);
	    g.draw(p);
	}

	for(int i=0;i<N/2-1;++i) {
	    p.reset();
	    p.moveTo(TEN[2*i+0].x,TEN[2*i+0].y);
	    p.lineTo(TEN[2*i+2].x,TEN[2*i+2].y);
	    p.moveTo(TEN[2*i+1].x,TEN[2*i+1].y);
	    p.lineTo(TEN[2*i+3].x,TEN[2*i+3].y);
	    p=transform(p);
	    g.setColor(M.C.DISPLAY.M[1].C);
	    g.draw(p);
	}

    }

    
    public void drawBG(Graphics2D g) {
	g.setColor(Color.white);
        g.fillRect(0,0,getWidth(),getHeight());
	Path2D.Double p=new Path2D.Double();
    }

    
    public void mousePressed(MouseEvent e) { }
    public void mouseClicked(MouseEvent e) { 
	MouseData J=MouseData.process(e);
        if(J.mode==1)  scaleUp(J.X,0);
        if(J.mode==3)  scaleUp(J.X,1);
	if(J.mode==2) SOURCE=unTransform(J.X);
	SOURCE.print();
	repaint();
    }
     public void mouseReleased(MouseEvent e) {	 
     }

     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   

     public void mouseMoved(MouseEvent e) {}   
     public void mouseDragged(MouseEvent e) {
     }


}

