import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class SpaceCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener {
    Manager M;
    Complex[] Z=new Complex[12];
    int[] SIGN=new int[7];

     public SpaceCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 setScales(360,250,200);
	 double t=5*Math.PI/12;
	 Z=initExample();
	 for(int i=0;i<7;++i) SIGN[i]=1;
     }


    public Complex[] initExample() {
	Complex[] W=new Complex[12];
	double m=1/Math.sqrt(3);
	 W[0]=new Complex(0,0);
	 W[1]=new Complex(-1,0);

	 W[2]=new Complex(0,Math.tan(Math.PI/12));
	 W[3]=new Complex(-1,0);

	 W[4]=new Complex(0,m);
	 W[5]=new Complex(0,-m);

	 W[6]=new Complex(0,m);
	 W[7]=new Complex(0,-m);

	 W[8]=new Complex(0,m);
	 W[9]=new Complex(0,-m);	 

	 W[10]=new Complex(0,-Math.tan(Math.PI/12));
	 W[11]=new Complex(-1,0);


	 return W;
    }

    
   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      drawTensegrity(g);
   }

    public void drawBG(Graphics2D g) {
	g.setColor(M.C.DISPLAY.M[0].C);
        g.fillRect(0,0,getWidth(),getHeight());
	Path2D.Double p=new Path2D.Double();
    }

    public void drawSegment(Graphics2D g,Complex a,Complex b,Color C) {
	drawSegment(g,a,b,C,1);
    }
    
    public void drawSegment(Graphics2D g,Complex a,Complex b,Color C,int thick) {
	Path2D.Double p=new Path2D.Double();
	p.moveTo(a.x,a.y);
	p.lineTo(b.x,b.y);
	p=transform(p);
	g.setColor(C);
	g.setStroke(new BasicStroke(thick));
	g.draw(p);
	g.setStroke(new BasicStroke(1));
    }

    public void drawTensegrity(Graphics2D g) {
	drawBendImages(g);
	drawCycle(g);
    }

    
    public void drawBendImages(Graphics2D g) {
	int N=Z.length;
	try{
	Path2D.Double p=new Path2D.Double();
	fillPoint(g,new Complex(0,0),.003,Color.yellow,32);
	   for(int i=0;i<N;++i) {
	       if(M.C.DISPLAY.L[i+2].on==1) {
                   drawSegment(g,Z[2*i],Z[2*i+1],M.C.DISPLAY.M[i+2].C);
	       }
	   }
	}
	catch(Exception e) {}
    }
    
    public void drawCycle(Graphics2D g) {
	if(M.C.DISPLAY.L[1].on==0) return;
	Color COL=M.C.DISPLAY.M[1].C;
	int choice=M.C.CHOICE2.val;
	int[][] A=Tensegrity.quadPattern(7);
	if(choice>=3) A=Tensegrity.quadPattern(5);
        drawSegments(g,A,COL);
    }
    
    public void drawSegments(Graphics2D g,int[][] A,Color C) {
	for(int i=0;i<A.length;++i) {
	    drawSegments(g,A[i],C);
	}
    }

    public void drawSegments(Graphics2D g,int[] A,Color C) {
	for(int i=0;i<A.length-1;++i) {
	    try{drawSegment(g,Z[A[i]],Z[A[i+1]],C);}
	    catch(Exception e) {}
	}
    }

    
    public void mousePressed(MouseEvent e) { }
    public void mouseClicked(MouseEvent e) { 
	MouseData J=MouseData.process(e);
        if(J.mode==1)  scaleUp(J.X,0);
        if(J.mode==3)  scaleUp(J.X,1);
	if(J.mode==2) {
	     SOURCE=unTransform(J.X);
	}
	repaint();
	M.repaint();
    }
     public void mouseReleased(MouseEvent e) {	 
     }

     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   

     public void mouseMoved(MouseEvent e) {}   
    public void mouseDragged(MouseEvent e) {}
    

}

