import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**This class generates a random tensegrity.
   There are 10 variables.*/

public class Tensegrity {

    public static int[][] quadPattern(int k) {
	int[][] A=new int[2][k];
	for(int i=0;i<k;++i) {
	    A[0][i]=2*i;
	    A[1][i]=2*i+1;
	}
	A[0][k-1]=1;
	A[1][k-1]=0;
	return A;
    }
        
    /**This routine works with the plana projections*/
    public static Complex[] tensegrity(int[] sign,Complex[] Z,double[] mask) {
	Vector[] V=new Vector[Z.length];
	for(int i=0;i<V.length;++i) {
	     V[i]=new Vector(Z[i].x,Z[i].y,0);
	}
	return tensegrity(sign,V,mask);
    }


    /**This is the fully 3D version*/
    public static Complex[] tensegrity(int[] sign,Vector[] V,double[] mask) {
	double[][] GEOM=tensegrityData(sign,V);
	int N=GEOM.length;
	double[] L=new double[N];
	double[] R=new double[N];
	for(int j=0;j<N;++j) {
	    L[j]=(GEOM[j][0]+Math.abs(GEOM[j][1])*mask[j]+GEOM[j][2])/2;
            R[j]=L[j]-GEOM[j][2];
	}

	Complex[] T=new Complex[2*N+2];
	T[1]=new Complex(0,0);
	double s=Vector.dist(V[0],V[1]);
	s=Math.sqrt(s*s-1);
	T[0]=new Complex(1,s);

	for(int i=1;i<N+1;++i) {
            T[2*i+0]=Complex.plus(T[2*i-2],new Complex(0,R[i-1]));
            T[2*i+1]=Complex.plus(T[2*i-1],new Complex(0,L[i-1]));
	}
	return T;	
    }



    /**This is the fully 3D version*/
    public static double[][] tensegrityData(int[] sign,Vector[] V) {
	int N=V.length/2;
	double[][] GEOM=new double[N][3];
        double[] s=new double[N+1];
	int[][] Q=quadPattern(N+1);

	for(int i=0;i<N+1;++i) {
	    double B=Vector.dist(V[Q[0][i]],V[Q[1][i]]);
	    if(B<1) return null;
	    s[i]=sign[i]*Math.sqrt(B*B-1);
	}

	for(int j=0;j<N;++j) {
            int i0=Q[0][j];
	    int i1=Q[1][j];
	    int i2=Q[0][j+1];
	    int i3=Q[1][j+1];
	    double r=Vector.dist(V[i0],V[i2]);
	    double l=Vector.dist(V[i1],V[i3]);
	    double d=s[j]-s[j+1];
	    GEOM[j][0]=l+r;
	    GEOM[j][1]=(r+d)-l;
	    GEOM[j][2]=d;
	}
	return GEOM;
    }

    /*last variable is not used currently*/

    public static double capacity(int[] sign,Vector[] V,int choice,double[] mask) {
	double[][] GEOM=tensegrityData(sign,V);
	if(GEOM==null) return 999;
	double sum=0;
	double xtra=0;
	int L=GEOM.length;
	int B=2;
	if(choice==3) {--L;--B;}
	for(int i=0;i<L;++i) {
	    sum=sum+GEOM[i][0];
	    double e=Math.abs(GEOM[i][1]);
	    xtra=xtra+mask[i]*e;
	}
	sum=sum+xtra;
	return sum-B*Math.sqrt(3);
    }

    public static double maskFactor(int[] sign,Vector[] V,int choice,int[] on) {
	double[][] GEOM=tensegrityData(sign,V);
	if(GEOM==null) return 999;
	double sum=0;
	double xtra=0;
	int L=GEOM.length;
	int B=2;
	if(choice==3) {--L;--B;}
	for(int i=0;i<L;++i) {
	    sum=sum+GEOM[i][0];
	    double e=Math.abs(GEOM[i][1]);
	    xtra=xtra+on[i]*e;
	}
	if(sum>B*Math.sqrt(3)) return 0;
	double t=(B*Math.sqrt(3)-sum)/xtra;
	return t;
    }



    /**This tests for crossing*/

    public static double crossingEnhancement(Vector[] V,int choice,int[] mask) {
	if(choice==0) return CrossingTest.cross(V[2],V[3],V[4],V[5],mask);
	if(choice==1) return CrossingTest.cross(V[2],V[3],V[6],V[7],mask);
	return 0;
    }
	

    

    /**These two routines are configuration dependent. The rest work
       for all the choices*/

    /**Converts a random point into bend data*/

    public static double[] bends0(double[] r) {
	double x=(Math.sqrt(27)-Math.sqrt(11))/4;
	double[] A=new double[6];
	A[0]=interpolate(0,x,r[0]);
	A[1]=interpolate(0,1,r[1]);
	A[2]=interpolate(0,-1,r[2]);
	A[3]=specialYCoord(A[0],r[3]);
	A[4]=interpolate(0,-1,r[4]);
	A[5]=interpolate(0,1,r[5]);
	return A;
    }

    public static double[] bends1(double[] r) {
	double x=(Math.sqrt(27)-Math.sqrt(11))/4;
	double[] A=new double[6];
	A[0]=interpolate(0,x,r[0]);
	A[1]=interpolate(0,1,r[1]);
	A[2]=interpolate(0,-1,r[2]);
	A[3]=interpolate(0,-1,r[4]);
	A[4]=specialYCoord(A[0],r[3]);
	A[5]=interpolate(0,1,r[5]);
	return A;
    }
    
    public static double[] bends3(double[] r) {
	double x=(Math.sqrt(27)-Math.sqrt(11))/4;
	double[] A=new double[4];
	A[0]=interpolate(0,x,r[0]);
	A[1]=interpolate(0,1,r[1]);
	A[2]=interpolate(0,-1,r[2]);
	A[3]=specialYCoord(A[0],r[3]);
	return A;
    }

    public static double[] bends4(double[] r) {
	double x=(Math.sqrt(27)-Math.sqrt(11))/4;
	double[] A=new double[4];
	A[0]=interpolate(0,x,r[0]);
	A[1]=interpolate(-1,1,r[1]);
	A[2]=specialYCoord(A[0],r[2]);
	A[3]=interpolate(0,1,r[3]);
	return A;
    }

    public static double[] bends5(double[] r) {
	double x=(Math.sqrt(27)-Math.sqrt(11))/4;
	double[] A=new double[4];
	A[0]=interpolate(0,x,r[0]);
	A[1]=interpolate(0,1,r[1]);
	A[2]=interpolate(0,-1,r[2]);
	A[3]=specialYCoord(A[0],r[3]);
	return A;
    }

    public static double[] bends6(double[] r) {
	double x=(Math.sqrt(27)-Math.sqrt(11))/4;
	double[] A=new double[4];
	A[0]=interpolate(0,x,r[0]);
	A[1]=interpolate(0,1,r[1]);
	A[2]=specialYCoord(A[0],r[2]);
	A[3]=interpolate(0,-1,r[3]);
	return A;
    }


    


    public static double specialYCoord(double a,double r) {
	double y1=(2.0/3)*a-1.0/Math.sqrt(3);
	double y2=(2.0/3)*a-1.0/2;
	double y3=(4.0/3)*a-1.0/Math.sqrt(3);
	double y4=Math.min(y2,y3);
	double y=interpolate(y1,y4,r);
	return y;
    }


    
    /**This gets the pitches*/

    public static double[] pitch0(double[] r) {
	double[] A={0,0,0,0,0,0};
	double a=Math.PI/30;
	A[0]=0;
	A[1]=+Math.PI/12;
	A[2]=interpolate(4*Math.PI/12,6*Math.PI/12+a,r[0]);
	A[3]=Math.PI/2;
	A[4]=interpolate(6*Math.PI/12-a,8*Math.PI/12,r[1]);
	A[5]=-Math.PI/12+Math.PI;
	return A;
    }

    public static double[] pitch1(double[] r) {
	double[] A={0,0,0,0,0,0};
	A[0]=0;
	A[1]=+Math.PI/12;
	double a=Math.PI/30;
	A[2]=interpolate(4*Math.PI/12,6*Math.PI/12+a,r[0]);
	A[3]=interpolate(6*Math.PI/12-a,8*Math.PI/12,r[1]);
	A[4]=Math.PI/2;
	A[5]=-Math.PI/12+Math.PI;
	return A;
    }

    public static double[] pitch3(double[] r) {
	double[] A={0,0,0,0};
	A[0]=0;
	double a=Math.PI/30;
	A[1]=+Math.PI/12;
	A[2]=interpolate(4*Math.PI/12,6*Math.PI/12+a,r[0]);
	A[3]=Math.PI/2;
	return A;
    }

    public static double[] pitch4(double[] r) {
	double[] A={0,0,0,0};
	A[0]=0;
	double a=Math.PI/30;
	A[1]=Math.PI+4*Math.PI/12;
	A[2]=Math.PI+Math.PI/2;
	A[3]=interpolate(8*Math.PI/12,12*Math.PI/12+a,r[0]);
	return A;
    }
    
    public static double[] pitch5(double[] r,int[][] a) {
	double[] A={0,0,0,0};
	double[][] p=integersToAngles(a);
	A[0]=0;
	A[1]=interpolate(p[0][0],p[0][1],r[0]);
	A[2]=interpolate(p[1][0],p[1][1],r[0]);
	A[3]=Math.PI/2;
	return A;
    }
    

    public static double[] pitch6(double[] r,int[][] a) {
	double[] A={0,0,0,0};
	double[][] p=integersToAngles(a);
	A[0]=0;
	A[1]=interpolate(p[0][0],p[0][1],r[0]);
	A[3]=interpolate(p[1][0],p[1][1],r[0]);
	A[2]=Math.PI/2;
	return A;
    }


    /**This is used for the crossing calculations*/
    
    public static double[][] integersToAngles(int[][] a) {

	double[][] p=new double[2][2];
	for(int i=0;i<2;++i) {
	    for(int j=0;j<2;++j) {
		p[i][j]=Math.PI*a[i][j]/120;
	    }
	}
	return p;
    }
    

    /**this gets the offsets for the T-pattern**/

    public static double[] offset(double[] r) {
	double[] A=new double[2];
	A[0]=interpolate(0,1.0/18,r[0]);
	A[1]=interpolate(-1.0/30,1.0/30,r[1]);
	return A;
    }

    
    /**unconstrained center*/
    public static double[] center(double[] r) {
	double[] c=new double[2];
	c[0]=interpolate(-1,1,r[0]);
	c[1]=interpolate(-1,1,r[1]);
	return c;
    }

    public static double[] center(double[] r,double x,double y,double t) {
	double[] c=new double[2];
	c[0]=interpolate(x-t,x+t,r[0]);
	c[1]=interpolate(y-t,y+t,r[1]);
	return c;
    }
    

    /**constrained center: segment b goes through the endpoint of segment a.
       The sign determines which endpoint*/
    
    
    public static double[] center(int sign,int b,int a,double[] cen,double[] bend,double[] pitch,double[] r) {
	double[] c=new double[2];
	int N=bend.length;
	double[] length=new double[N];
	for(int i=0;i<N;++i)  length[i]=Math.sqrt(1+bend[i]*bend[i]);

	double xb=length[b]*Math.cos(pitch[b])/2;  
	double yb=length[b]*Math.sin(pitch[b])/2;

	double xa=sign*length[a]*Math.cos(pitch[a])/2; 
	double ya=sign*length[a]*Math.sin(pitch[a])/2;

	double x=cen[0]+xa;
	double y=cen[1]+ya;

	c[0]=x+interpolate(-xb,xb,r[0]);
	c[1]=y+interpolate(-yb,yb,r[0]);
	return c;
    }

    

    public static Vector[] assemble(double[] bend,double[] pitch,double[][] c,double[] tilt) {

	int N=bend.length;
	
	Vector[] V=new Vector[2*N];
	double[] length=new double[N];
	for(int i=0;i<N;++i) length[i]=Math.sqrt(1+bend[i]*bend[i]);
	double x=0;
	double y=0;

	for(int i=0;i<N;++i) {
	   x=length[i]*Math.cos(pitch[i])/2;
	   y=length[i]*Math.sin(pitch[i])/2;
	   V[2*i+0]=new Vector(c[i][0]+x,c[i][1]+y,0);
	   V[2*i+1]=new Vector(c[i][0]-x,c[i][1]-y,0);
	}

	for(int i=0;i<N;++i) {
	   Vector[] W={V[2*i],V[2*i+1]};
	   Vector[] W2=tilt(W,tilt[2*i],tilt[2*i+1]);
  	   V[2*i+0]=new Vector(W2[0]);
	   V[2*i+1]=new Vector(W2[1]);
	}

	return V;
    }



    /**These are general routines which work in all cases*/
    public static double interpolate(double x0,double x1,double r) {
	return (1-r)*x0+r*x1;
    }

    public static Vector[] tilt(Vector[] V,double r1,double r2) {
	Vector[] W=new Vector[2];
	for(int i=0;i<2;++i) {
	    W[i]=new Vector(V[i]);
	}
	double s1=interpolate(-.25,.25,r1);
	double s2=interpolate(-.25,.25,r2);
	W[0].x[2]=s1;
	W[1].x[2]=s2;
	return W;
    }

    public static Vector[] tiltX(Vector[] V,double r1,double r2) {
	Vector W=Vector.plus(V[0].scale(1-r1),V[1].scale(r1));
	double d0=Vector.dist(W,V[0]);
	double d1=Vector.dist(W,V[1]);
	Vector X0=Vector.minus(V[0],W);
	Vector X1=Vector.minus(V[1],W);
	double c=Math.cos(Math.PI*r2/4);
	double s=Math.sin(Math.PI*r2/4);
	Vector Y0=new Vector(X0.x[0]*c,X0.x[1]*c,+d0*s);
	Vector Y1=new Vector(X1.x[0]*c,X1.x[1]*c,-d1*s);
	Y0=Vector.plus(W,Y0);
	Y1=Vector.plus(W,Y1);
	Vector[] Y={Y0,Y1};
	return Y;
    }


    
}

