import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class ControlCanvas extends ScaleCanvas implements MouseListener,MouseMotionListener,KeyListener {
    Manager M;
    SelectColor CS;
    ListenSquare GO,STOP;
    ControlPanel HALF,SIMPLIFY,LEVEL,STUDY,SIGNS,ANNEAL;
    ControlPanelColor DISPLAY;
    Animate1 AN1;
    ShapeEntryBasic[] SH=new ShapeEntryBasic[5];
    double BMAX,BMIN;
    String[] MESSAGE=new String[8];
    Complex OFFSET;
    PopupManager POP;
    EnhancedSlider[] ANN=new EnhancedSlider[2];
    
     public ControlCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 addKeyListener(this);
	 setScales(50,120,1000);
	 GO=new ListenSquare(445,300,35,20);
	 STOP=new ListenSquare(445,320,45,20);
	 AN1=new Animate1();
	 AN1.halt=true;
	 setPanels();
	 CS=new SelectColor(M,0,450,499,49);
	 ANN[0]=new EnhancedSlider(0,350,429,49,100,new Color(0,0,100),"anneal1");
	 SH[0]=new ShapeEntryBasic(330,30);
	 SH[1]=new ShapeEntryBasic(400,30);
	 SH[0].I[0].val=1;
	 SH[0].I[1].val=12;
	 SH[1].I[0].val=4;
	 SH[1].I[1].val=12;
	 BMAX=0;
	 BMIN=.5;
	 for(int i=0;i<8;++i) MESSAGE[i]="";
	 OFFSET=new Complex(0,0);
     }



    public void setPanels() {
	
       Color[] C0={new Color(80,120,255),
                   Color.white,
                   Color.white,
                   Color.black,
                   Color.white};
       
       Color[] C1={new Color(200,0,200),
                   Color.white,
                   Color.white,
                   Color.black,
                   Color.white};
	
	
        String[] LevelString={"reduced","actual","capacity"};
        int[] LevelState={1,0};
        LEVEL=new ControlPanel(C0,LevelString,LevelState,2);
	LEVEL.mode=0;

	

        String[] SimplifyString={"space",
				 "plane",
                              "version"};
        int[] SimplifyState={0,1};
        SIMPLIFY=new ControlPanel(C0,SimplifyString,SimplifyState,2);
	SIMPLIFY.mode=1;

        String[] AnnealString={"hill climb",
				 "anneal",
                              "search"};
        int[] AnnealState={1,0};
        ANNEAL=new ControlPanel(C0,AnnealString,AnnealState,2);
	ANNEAL.mode=0;



        String[] StudyString={"MAIN 1",
			      "FAIL",
			      "MAIN 2",
			      "AUX 1",
			      "AUX 2",
                              "calcs"};
        int[] StudyState={1,0,0,0,0};
        STUDY=new ControlPanel(C0,StudyString,StudyState,5);
	STUDY.mode=0;


	

        String[] DisplayString={"background",
				"convex hull",
				"bend01",
				"bend23",
				"bend45",
				"bend67",
				"bend89",
				"perimeter",
				"point guides",
				"display"};

       Color[] DisplayColor={
	   new Color(255,255,255),
	   new Color(200,200,200),
	   new Color(0,0,0,70),
	   new Color(0,0,255,70),
	   new Color(255,0,0,70),
	   new Color(0,0,0,70),
	   new Color(0,0,0,70),
	   new Color(0,0,0),
	   new Color(0,0,0,150)};
       
       int[] DisplayState={1,1,1,1,1,1,1,1,0};
        DISPLAY=new ControlPanelColor(C0,DisplayString,DisplayState,9,DisplayColor);
    }

    public int[] getSigns() {
	int[] A={1,1,1,1,1};
	for(int i=0;i<4;++i) {
	    if(SIGNS.L[3-i].on==0) A[i]=-1;
	}
	return A;
    }

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      drawControls(g);
      drawMessage(g);
   }

    public void drawBG(Graphics2D g) {
	g.setColor(new Color(0,120,120));
      g.fillRect(0,0,getWidth(),getHeight()); 
    }

    public void drawMessage(Graphics2D g) {
	g.setColor(Color.white);
	g.setFont(new Font("Helvetica",Font.PLAIN,15));
	for(int i=0;i<7;++i) g.drawString(MESSAGE[i],10,235+18*i);
    }



    
    public void drawControls(Graphics2D g) { 
	if(AN1.halt==true)  GO.render(g,"go",12,4,new Color(0,180,0));
        else  STOP.render(g,"stop",12,4,new Color(200,0,0));
      DISPLAY.render(g,90,0,120);
      POP.render(g);
      STUDY.render2(g,5,115,80);
      LEVEL.render(g,5,5,80);
      SIMPLIFY.render(g,5,60,80);
      ANNEAL.render(g,90,160,120);
      CS.render(g);
      for(int i=0;i<2;++i) SH[i].render(g);
      if(ANNEAL.mode==1) {
         ANN[0].render(g);
      }

      g.setFont(new Font("Helvetica",Font.PLAIN,15));
      g.setColor(Color.white);
      g.drawString("bend pitches",350,20);
     }
    
    public void setStudy(Point X) {
	int mode=STUDY.switchMode(X);
	if(mode==-1) return;
	int[][] A={{1,12,6,12},{1,12,7,12},{-1,3,1,6},{1,24,4,12},{-1,24,4,12}};
	int[] B=A[mode];
 	 SH[0].I[0].val=B[0];
	 SH[0].I[1].val=B[1];
	 SH[1].I[0].val=B[2];
	 SH[1].I[1].val=B[3];
    }

    public int[][] loopOrder() {
    	int[][] A0={{0,2,4,6,1},{1,3,5,7,0},{1,1,-1,-1,1}};
	int[][] A1={{0,2,6,4,1},{1,3,7,5,0},{1,1,-1,-1,1}};
	int[][] A2={{0,2,7,5,1},{1,3,6,4,0},{1,-1,-1,1,1}};
    	int[][] A3={{0,2,4,6,1},{1,3,5,7,0},{1,1,-1,-1,1}};//=A0
	int[][] A4={{0,2,6,4,1},{1,3,7,5,0},{1,1,-1,-1,1}};//=A1
	int mode=STUDY.mode;
	if(mode==0) return A0;
	if(mode==1) return A1;
	if(mode==2) return A2;
	if(mode==3) return A3;
	if(mode==4) return A4;
	return null;
    }

    public int[][] loopOrderShort() {
	int[][] A=loopOrder();
	int[][] B={A[0],A[1]};
	return B;
    }

    public int[] divider() {
	int[] A={6,7};
	int[] B={4,5};
	if(STUDY.mode==0) return A;
	if(STUDY.mode==3) return A;
	return B;
    }
    
        
    public void doAnimate() {
	if(AN1.halt==false) return;
	AN1=new Animate1(this.M);
	new Thread(AN1).start();
    }
    
    public void mouseClicked(MouseEvent e) {
        MouseData J=MouseData.process(e);
	    for(int i=0;i<2;++i) SH[i].processMouse(e);
	   if(GO.inside(J.X)==1) doAnimate();
	   if(STOP.inside(J.X)==1) AN1.halt=true;
	   LEVEL.switchMode(J.X);
	   SIMPLIFY.switchMode(J.X);
	   ANNEAL.switchMode(J.X);
	   CS.process(e);
	   DISPLAY.process(J.X,CS.C);
	   POP.process(J.X);
	   setStudy(J.X);
           M.repaint();
	   ANN[0].configure(J.X);
	  if(J.mode==1)  scaleUp(J.X,0);
          if(J.mode==3)  scaleUp(J.X,1);
          if(J.mode==2)  {
	  SOURCE=unTransform(J.X);
	}
	M.repaint();
	doTest();
    }
    

    public void mousePressed(MouseEvent e) {
	MouseData J=MouseData.process(e);
	ANN[0].activate(J.X);
    }
    
     public void mouseReleased(MouseEvent e) {}
     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   
     public void mouseMoved(MouseEvent e) {}    
     public void mouseDragged(MouseEvent e) {
        MouseData J=MouseData.process(e);
	CS.process(e);
	ANN[0].configure(J.X);
	M.repaint();

     }
    
     public void keyPressed(KeyEvent e) {}
     public void keyReleased(KeyEvent e) {}
     public void keyTyped(KeyEvent e) {	
         for(int i=0;i<2;++i) SH[i].processKey(e);
	 if(e.getKeyChar()=='a') BMIN=SOURCE.x;
	 if(e.getKeyChar()=='s') BMAX=SOURCE.x;
	 M.repaint();
     }

    public void doTest() {

	double[] X={0.0305807, 0.0175442, 0.00623898, -0.0422368, -0.0419074, -0.0163371, -0.0259394, -0.0348404, -0.0241197, 0.036127, -0.0442321, 0.0216671, -0.0214082, -0.00833935};


	double c=0;
	c=Tensegrity2.capacity1(X);
	//   System.out.println("cap1 "+c);


	c=Tensegrity2.capacity2(X);
	//    System.out.println("cap2 "+c);


	c=Tensegrity2.capacity3(X);
	//    System.out.println("cap3 "+c);

    }

}

